/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: ascii.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: ASCII Character Table Tools
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/



// wp.genPassword(Chars,Letters,Numbers,MixedCase,Punctuation)
// Defaults:
//	Chars: 8
//	Letters: True
//	Numbers: True
//	Mixed Case: True
//	Punctuation: False

// Returns ASCII Table information 

wp.dependencies("string,math");

wp.extend({
	htmlAsciiTable:function(){
		var O="",a;
		//c=c?c:8;
		
		for(a=1;a<=256;a++)
		{
			//alert(a + " - " + wp.chr(a))
			O+=a+ " - " + wp.chr(a)+"<BR>";
		}
		//alert(O)

		return(O);
	},
	makeWords:function()
	{
		var words=80,output="",letters=oldletters=1,a;
		
		for(a=0;a<words;a++){
			while(letters==oldletters){
				letters=wp.rand(1,10) // eliminate duplicate letter counts
			}
			word="";
			for(b=0;b<letters;b++){
				word+="x"
			}
			
			output+=word+" "
			oldletters=letters;
		}
		
		return output
	}
})

/*
    "a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z"


[a]=" ,b,c,d, ,f,g, ,i,j,k,l,m,n, ,p,q,r,s,t, ,v,w,x, ,z" - a
[b]="a, , , ,e, , , ,i, , ,l, , ,o, , ,r, , ,u, , , ,y, " - b
[c]="a, , , ,e, , ,h,i, , ,l, , ,o, , ,r, , ,u, , , ,y, " - c
[d]="a, , , ,e, , , ,i, , , , , ,o, , ,r, , ,u, ,w, ,y, " - d
[e]=" ,b,c,d, ,f,g, , ,j,k,l,m,n, ,p, ,r,s,t,u,v,w,x, ,z" - e
[f]="a, , , ,e, , , ,i, , ,l, , ,o, , ,r, , ,u, , , , , " - f
[g]="a, , , ,e, , , ,i, , ,l, , ,o, , ,r, , ,u, , , ,y, " - g
[h]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , , , " - 
[i]=" ,b,c,d, ,f,g,h, ,j,k,l,m,n, ,p, ,r,s,t, ,v,w,x, ,z" - i
[j]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , , , " - 
[k]="a, , , ,e, , , ,i, , ,l, , ,o, , ,r, , ,u, , , ,y, " - 
[l]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , ,y, " - l
[m]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , ,y, " - m
[n]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , ,y, " - n
[o]=" ,b,c,d, ,f,g, , , ,k,l,m,n, ,p, ,r,s,t,u,v,w,x, ,z" - o
[p]="a, , , ,e, , ,h,i, , ,l, , ,o, , ,r, , ,u, , , ,y, " - p
[q]=" , , , , , , , , , , , , , , , , , , , ,u, , , , , " - 
[r]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , ,y, " - 
[s]="a, ,c, ,e, , ,h,i, ,k,l,m,n,o,p,q, , ,t,u, , , ,y, " - s
[t]="a, , , ,e, , ,h,i, , , , , ,o, , ,r, , ,u, , , ,y, " - t
[u]=" ,b,c,d,e, ,g, , , ,k,l,m,n, ,p, ,r,s,t, ,v, , , ,z" - 
[v]="a, , , ,e, , , ,i, , , , , ,o, , ,r, , ,u, , , ,y, " - 
[w]="a, , , ,e, , ,h,i, , , , , ,o, , ,r, , ,u, , , , , " - 
[x]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , , , " - 
[y]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , , , " - 
[z]="a, , , ,e, , , ,i, , , , , ,o, , , , , ,u, , , , , " - 

*/