/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: caret.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs String manipulation module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.extend(
{
	caret:{},
	getSelection:function(a){
		var D,o,t,r,ec,h,A,b,e,N=[],Win;
		D=document;
		if(a)D=a.document
		if(window.getSelection){
			t="dom"
			D=window;
			if(a)D=a.window;
			Win=D
			o=D.getSelection();
			r=o.getRangeAt(0);
			
			if(r&&r.cloneContents())
			{
				ec=r.cloneContents().childNodes
				h=""
				for(a=0;a<ec.length;a++){
					if(ec[a].nodeType==1){
						A="";
						for(b=0;b<ec[a].attributes.length;b++){
							A=A+" "+ec[a].attributes[b].nodeName+"=\""+ec[a].attributes[b].nodeValue+"\"";
						}
						h=h+"<"+ec[a].nodeName+A+">"+ec[a].innerHTML+"</"+ec[a].nodeName+">"
					}
					if(ec[a].nodeType==3)h=h+ec[a].nodeValue
				}
			}
			e=r.commonAncestorContainer;
		}
		else if(document.selection){
			t="msie";
			var W=window;
			if(a)W=a.window;
			Win=W
			if(wp.msie&&W.r)W.r.select(); // Ensure that IE doesn't lose focus	
			r=D.selection.createRange();
			e=r.item?r.item(0):r.parentElement()
			
			o=r.text;
			h=r.htmlText;
		}
		else return;

		var r2,N=[],E,x;
		if(e.nodeType==3){
			var tst=wp.trim(e.nodeValue);
			if(h==tst){
				N.push(e.parentNode);
			}else{
				var t1=h.split("<")[0];
				if(t1){
					var O=document.createTextNode(t1);
					N.push(O);
				}
			}
		}
		else{
			E=e.getElementsByTagName("*");
			if(E.length==0&&e.tagName){
				N.push(e);
			}
			else{
				if(h&&E.length>0){
				
					var t1=h.split("<")[0];
					if(t1){
						var O=document.createTextNode(t1);
						N.push(O);
					}
	
					for(x=0;x<E.length;x++){
						r2=wp.createRangeFromElement(E[x],Win);
		            	if(r2&&wp.compRng(r,r2,E[x])){
		            		N.push(E[x]);
		            		if(E[x].nextSibling&&E[x].nextSibling.nextSibling&&E[x].nextSibling.nodeType==3){
		            			if(wp.compRng(r,wp.createRangeFromElement(E[x].nextSibling.nextSibling,Win))){
		            				N.push(E[x].nextSibling);
		            			}
		            		}
		            	}
					}
					
					var t1=h.split(">");
					t1=t1[t1.length-1];
					if(t1){
						var O=document.createTextNode(t1);
						if(N.length&&N[N.length-1].nodeType==1)N.push(O);
					}
				}
			}
		}
			
			
			
			/*
							wp.get("ta2").value=""
							for(a=0;a<N.length;a++){
								tt=" - '"
								if(N[a].nodeType==3)tt+=N[a].nodeValue+"' - "
								if(N[a].nodeType==1){
									tt+=N[a].tagName+"' - "
								}
								if(N[a].className)tt+=N[a].className
								wp.get("ta2").value+=N[a]+" - "+tt+"\n"
							}
			*/
			
			if(!e.tagName)e=e.parentNode;
			if(N.length==1)e=N[0]
			
		return {selection:o,type:t,range:r,html:h,element:e,nodes:N}
	},	

	pasteHTML:function(v,w)
	{
		var W=w,t,A,nC,tnC,nde
		if(!w)w=self;
	 	t=wp.getSelection(w);
		w=w.document;
		if(t.type=="dom"){
			if(t.text.getRangeAt)range=t.range
			range.deleteContents();
			var nC=w.createElement("p");
			nC.innerHTML=v;
			range.insertNode(nC)
			wp.each(nC.childNodes,function(a,i){
				if(tnC)nde=tnC; else nde=nC;
				if(a[i].tagName){
					tnC=w.createElement(a[i].tagName);
					wp.insertNode(tnC,nde,0)
					if(a[i].innerHTML)tnC.innerHTML=a[i].innerHTML;
					wp.each(a[i].attributes,function(s,o){
						if(s[o].name){
							tnC.setAttribute(s[o].name,s[o].value)
						}
					})
				}
			})
			wp.removeNode(nC)
			// Move cursor to the end of new html
			range.selectNode(tnC);
			range.collapse(0);
			t.text.removeAllRanges();
			t.text.addRange(range);
		}
		else if(t.type=="msie"){
			t.range.pasteHTML(v);
			t.range.move('character', -1);
			t.range.move('character', 1);
			t.range.select();	
		}
	},
	pasteText:function(v,after,w)
	{
		var W=w,t,A,nC
		if(!w)w=self;
	 	t=wp.getSelection(w);
		//w=w.document;
		if(t.type=="dom"){
			var range = w.getSelection().getRangeAt(0);
			var node = w.document.createTextNode(v);
			var selct = w.getSelection();
			var range2 = range.cloneRange();
			// Insert text at cursor position
			selct.removeAllRanges();
			range.deleteContents();
			range.insertNode(node);
			// Move the cursor to the end of text
			range2.selectNode(node);
			range2.collapse(after);
			selct.removeAllRanges();
			selct.addRange(range2);
			//alert(99)
				
			//if(t.text.getRangeAt)range=t.range
			//range.deleteContents();
			//var nC=w.createTextNode(v)
			
			//range.insertNode(nC)
			//alert(nC)
			
			//var nC=w.createElement("span");
			//nC.innerHTML=v;
			//range.insertNode(nC)

			//var h=nC.parentNode.innerHTML
			//h=h.replace(/<[^>]+>/i,'');
			//var pos=h.toLowerCase().lastIndexOf("span")
			//h=h.substr(0,pos-2)+h.substr(pos+5)
			//nC.parentNode.innerHTML=h
		}
		else if(t.type==2){
		}
		else if(t.type=="msie"){
			var repdeb = '';
			var repfin = '';
			
			if(after) { repfin = v; }
			else { repdeb = v; }
	
			if(typeof document.selection != 'undefined') {
				var range = document.selection.createRange();
				range.text = repdeb + repfin;
				range = document.selection.createRange();
				range.move('character', -repfin.length);
				range.select();	
			}	

			
			//t.range.pasteHTML(v);
		}
		
	},	
	insertAtCaret:function(v,e)
	{
		//var K=e.which?e.which:e.keyCode,
		var E=wp.getE(e);
		sel=wp.getCaret(E)

		if(wp.msie){
			var R=document.selection.createRange().duplicate();
			R.text=v;
			R.select();
		}else{
			var sT=E.scrollTop,
				beginText=E.value.substring(0,sel.start),
				endText=E.value.substring(sel.start+(sel.end-sel.start))
			
			E.value=beginText+v+endText
			
			//if(window.opera){
//				document.title=sel.start+" - " + sel.end
				//alert(v.length)
			//}
			
			wp.setCaret(E,sel.start+v.length,sel.start+v.length)
			E.scrollTop=sT
		}
	},
	textSelection:function(E){
		var sel=wp.getCaret(E),T="",ar
		if(E.tagName=="TEXTAREA" || E.tagName=="INPUT"){
			T=E.value
		}
		else{
			T=E.innerHTML
		}
		if(!window.opera)T=wp.str_replace("\r","",T);
		ar=T.substring(0,sel.end).split("\n");
		return {
			text:T.substring(sel.start,sel.end),
			line:ar.length,
			array:T.split("\n"),
			lineText:ar[ar.length-1],
			col:ar[ar.length-1].length+1,
			start:sel.start,
			end:sel.end
		}
	},
	lineNumbers:function(E){
		if(E.tagName=="TEXTAREA" || E.tagName=="INPUT"){
			T=E.value
		}
		else{
			T=E.innerHTML
		}
		return T.split("\n").length
		
	},
	getCaret:function(I)
	{
		var S,E;
		if(window.getSelection){
			//document.title=I.selectionStart+" - " + I.selectionEnd
			//wp.debug.objects(I)
			if(I.tagName=="TEXTAREA"||I.tagName=="INPUT"){
				S=I.selectionStart
				E=I.selectionEnd
			}else{
 				var sel=window.getSelection().getRangeAt(0);
        		S=sel.startOffset;
        		E=sel.endOffset;				
			}
		}
		else{
			// Massively Over complicated Internet Explorer Bit
			var X=document.selection.createRange(),L,crc,sc,ec
			if(I.tagName=="TEXTAREA"){
				L=I.innerText.length;
				var R=X.duplicate();
				R.moveToElementText(I);
				R.setEndPoint('StartToStart',X);
				S=L-R.text.length
				E=S+X.text.length;
				crc=I.innerText.substr(0,S).split("\n").length-1;
				sc=crc;
				ec=crc;
				if(X.text)ec=ec+(X.text.split("\n").length-1)
				S=S-sc;
				E=E-ec;
			}
			else if(I.tagName=="INPUT"){
				L=wp.trim(I.value).length;
				S=Math.abs(X.moveStart("character", -L));
				E=Math.abs(X.moveEnd("character", -L));
			}
			else{
				L=wp.trim(I.innerText).length;
				var R=X.duplicate();
				R.moveToElementText(I);
				R.setEndPoint('StartToStart',X);
				S=L-R.text.length
				E=S+X.text.length;
			}
		}
		
		if(window.opera){
			
			//E=E-I.value.substring(0,E).split("\r").length+1
			//S=S-I.value.substring(0,E).split("\r").length+1
		}
		
		return {start:S,end:E}
	},

	setCaret:function(I,a,b)
	{
		if(!b)b=a
		if(I.setSelectionRange)
		{
			I.focus();
			// Opera includes a line feed return when specifying setSelectionRange - need to scan the document to see where the line feeds are and adjust variables a and b to suit
			if(window.opera && I.value.charCodeAt(b)==9){
				//var W=wp.chr(8),R=new RegExp(W,"gm"),i=I.value,A,B;
				//i=i.replace(/\r\n/gm,W);
				//var A=i.substr(0,a);
				//A=A.split(R).length-1;
				//B=i.substr(a,b-a);
				//a=a+A;
				//b=b+B.split(R).length+A-1;
				//i=i.replace(R,"\n")
//document.title=a+" - " +b
				
				a++;
				b++;
			}
			I.setSelectionRange(a,b);
		}
		else if(I.createTextRange)
		{
			var r=I.createTextRange();
			r.collapse();
			r.moveStart("character",a);
			r.moveEnd("character",(b-a));
			r.select();
		}
	},
	moveCaret:function(){
		
	},
	getCaretLine:function(v)
	{
		if(v.tagName!="TEXTAREA")return v;
		var C=wp.getCaretLineNumber(v);
		
		var S=v.value.split("\n");
		S=S[C-1].replace(/\r/g, "")
		return S;
	},
	getCaretLineNumber:function(v){
		return wp.textSelection(v).line
	},
	getCaretCol:function(v){
		return wp.textSelection(v).col
	},	
	insertTextAtCaret:function(O,txt){
		var sel;
		O.focus();
		if(document.selection){
			sel=document.selection.createRange();
			sel.text=txt;
		}
		else if(O.selectionStart||O.selectionStart=='0'){
			var sPos=O.selectionStart,sT=O.scrollTop,sL=sPos+txt.length;
			O.value=O.value.substring(0,sPos)+txt+O.value.substring(O.selectionEnd,O.value.length);
			O.selectionStart=sL;
			O.selectionEnd=sL;
			O.scrollTop=sT;
			}
		else{
			O.value+=txt;
		}
	}
})