/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: collision.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Collision detection and re-positioning module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("position");

wp.extend(
{
	collision:{},
	checkCollision:function(o)
	{
		
		var B=wp.clientDims(),P,T,L,c;
		wp.each(this.v,function(a,i){
			P=wp.getLoc(a[i])
			/*
				o can be either l, t, lt or null - l means do not do left collision, t means do not do top collision, lt means do neither, null (default) means do both top and left collision detection
			*/

//alert(B.height + " - " + P.height)

			if(!o.match("l")&&(P.left+P.width)>B.width+B.scrollLeft){
				if(a[i].webplug=="menu"){
					if(a[i].parentItem.thisMenu.className.match("hMenu")){
						L=parseInt(a[i].style.left)+(B.width+B.scrollLeft)-(P.left+P.width)
					}
					else{
						L=a[i].parentItem.thisMenu.offsetLeft-P.width
						L=L+10 // Make slight adjustment to force an overlap on menus
					}
				}
				else{
					c=(P.left+P.width)-(B.width+B.scrollLeft)
					L=a[i].offsetLeft-c
				}
				if(a[i].wpShadow)L=L-wp.css.pInt(a[i].wpShadow,"margin-top")
			}

			if(!o.match("t")&&(P.top+P.height)>(B.height+B.scrollTop)){
				var aa=(P.top+P.height)-(B.height+B.scrollTop)
				T=parseInt(a[i].style.top)-aa
				if(a[i].wpShadow)T=T-wp.css.pInt(a[i].wpShadow,"margin-top")
			}
//			L=L-24
			wp(a[i]).setPosition({top:T,left:L})
			
			if(a[i].IF_)wp(a[i].IF_).setPosition({top:T,left:L})
		})
	}		
})
