/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: css.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs CSS manipulation and querying module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.extend(
{
	css:
	{
		get:function(v,s,out){
			/* Make sure that values passed are in correct css format, for example: background-color instead of backgroundColor */
			

			
			
			//
			
			if(v.currentStyle){
				out=v.currentStyle[wp.css.camel(s)];
				if(out===undefined)out="auto"
				return out;
			}
			else if(document.defaultView&&document.defaultView.getComputedStyle){
				out=""
				
				if((s=="height"||s=="width") && !v.style[s]){
					out="auto"
				}
				else{
					out=document.defaultView.getComputedStyle(v,null).getPropertyValue(s);
				}
				
				return out;
			}
			else{
				//alert(wp.css.get.caller)
				//alert(s)
				return v.style[s];
			}
		},
		toggleDisplay:function(o,D){
			if(wp.css.get(o,"display")=="none")
				D="block";
			else
				D="none";
			o.style.display=D;
			return D
		},
		getInlineStyle:function(v){
			if(wp.msie){
				return v.style.cssText
				//var m=/style=\"(.*)\"/.exec(v.outerHTML)
				//if(m)return m[1];
			}
			else{
				if(v.attributes['style'])return v.attributes['style'].value
			}
			return null
		},
		add:function(o,s) // theme, style
		{
			/*
			Types of webplugs style:	
				theme
				style
				styleSheet
				themeStyle
			*/
			
			if(o.theme=="null")return
			var t,fileName=wp.getPath()+"themes/";
			if(o.style){
				t=o.style
				fileName+="styles/"+s+"/"+t+"/"+s+".css"
				
//				alert("css.js line 30 - need to see if o.style will work - even though o.style should conflict with the objects STYLE\n\n"+fileName)
				
				
			}
			else if(o.theme){
				var s2=s,tS=o.themeStyle;
				t=o.theme;
				if(tS){
					if(tS==t)return
					s=tS;
					if(tS)o.theme=tS;
				}
				fileName+=t+"/"+s2+"/"+s+".css";
			}
			else if(o.styleSheet){
				fileName=o.styleSheet
				t=""
			}
			else if(typeof(o)=="string"){
				fileName=o
				t=""
			}
			else
			{
				if(o.theme===null)return
				t="styles"
				fileName+=t+"/"+s+"/"+s+".css"
			}
			
			if(!wp.inc[fileName]){
				//alert(fileName)
				if(typeof(t)!="string")return
				var S=document.createElement("LINK");
				S.href=fileName;
				S.rel="stylesheet";
				S.webplugs=1;
				S.type="text/css";
				document.getElementsByTagName('HEAD').item(0).appendChild(S);
				wp.inc[fileName]=1;
			}
		},
	  	box:function(v,P,N) // v is HTML Object to get params for, P (enabled) is to remove dimensions - by default we assume pixels, N is the HTML object we want to transfer values to
	  	{
	  		/*
				 0 padding-top
				 1 padding-right
				 2 padding-bottom
				 3 padding-left
				 4 margin-top
				 5 margin-right
				 6 margin-bottom
				 7 margin-left
				 8 border-top-width
				 9 border-right-width
				10 border-bottom-width
				11 border-left-width
	  		*/

var A=["padding-top","padding-right","padding-bottom","padding-left","margin-top","margin-right","margin-bottom","margin-left","border-top-width","border-right-width","border-bottom-width","border-left-width"],O={},V	  		
	  		wp.each(A,function(a,i){
	  			V=wp.css.get(v,a[i])
	  			
	  			if(N){
	  				//alert(a[i]+" - " +V)
	  				N.style[wp.css.camel(a[i])]=V
	  			}
	  			
	  			if(!P)V=parseInt(V);
	  			O[i]=V?V:0;
	  		})
	  		return O
	  	},
	  	xfer:function(o,n){
			var V=wp.css.getInlineStyle(o);
			if(V)wp(n).strCSS(V);
	  	},
	  	pInt:function(v,s){
	  		if(v.nodeType==3)alert("Bad NodeType in css.pInt")
	  		var o=parseInt(wp.css.get(v,s));
	  		
	  		if(isNaN(o)){
	  			if(s=="width")o=v.offsetWidth
	  			if(s=="height")o=v.offsetHeight
	  		}
	  		
	  		return isNaN(o)?0:o=o;
	  	},
		camel:function(v)
		{
			//v=v.replace(/\s+/g,"")
			
			return v.replace(/\s+/g,"").toLowerCase().replace(/\-(\w)/g,function(_,c){return c.toUpperCase()})
	  	},
		clear:function(v)
		{
			var V=v.style,a
			for(a in V){
				try{V[a]=null}catch(err){}
			}
		},
		trim:function(v)
		{
			return v.replace(/^\s+|\s+$/g,'');
		},
		remove:function(e,v)
		{
			var A=e.childNodes,a
			for(a=0;a<A.length;a++){
				if(A[a].nodeType==1){
					A[a].style[wp.css.camel(v)]=""
					if(A[a].childNodes.length>0){
						wp.css.remove(A[a],v)
					}
				}
			}
		}
	}
})

wp.extend(
{

	strCSS:function(v)
	{
		var x,y,O,s;
		v=v.split(";");
		wp.each(this.v,function(a,i){
			for(x=0;x<v.length;x++){
				s=v[x].split(":");
				
				var V=s[1]
				if(V){
					V=wp.css.trim(V.replace(/\!|important/g,""))
					a[i].style[wp.css.camel(s[0])]=V;
				}
			}
		})
		return this
	},
	addCSSName:function(v){
		//wp(this.v).delCSSName(v);
		wp.each(this.v,function(a,i){
			var re=new RegExp(v,"g")
			
			if(!a[i].className.match(re)){
				a[i].className=wp.css.trim(a[i].className+" "+v)
			}
		})
		return this
	},
	delCSSName:function(v){
		wp.each(this.v,function(a,i){
			var C=a[i].className;
			if(C)a[i].className=wp.css.trim(C.replace(new RegExp(v,"g"),""));
		})
		return this
	},
	swapCSSName:function(o,n)
	{	
		wp.each(this.v,function(a,i){
			wp(a[i]).delCSSName(o)
			wp(a[i]).addCSSName(n)
		})
		return this
	},
	applyCSS:function(v)
	{
		var x,O;
		wp.each(this.v,function(a,i){
			for(O in v)a[i].style[O]=v[O];
		})		
		return this
	},
	removeCSS:function(v)
	{
		var x,O;
		wp.each(this.v,function(a,i){
			wp.css.remove(a[i],v);
		})		
		return this
	},
	matchCSS:function(o,c) // Looks for a match(c) inside the classname of o
	{
		var A=new RegExp(c),O;
		if(o&&o.className)O=o.className.search(A);
		if(typeof(O)=="undefined")O=-1
		return O;
	},
	getScrollbarSize:function()
	{
		if(!wp.scrollbarSize){
			var D=wp.addNode("div"),S=D.style
			D.innerHTML=wp
			S.overflow="scroll";
			S.width="100px";
			wp.scrollbarSize=(D.offsetWidth-D.clientWidth)
			wp.removeNode(D)
		}
		return wp.scrollbarSize;
	}
})