/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: effect.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Special Effects module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


/*

status'

1: in action currently running
2: out action currently running
3: paused
4: completed


events:
    onstart
    onfinish
    onpause

*/

wp.dependencies("css,easing");

var refPointsDELETE="",tempFPS=20,tempFrames=40,tempEff="easeIn" // real slow
var refPointsDELETE="",tempFPS=4,tempFrames=3,tempEff="linear"
var refPointsDELETE="",tempFPS=200,tempFrames=50,tempEff="easeIn" // normal


wp.extend({
	animate:function(O,T,E,S)
	{	
		if(!O.fx)O.fx={}
		var OT=O.wpFx[T],delay=1000/OT.fps,now=new Date(),gap=now-OT.start,V,Frames=OT.frames,status=1;
		if(OT.action=="out")status=2
		if(O.master){
			var wpTtype=O.master.webplug,typ=0
			if(wpTtype=="menu"||wpTtype=="tree"||wpTtype=="collapse")typ=1;
		}
		//alert(S+" - " + OT.comp + " - " + OT.change + " - " + OT.action + " - " + (OT.comp==OT.change) + " - " + typ)
		//document.title+="1"
		
		//wp.get("andy").innerHTML=wp.get("andy").innerHTML+"<hr>"+wp.animate.caller
		//wp.get("andy").innerHTML=wp.get("andy").innerHTML+"<hr>"+O.parentItem.innerHTML+" - " +OT.action + " - " +  wp.animate.caller
		
		
		if(S&&OT.comp==OT.change){
			if(typ&&OT.action=="in"){
				//alert(OT.comp)
				//O.master.openSubs++
				//O.style.display="block";
			}
			

			if(OT.action=="in"){
				
				if(O.fx.count==0&&O.fx.onbegin)O.fx.onbegin()
			}


			
			//if(OT.oncomplete)OT.oncomplete()
			
			O.fx.status=status
			//if(O.fx.status==1)O.master.openSubs++
			if(!O.fx.count)O.fx.count=0
			O.fx.count++
			if(E.onstart)E.onstart(O)
		}
		
		//clearTimeout(OT.sto)
		
		
		
		
		
		
		if(now-OT.start<delay*Frames){
			//	Alert(OT.easing)
			V=wp.easing[OT.easing](Math.round(gap/delay),OT.begin,OT.finish-OT.begin,Frames);
			
			
			
			if(V!=OT.finish)OT.sto=setTimeout(function(){wp.animate(O,T,E)},delay);
			
			//alert(V+" - " + OT.easing  + " - " + gap + " - " + delay + " - " + OT.begin + " - " + OT.finish + " - "+ Frames +" - " +  Math.round(gap/delay))
			
			
		}
		else{
			
			V=OT.finish;

		}


/*
			if(!OT.aa)OT.aa=0
			OT.aa++
			V=wp.easing[OT.easing](OT.aa,OT.begin,OT.finish-OT.begin,Frames);
			if(V!=OT.finish)OT.sto=setTimeout(function(){wp.animate(O,T,E)},delay);
*/

		
		if(OT.change=="height"){
			refPointsDELETE=refPointsDELETE+OT.change+" - "+V+" -- "+OT.begin+" -- "+OT.finish+" -- "+Math.round(gap/delay)+" - " + delay+"\n"
			//refPointsDELETE=refPointsDELETE+OT.change+" - "+V+" -- "+OT.finish+"\n"
		}
		
		if(OT.change=="opacity"){
			if(!isNaN(V))wp(O).opacity(V);
		}
		else{
			if(wpTtype=="menu"&&(T=="height")){
				
				//alert(O.fsM)
				if(!O.fsM){
					O.childNodes[0].style[wp.css.camel(OT.change)]=wp.px(V);
					//alert(wp.css.camel(OT.change))
					//alert(wp.px(V))
					
				}
				else{
					O.style.overflow="hidden"
				}
			}
			O.style[wp.css.camel(OT.change)]=wp.px(V);
		}
		
		
		
		//alert(OT.comp+" - " + OT.change +" - " + V +" - " + OT.finish)
		if(V==OT.finish&&OT.comp==OT.change){
			//alert(OT.oncomplete)
			
			
			
			
			
			//if(OT.oncomplete)OT.oncomplete(O)
			
			
			if(O.aH&&OT.action=="in"&&OT.change=="height"){
				O.style.height="auto";
			}
			
			if(typ&&OT.action=="out"){
				//O.style.display="none";
				
				//if(wpTtype=="menu"){
					//wp.debug.objects(O)
					
					//alert(O.parentItem.mainMenu)
					
					//if(O.fx.status==2)O.master.openSubs--
					
					//alert(O.master.openSubs)
					//alert(O.fx.status)
					//alert(O.parentItem.mainMenu)
					//if(O.parentItem.thisMenu.mainMenu){
						
						//O.master.style.zIndex=1;
					//}
					
					//if(O.master.openSubs<=0){
						//O.master.style.zIndex=1;
						//O.master.openSubs=0
					//}
					
					//wp.imask.hide(O);
				//}
				//document.title=O.master.openSubs + " -  "+ O.fx.status
			}
			
			
			
			
			
			O.fx.count--
			O.fx.status=4
			
			if(OT.action=="out"){

				if(O.fx.count==0&&O.fx.oncomplete)O.fx.oncomplete()
			}
			
			
/*
		if(OT.change=="opacity"){
			O.style.filter=""
		}
*/
			
			
			
			//document.title=O.fx.count
			if(O.oncomplete)O.oncomplete(O)
			
			if(OT.onfinish)OT.onfinish()
		}
		return this
	},
	stop:function(v)
	{
		wp.each(this.v,function(a,i){
			var OT=a[i].wpFx[v]
			if(OT){
				clearTimeout(OT.sto)
				a[i].status=3
				if(OT.onpause)OT.onpause()
			}
		})
	},
	opacity:function(o)
	{
		wp.each(this.v,function(a,i,V){
			V=a[i].style;
			if(o>1)o=1;
			if(o<0)o=0;
			if(wp.msie){
				V.zoom=1;
				V.filter=V.filter.replace(/progid\:DXImageTransform\.Microsoft\.alpha\([^)]*\)/i,"")
				if(o<1)V.filter="progid:DXImageTransform.Microsoft.alpha(opacity="+o*100+")"+V.filter;
			}
			V.opacity=o;
		})
		return this;
	},
	fadeOut:function(o)
	{
		if(!o)o={}; 
		o.action="out";
		wp(this.v).fade(o);
		return this;
	},
	fadeIn:function(o)
	{
		if(!o)o={};
		o.action="in";
		wp(this.v).fade(o);
		return this;
	},
	fade:function(ob)
	{
		var O,e,E;
		if(!ob.frames)ob.frames=tempFrames;
		if(!ob.fps)ob.fps=tempFPS;
		//if(!ob.easing)ob.easing="easeInCirc";
		if(!ob.easing)ob.easing=tempEff;
		wp.each(this.v,function(a,i){
			O=a[i];
			if(!O.wpFx)O.wpFx=[];
			E=O.wpFx['fade']={}
			for(var i in ob)E[i]=ob[i]
			if(ob.action=="in"&&!O.fx)wp(O).opacity(0);
			var from=1;
			var opac=wp.css.get(O,"opacity");
			if(opac||opac==0)if(opac=="auto")from=1;else from=(opac*1);
			E.begin=from;
			if(!ob.stop){
				ob.stop=1;
				if(ob.action=="out")ob.stop=0;
			}
			E.finish=ob.stop
			E.change="opacity";
			E.start=new Date();
			E.comp="opacity"
			wp.animate(O,"fade",E,1);
		})			
		return this;
	},
	effect:function(ob)
	{
		var O,e,E;
		if(!ob.frames)ob.frames=tempFrames;
		if(!ob.fps)ob.fps=tempFPS;
		//if(!ob.easing)ob.easing="easeInCirc";
		if(!ob.easing)ob.easing=tempEff;
		
		
		//alert(ob.frames + " - " + ob.fps)
		
		wp.each(this.v,function(a,i){
			O=a[i];
			if(!O.wpFx)O.wpFx=[];
			E=O.wpFx[ob.change]={};
			for(var i in ob)E[i]=ob[i]
			E.begin=wp.css.pInt(O,ob.change);
			E.finish=parseInt(ob.stop);
			E.change=ob.change;
			//alert(E.oncomplete)
			E.action=ob.action
			E.start=new Date();
			wp.animate(O,ob.change,E,1);
		})

		return this
	},
	slideOut:function()
	{
		wp(this.v).slide({action:"out"})
		return this
	},
	slideIn:function()
	{
		wp(this.v).slide({action:"in"})
		return this
	},
	slide:function(o)
	{
		var O={},P=["width","padding-left","padding-right"];
		if(!o)o={};
		o.P=P
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		//if(!o.easing)o.easing="easeInCirc";
		if(!o.easing)o.easing=tempEff;

		wp.each(this.v,function(a,i){
			//if(o.action=="in" && wp.css.get(a[i],"display")=="none")a[i].style.display="block"; // if object is hidden need to show it (normally a hidden menu)
			if(!a[i].fx)a[i].fx={}
			if(!a[i].fx.width){
				a[i].fx.width=wp.css.pInt(a[i],P[0]);
				a[i].fx.paddingLeft=wp.css.pInt(a[i],P[1]);
				a[i].fx.paddingRight=wp.css.pInt(a[i],P[2]);
				//a[i].slide=O;
			}
			var sPL,sPR;
			if(o.action=="out"){
				if(!o.stop)o.stop=0;
				sPL=0;
				sPR=0;
			}
			else{
				o.stop=a[i].fx.width;
				sPL=a[i].fx.paddingLeft;
				sPR=a[i].fx.paddingRight;
				if(a[i].fx.width==wp.css.pInt(a[i],"width"))a[i].style.width=0; // if width is 100% we need to reset it to zero for starting the effect
			}

			//if(a[i].webplug!="menu")a[i].style.overflow="hidden";

			o.change=P[0];
			o.comp=P[0]
			wp(a[i]).effect(o);
			
			o.change=P[1];
			o.stop=sPL;
			wp(a[i]).effect(o);
			
			o.change=P[2];
			o.stop=sPR;
			wp(a[i]).effect(o);
		})
	},		
effectReset:function(){
	wp.each(this.v,function(a,i){
		if(a[i].fx){
			for(var x in a[i].fx){
				if(x.charAt(0)=="_"){
					
					a[i].style[x.substr(1)]=wp.px(a[i].fx[x])
				
				//alert(x.substr(1) + " - "  + a[i].fx[x])
				
				//alert(x.charAt(0)+" - " +x.substr(1)+" - " + a[i].fx[x])
			}
			}
			
			///wp.debug.objects(a[i].fx)
		}
	})
},
	drop:function(o)
	{
		var P=["height","padding-top","padding-bottom"];
		if(!o)o={};
		o.P=P
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		//if(!o.easing)o.easing="easeInCirc";
		if(!o.easing)o.easing=tempEff;
		
		//wp.get("andy").innerHTML=wp.get("andy").innerHTML+"<hr>"+wp.drop.caller
		
		//wp.debug.objects(this.v)
		
		
		wp.each(this.v,function(a,i){
			//wp.get("andy").innerHTML=wp.get("andy").innerHTML+"<hr>"+a[i]+" - "+o.action+" - "+a[i].innerHTML
			//if(o.action=="in" && wp.css.get(a[i],"display")=="none")a[i].style.display="block"; // if object is hidden need to show it (normally a hidden menu)
			if(!a[i].fx)a[i].fx={}
			if(!a[i].fx._height){

				a[i].fx.paddingTop=wp.css.pInt(a[i],P[1]);
				a[i].fx.paddingBottom=wp.css.pInt(a[i],P[2]);
				if(wp.css.get(a[i],P[0])=="auto"){
					a[i].style.height=wp.px(a[i].clientHeight-a[i].fx.paddingTop-a[i].fx.paddingBottom)
					a[i].aH=1
				}
				a[i].fx._height=wp.css.pInt(a[i],P[0])
				if(!a[i].fx._height)a[i].fx._height=80
			}
			var sPL,sPR;
			if(o.action=="out"){
				if(!o.stop)o.stop=0;
				sPL=0;
				sPR=0;
				
				if(wp.css.get(a[i],P[0])=="auto"){
					a[i].style.height=wp.px(a[i].fx._height)
					a[i].aH=1
				}
			}
			else{
				o.stop=a[i].fx._height;
				sPL=a[i].fx.paddingTop;
				sPR=a[i].fx.paddingBottom;
				if(a[i].fx._height)a[i].style.height=0;
				
			}

			if(a[i].webplug!="menu")a[i].style.overflow="hidden";

			o.comp='height'
			o.change='height';
			wp(a[i]).effect(o);
			
			o.change='padding-top';
			o.stop=sPL;
			wp(a[i]).effect(o);
			
			o.change='padding-bottom';
			o.stop=sPR;
			wp(a[i]).effect(o);
		})
	},
	/*
	grow:function(frames,fps,from,to)
	{
		var O,e;
		if(!frames)frames=tempFrames
		if(!fps)fps=tempFPS
		wp.each(this.v,function(a,i){
			
			var o={}
			o.frames=frames
			o.fps=fps
			o.from=from
			o.to=to
			o.easing='easeInCirc'
			o.change="height"
			o.action="out"
			o.comp='height'
							
			//wp(a[i]).effect(frames,fps,from,to,'fontSize','easeInCirc','fontSize')
			wp(a[i]).effect(o)
			
			//alert(a[i])
			
			
		})
		return this
	},
	*/
	


	fx:function(o)
	{
		var O,e;
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		if(!o.easing)o.easing=tempEff;
		wp.each(this.v,function(a,i){
			var E=a[i]
			wp.each(o.css.split(";"),function(a,i){
				
				var C=a[i].split(":")
				if(C[0]&&C[1]){
					o.stop=C[1];
					o.change=C[0];
				
				
					//alert(C[0] + " - " + C[1] + " - " + E)
					//alert(o.easing)
					wp(E).effect(o);
				}
			})
		})
		return this;
	},


	grow:function(o)
	{
		var O,e;
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		if(!o.easing)o.easing=tempEff;
		wp.each(this.v,function(a,i){
			if(o.fontSize){
				o.stop=o.fontSize;
				o.change="font-size";
				wp(a[i]).effect(o);
			}
		})
		return this;
	},
	animateStyle:function(o){

		var O,e;
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		if(!o.easing)o.easing=tempEff;
		wp.each(this.v,function(a,i){
			var obj=a[i];
			wp.each(o.style.split(";"),function(a,i){
				var p=a[i].split(":");
				if(p[0]){
					var aso=o
					
					
					
					
					aso.change=p[0]
					aso.comp=p[0]
					
					//alert(aso.oncomplete)
					
					
					aso.stop=parseInt(p[1])
					wp(obj).effect(aso);
				}
			})
		})
		return this;
		
	},
	barn:function()
	{
		return this
	},
	blinds:function()
	{
		return this
	},
	move:function(o)
	{
		var O,e;
		if(!o.frames)o.frames=tempFrames;
		if(!o.fps)o.fps=tempFPS;
		//if(!o.easing)o.easing="easeInQuad";
		if(!o.easing)o.easing=tempEff;
		wp.each(this.v,function(a,i){
			if(o.top){
				o.stop=o.top;
				o.change="top";
				wp(a[i]).effect(o);
			}
			
			if(o.left){
				o.stop=o.left;
				o.change="left";
				wp(a[i]).effect(o);
			}
			
		})
		return this;
	},
	bounce:function()
	{
		return this
	}









})









