/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: lite-menuapi.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Menu modification, manipulation and querying module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("string");

wp.extend({
	menuapi:{}
})

wp.menu.extend(
{
	
	getItem:function(o)
	{
		var menu=wp.get(o.menu);
		var U=menu.getElementsByTagName("LI")[0]
		if(wp.isNumeric(o.item))
		{
			for(var a=1;a<o.item;a++){
				U=wp.next(U);
			}
			return U
		}
		else
		{
			return wp.get(o.item)
		}
	},
	rebuildItem:function(o)
	{
		alert("rebuildItem")
	},	
	insertItem:function(o)
	{
		var menu=wp.get(o.menu);
		var item=wp.addNode(menu,"LI");
	showObjProps(menu)
		item.innerHTML=wp.menu.makeLink(o,menu.wpObject);
		//alert(item.innerHTML)
		wp.menu.initItemEvents(item,menu);
		return item;
	},
	removeItem:function(o){
		wp(wp.menu.getItem(o)).removeNNode();
	},
	editItemText:function(o){
		wp.each(wp.menu.getItem(o).childNodes[0].childNodes,function(a,i){
			if(o.text&&a[i].nodeType==3){
				a[i].nodeValue=o.text
				return;
			}
		})
		return
	},
	editItem:function(o){
		wp.menu.getItem(o).innerHTML=wp.menu.makeLink(o,wp.get(o.menu).wpObject)
	},
	createMenu:function(o){
		var menucontainer=wp.addNode(document.body,"DIV");
		var menu=wp.addNode(menucontainer,"UL");
		var item=wp.addNode(menu,"LI");
		menucontainer.className=o.classname+" WP-menu";
		menucontainer.id=o.menu;
		if(!o.theme)o.theme=wp.defaultTheme;
		o.wpObject=o;		
		item.innerHTML=wp.menu.makeLink(o,o);
		return menu;
	},
	insertMenu:function(o){
		var P=wp.seek(o.item);
		var menu=wp.addNode(P[0],"UL");
		menu.wpObject=P[0].parentNode.wpObject;
		var item=wp.addNode(menu,"LI");
		item.innerHTML=wp.menu.makeLink(o,menu.wpObject);
		wp.menu.makeSubImage(menu,wp.get(o.item).childNodes[0]);
		wp.menu.initMenuEvents(menu,item);
		return menu;
	},
	removeMenu:function(o){
		var menu=wp.get(o.menu);
		if(menu){
			wp.menu.removeSubImage(menu.parentNode)
			wp(menu).removeNNode()
		}
	},
	removeSubImage:function(v)
	{
		var I=wp.seek(".WP-menu-subimage",v)
		if(I[0]){
			wp(I[0]).removeNNode()
		}
	},
	last:function(o){
		
	}
})

