/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: mask.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Input Mask Module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("string,math,caret");

wp.extend(
	{		
		
		maskable:function(o){
			
			o=wp.bob(o)
			wp.each(this.v,function(a,i){
				var I=a[i];

				for(var C in o)I[C]=o[C] // Setup all the objects passible functions and properties
		
				wp.addEvent(I,'keyup',function(e){ 
					//if(o.max&&I.value>o.max)I.value=o.max
				}),
				wp.addEvent(I,'blur',function(e){
					if( (o.max||o.max==0)&&I.value>o.max)I.value=o.max
					if(o.min||o.min==0&&(I.value==""||I.value<o.min))I.value=o.min
				}),
				
				wp.addEvent(I,'keydown',function(e){ 
					this.K=e.which?e.which:e.keyCode;
				}),
				wp.addEvent(I,'keypress',function(e){ 
					var C=wp.chr(e.which?e.which:e.keyCode)
					var K=this.K
					var Text=I.value.toarray();
					var Mask=o.mask.toarray();
					var keybad=0;
					v=wp.getCaret(I).start
		
					switch(Mask[v]) {
						case '9':
							if(e.shiftKey||!wp.isNumber(C))keybad=1
							break;
						case '0':
							if(e.shiftKey||!wp.isNumeric(C))keybad=1
							break;
						case 'a':
							if(!wp.isAlpha(C))keybad=1
							break;
						case 'A':
							if(!keybad)
							{
								if(wp.isAlpha(C))
								{
									I.value=I.value.substr(0,v)+C.toUpperCase()+I.value.substr(v+1,I.value.length)
									wp.setCaret(I,v+1,v+1)
								}
							}
							keybad=1
							break;
						case 'l':
							if(!wp.isLetter(C))keybad=1
							break;
						case 'L':
							if(!keybad)
							{
								if(wp.isLetter(C))
								{	
									I.value=I.value.substr(0,v)+C.toUpperCase()+I.value.substr(v+1,I.value.length)
									wp.setCaret(I,v+1,v+1)
								}
							}
							keybad=1
							break;
						case 'H':
							if(!keybad)
							{
								if(wp.ishex(C))
								{	I.value=I.value.substr(0,v)+C.toUpperCase()+I.value.substr(v+1,I.value.length)
									wp.setCaret(I,v+1,v+1)
								}
							}
							keybad=1
							break;
						default:
							break;
					}
		
					if((K>32&&K<41)||K==8||K==9||K==46)
					{
						keybad=0
					}
					else
					{			
						if(Text.length+1>Mask.length){
							if(v<Mask.length&&keybad==0){
								I.value=I.value.substr(0,v)+C+I.value.substr(v+1,I.value.length)
								wp.setCaret(I,v+1,v+1)
							}
							keybad=1
						}
					}
					//alert(keybad)
					if(keybad){
						e.cancelEvent=true;
						wp.cancelEvent(e)
						if(I.oninvalid)I.oninvalid()
						return false
					}
					else{
						if(I.onvalid)I.onvalid()
					}
				});
			})
			
		},
		mask:{
			exec:function(v,o)
			{
				wp(v).maskable(o);
			},	
		},
		addMask:function(v,m)
		{
			var Text=v.toarray(),Mask=m.toarray(),a,ret="",A=0;
			for(a=0;a<Mask.length;a++)
			{
				var M=Mask[a]
				if(!Text[A])Text[A]="_"
				if(M=="0"||M=="9"||M=="a"||M=="A"||M=="l"||M=="L"||M=="H")
				{
					ret+=Text[A]
					A++
				}
				else
				{
					ret+=M
				}
			}
			//alert(ret)
			return ret
		},
		delMask:function(v,m)
		{
			var Text=v.toarray(),Mask=m.toarray(),a,ret="",A=0;
			for(a=0;a<Mask.length;a++)
			{
				var M=Mask[a]
				if(M=="0"||M=="9"||M=="a"||M=="A"||M=="l"||M=="L"||M=="H")
				{
					ret+=Text[a]
				}
				else
				{
					
				}				
			}
			//alert(ret)
			return ret
		}
	}
)


