/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: math.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs mathematical module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.extend(
{
	math:{}, // needed for 'wp.include' to know when this file has been loaded
	max:function()
	{
		var v,a,n;
		n=0;
		v=arguments;
		for(a=0;a<v.length;a++)if(!isNaN(v[a])&&v[a]>n)n=v[a];
		return n;
	},	
	min:function()
	{
		var v,a,n;
		v=arguments;
		for(a=0;a<v.length;a++){
			if(!n)n=v[a];
			if(!isNaN(v[a])&&v[a]<n&&v[a]>0)n=v[a];
		}
		return n;
	},
	getfraction:function(v)
	{
		v=v.toString().split(".");
		if(v[1])return parseFloat("."+v[1]);
		return 0;
	},
	hexdec:function(v)
	{
		return parseInt(v,16)
	},
	dechex:function(v)
	{
		return v.toString(16);
	},
	ishex:function(v)
	{
		v=v.replace(/^0{2,}/g,"")
		var a=this.hexdec(v)
		a=this.dechex(a)
		if(a.toUpperCase()==v.toUpperCase())return true; else return false;
	},
	ipInt:function(v)
	{
		var ip=v.split(".").reverse(),o=parseInt(ip[0]),a=3;
		for(;a>0;a--)o+=Math.pow(256,a)*ip[a];
		return o;
	},
	intIp:function(v)
	{
		var e=256,T=v/e,P=parseInt,A,B,C,D;
		D=e*(T-P(T));
		T=(P(T))/e;
		C=e*(T-P(T))+".";
		T=(P(T))/e;
		B=e*(T-P(T))+".";
		A=P(T)+".";
		return(A+B+C+D)
	},
	ipBin:function()
	{
		
	},
	decbin:function(v)
	{
		return parseInt(v).toString(2);
	},
	bindec:function(v)
	{
		return parseInt(v,2)
	},
	decoct:function(v)
	{
		return parseInt(v).toString(8);
	},
	octdec:function(v)
	{
		return parseInt(v,8)
	},	
	baseConvert:function(v,f,t)
	{
		return parseInt(v,f).toString(t);
	},
	percentageOf:function(p,v){   // (50,100)=50% ---- (400,800)=50% --- (25,100)
  		return (p/v)*100;
	},
	getPercentage:function(p,v){ // 50,100=50 --- 50,800=400
  		return (p/100)*v;
	},	
	isEven:function(v){
		return v%2==0
	},
	isOdd:function(v){
		return v%2==1
	},	
	hexrgb:function(v)
	{
		var r,g,b;
		v=v.replace(/\#/,'');
		r=parseInt(v.substring(0,2),16);
		g=parseInt(v.substring(2,4),16);
		b=parseInt(v.substring(4,6),16);
		if(!r)r=0;
		if(!g)g=0;
		if(!b)b=0;
		return {r:r,g:g,b:b}
	},
	rgbhex:function(r,g,b)
	{
		var r,g,b;
		r=Math.floor(r).toString(16);
		g=Math.floor(g).toString(16);
		b=Math.floor(b).toString(16);
		r=(r.length<2)?"0"+r:r;
		g=(g.length<2)?"0"+g:g;
		b=(b.length<2)?"0"+b:b;
		return (r+g+b);
	},
	randomColor:function()
	{
		return "#"+wp.rgbhex(wp.rand(0,255),wp.rand(0,255),wp.rand(0,255))
	},
	hlsrgb:function(h,l,s)
	{
		var i,r,g,b,T1,T2,T3,T4;
		if(s==0){
			r=g=b=Math.round(l/240*255);
		}else{
			h/=240;l/=240;s/=240;
			T2=(l<0.5)?l*(s+1):l+s-l*s;
			T1=l*2-T2;
			for(i=0;i<3;i++){
				switch(i){
					case 0:T3=h+1/3; break;
					case 1:T3=h; break;
					case 2:T3=h-1/3; break;
				}
				if(T3<0)T3++;
				else if(T3>1)T3--;
				if(T3*6<1)T4=T1+(T2-T1)*6*T3;
				else if(T3*2<1)T4=T2;
				else if(T3*3<2)T4=T1+(T2-T1)*((2/3)-T3)*6;
				else T4=T1;
				switch(i){
					case 0:r=Math.round(T4*255);break;
					case 1:g=Math.round(T4*255);break;
					case 2:b=Math.round(T4*255);break;
				}
			}
		}
		if(r>255)r=255
		if(g>255)g=255
		if(b>255)b=255
		if(r<0)r=0
		if(g<0)g=0
		if(b<0)b=0
		return {r:r,g:g,b:b};	
	},
	rgbhls:function(r,g,b)
	{
		var h,l,s,max=(Math.max(Math.max(r,g),b))/255,min=(Math.min(Math.min(r,g),b))/255,delta=max-min;
		l=(max+min)/2;
		s=(max==min)?0:((l<=0.5)?delta/l/2:delta/(2-l*2));
		if(r/255==max)h=(g-b)/delta/255;
		else if(g/255==max)h=2+(b-r)/delta/255;
		else if(b/255==max)h=4+(r-g)/delta/255;
		h*=40;
		if(h<0)h+=240;
		h=Math.round(h);
		if(r==b&&g==b&&r==g)h=160; // THIS NEEDS LOOKING AT
		return {h:((isNaN(h))?0:h),l:Math.round(l*240),s:Math.round(s*240)};	
	},
	roundNum:function(v,p)
	{
		return v.toFixed(p)
		
		//var b,c=1;
		//if(!p)return Math.round(v);
		//for(b=0;b<p;b++)c+="0";
		//c=parseInt(c);
		//return (Math.round(v*c))/c;
	},
	isInt:function(v)
	{
		return v%1?false:true;
	},	
	rand:function(a,b)
	{
		if(!b)b=0
		return Math.floor(Math.random()*(b-a+1)+a);
	},
	deg2Rad:function(v)
	{
		return(v*Math.PI)/180;
	},
	rad2Deg:function(v)
	{
		return(v*180)/Math.PI; //v is the angle
	},
	uniqid:function(a){
		var u=new Date().getTime().toString(),x=0,R,L=u.length;
		if(a)
			for(;x<a;x++){
				R=wp.rand(0,L);
				u=u.substr(0,R)+String.fromCharCode(wp.rand(65,70))+u.substr(R,L);
				L++
			}
		return u;
	}
})