/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: new-htmleditor.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs HTML editor application module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


/* include the required libraries here */
//wp.dependencies("string,html,tab,toolbar,window,contextmenu,menu,menuapi,ajax,location");
/*

stuff to tidy up:

FONT-FAMILY ;  // IE
FONT-FAMILY "  // IE
style=""       // Firefox


FONTS
Arial=arial
Arial Black=arial black
Book Antiqua=book antiqua
Comic Sans MS=comic sans ms
Courier New=courier new
Georgia=georgia
Helvetica=helvetica
Impact=impact
Symbol=symbol
Tahoma=tahoma
Terminal=terminal
Times New Roman=times new roman,times
Trebuchet MS=trebuchet ms
Verdana=verdana

*/

wp.dependencies("css,caret,window");

wp.extend(
{
	htmleditable:function(o)
	{
		o=wp.bob(o)
		wp.each(this.v,function(a,i){
			var I=a[i];

			var bMainMenu={
				orientation:"horizontal"
				,shadow:{style:"Test",mainMenu:false}
				,openEffect:function(e){
					wp(e).fade({action:"in"});
				}
				,closeEffect:function(e){
					wp(e).fade({action:"out"});
				}			
				,items: [
					{ text:"File", href:"#", submenu:{
						items: [
							{ text:"New",     href:"#", onclick:function(){wp.debug.objects(this)}, icon:"new.gif" },
							{ text:"Open",    href:"#", onclick:function(){wp.htmleditor.openDialog('open',I)}, icon:"open.gif" },
							{ text:"Close",   href:"#", icon:"transparent.gif"},
							{ text:"Save",    href:"#", icon:"save.gif" },
							{ text:"Save As", href:"#", icon:"transparent.gif" },
							{ text:"Exit",    href:"#", icon:"transparent.gif" }
							]
						}
					},
					{
						text:"Webplugs Objects",submenu:{
							items:new function(){
								return ""
							}
						}

					},
					{ text:"Edit", href:"#", submenu:{
						items: [
							{ text:"Sub Menu 1 Item1", href:"#" },
							{ text:"Sub Menu 1 Item2", href:"#", submenu: {
									items: [
										{ text:"Sub Menu 2 Item1", href:"#" },
										{ text:"Sub Menu 2 Item2", href:"#" },
										{ text:"Sub Menu 2 Item3", href:"#" }
									]
								} 
							},
							{ text:"Sub Menu 1 Item3", href:"#" }
							]
						}
					}
				]
			}

			var toolbarData={
				items: [
					{ icon:"new", overicon:"new_over", onclick:function(){wp.htmleditor.openDialog("new",I)} },
					{ icon:"open", overicon:"open_over", onclick:function(){wp.htmleditor.openDialog('open',I)} },
					{ icon:"save", overicon:"save_over", onclick:function(){wp.htmleditor.setProperty('save',I)} },
					{ icon:"table", overicon:"table_over", onclick:function(){wp.debug.objects(wp.childrenFromSelection(a.contentWindow))} },

					{ icon:"fontWeight", overicon:"fontWeight_over", onmouseup:function(){wp.htmleditor.setProperty(I,'font-weight','bold')} },
					
				]
			}

			

			var newWin=wp.window.create(
			{
				title:"Webplugs HTML Editor"
				,status:"Web HTML Editing Made Easy"
				,height:300
				,width:600
				,id:"__wpWebplugsHtmlEd"
				,menu:bMainMenu
				//,contentCSS:"padding:10px;border:3px solid green;font-size:20px;;"
				,toolbar:toolbarData
				,onload:function(e){
					wp(e).setAlignment("center;middle")
				}
				,onresize:function(e){
					//wp.webplugseditor.tidy(e)
				}
				,content:"Menus: "+wp.getPlugs("menu")+"<hr>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>"
				,theme:"Office2003"
			});
			
//			alert(I)
			
			
			wp.seek(".wpWinContent",wp.get("__wpWebplugsHtmlEd"))[0].contentEditable=true
			
		})
	},
	htmleditor:{
		exec:function(v,o)
		{
			wp(v).htmleditable(o);
		},
		setProperty:function(i,s,v,e){
			var AA=wp.getSelection(window)
			document.execCommand('bold', false, true);
			//return false
			//wp.cancelEvent(e)
			wp.debug.objects(AA)
			
			
		//AA.execCommand(s,v,null);
			
				//alert(i)
		}
	}
})