/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: resize.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs Object resizing module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("css,position");

wp.extend({		
	resizable:function(o){
		o=wp.bob(o)
		
		wp.each(this.v,function(a,i){
			var I=a[i];
			var T=this;
			if(wp.docState=="complete"){
				wp.resize.addHandle(I)
			}
			else{
				wp.onload(
					function(){
						wp.resize.addHandle(I)
					}
				)
			}
	
			I.resize=T;
			I.o=o;
			//alert(I.id)
			wp.addEvent(I,'mousemove',function(e){
				if(wp.resizing||!wp.rZ)return;
				if(wp.rsStop){
					wp.rsStop=0
					return
				}
				//if(I.id=="td2")alert(I.id)
				//wp.get("input1").value=I.id
				wp.resize.conf(I,e,I);
			})
		})
		//OLDshowObjProps(wp)
		return this
	},
	resize:{
		exec:function(v,o)
		{
			wp(v).resizable(o);
		},			
		conf:function(I,e,t)
		{
			e=e?e:event;
			var x,y,a=wp.rZ,d=wp.clientDims(),S=a.style,D=5,Corn=15;
			x=e.clientX+d.scrollLeft;
			y=e.clientY+d.scrollTop;
			wp.rsze=I;
			wp.rsStop=0;
			var rv=wp.getPosition(I);
			
			if((x-rv.left)>=I.offsetWidth-Corn&&(y-rv.top)>=I.offsetHeight-Corn){ // Corner
				S.marginLeft="-7px";
				S.width=Corn+"px";
				S.height=Corn+"px";
				S.top=(rv.top+I.offsetHeight-Corn)+"px";
				S.left=(rv.left+I.offsetWidth-Corn+7)+"px";
				S.cursor="se-resize";
				
				S.visibility="visible";
				wp.which="bottomRight";
				wp.rsStop=1
			}
			else{
				
				S.marginLeft=0;
				S.width=D+"px";
				S.height=D+"px";
				//alert(x + " - " + rv.left + " - " + I.offsetWidth + " - " + D )
				if((x-rv.left)>=I.offsetWidth-D){ // Right
					wp.rsStop=1
					S.visibility="visible";
					S.height=I.offsetHeight-10+"px";
					S.top=rv.top+"px";
					
					S.left=(rv.left+I.offsetWidth-D)+"px";
					S.cursor="e-resize";
					wp.get("__rsz").style.visibiliy="hidden";
					wp.which="right";
				}
				else if((y-rv.top)>=I.offsetHeight-D){ // Bottom
					wp.rsStop=1
					S.visibility="visible";
					S.width=I.offsetWidth-10+"px";
					S.top=(rv.top+I.offsetHeight-D)+"px";
					S.left=rv.left+"px";
					S.cursor="s-resize";
					
					wp.which="bottom";
				}
				else{
					if(wp.rZ && wp.rZ.style.visibility!="hidden"){
						wp.rZ.style.visibility="hidden";
						wp.rsStop=0
						//wp.rZ.style.left=0;
						//wp.rZ.style.top=0;
						//wp.rZ.style.width=0;
						//wp.rZ.style.height=0;
					}
					I.style.cursor="default";
				}
				
			}
		},
		addHandle:function(t)
		{
			if(!wp.get("__rsz")){
				var a,S;
				a=wp.addNode(document.body,"DIV");
				a.id="__rsz";
				a.onmouseout=wp.resize.mout;
				a.onmousedown=wp.resize.start;
				S=a.style;
				
				
				S.overflow="hidden";
				S.background="url("+wp.getPath()+"/themes/styles/resize/transparent.gif)";
				//S.background="yellow";
				S.position="absolute";
				S.zIndex=9999;
				wp.rZ=a;
			}
		},
		mout:function()
		{
			
			//wp.get("input1").value=""
			wp.rZ.style.visibility="hidden";
		},
		start:function(e)
		{
			var A,d=document;
			
			e=e?e:event;
			if(!wp.rsze)return
			wp.resizing=1;
			wp.rzX=e.clientX;
			wp.rzY=e.clientY;
			
			if(wp.rsze.o.bottom){
				A=wp.seek(wp.rsze.id+"."+wp.rsze.o.bottom)[0]
				//A.offTop=parseInt(wp.css.get(A,"padding-top"))+parseInt(wp.css.get(A,"padding-left"))
				//A.offLeft=parseInt(wp.css.get(A.parentNode,"padding-left"))+parseInt(wp.css.get(A.parentNode,"padding-right"))+1

//wp.debug.objects(wp.css.box(A))


//Need to calculate border and padding of containing objects
var B=wp.css.box(A)
BB=B[1]+B[3]+B[9]+B[11]
var B=wp.css.box(A.parentNode)
BB=BB+B[1]+B[3]+B[9]+B[11]




				A.offTop=0
				A.offLeft=BB
//alert(wp.css.get(A.parentNode,"padding-left"))
				
			}
			else{
				A=wp.seek(wp.rsze.id)[0]
				A.offTop=0
				A.offLeft=0
			}
			wp.rzO=A;
			wp.rzH=A.offsetHeight;
			wp.rzW=A.offsetWidth;
			wp.tofront(wp.rsze)
			wp.addEvent(d,"mousemove",wp.resize.drag)
			wp.addEvent(d,"mouseup",wp.resize.end)
			return false;
			
		},
		drag:function(e)
		{
			var x,y,W=wp.which,O,STOP,percent		
			e=e?e:event;
			x=e.clientX;
			y=e.clientY;
	//		clearTimeout(wp.rsze.T)
	//		wp.rsze.T=setTimeout(function(){
				STOP=0;
				if(!wp.rsze)return;
				O=wp.rsze.o
				if(wp.rzO&&W=="bottom"||W=="bottomRight"){
					var bot=wp.rzH+(y-wp.rzY)-wp.rzO.offTop;
					if(bot>O.maxHeight)bot=O.maxHeight;
					if(bot<O.minHeight)bot=O.minHeight;
					if(O.keepaspect){
						percent=((y-wp.rzY)/wp.rzH);
						var rght=wp.rzW+(wp.rzW)*(percent)+wp.rzO.offLeft;
						if(rght>O.maxWidth)rght=O.maxWidth;
						if(rght<O.minWidth)rght=O.minWidth;
						if(rght>0)if(wp.rsze)wp.rsze.style.width=rght+"px";
						STOP=1;
					}

					
					//bot=bot-(wp.rzO.offsetHeight-parseInt(wp.css.get(wp.rzO,"height")))
					///alert()
//					alert(wp.rzO.offsetHeight)


var B=wp.css.box(wp.rzO)
var BB=B[0]+B[2]+B[8]+B[10]
bot=bot-BB


//wp.debug.objects(wp.css.box(wp.rzO))


//document.title =  BB
					
					
					if(bot>0)wp.rzO.style.height=bot+"px";
				}	
				if(!STOP&&(W=="right"||W=="bottomRight")){
					var rght=wp.rzW+(x-wp.rzX)+wp.rzO.offLeft;
					if(rght>O.maxWidth)rght=O.maxWidth;
					if(rght<O.minWidth)rght=O.minWidth;
					if(O.keepaspect){
						percent=((x-wp.rzX)/wp.rzW);
						var bot=wp.rzH+(wp.rzH)*(percent)-wp.rzO.offTop;
						if(bot>O.maxHeight)bot=O.maxHeight;
						if(bot<O.minHeight)bot=O.minHeight;
						if(bot>0)wp.rzO.style.height=bot+"px";
					}
					
					if(wp.msie<7&&rght%2==0)rght++ //fixes a bug in IE6 setting width wrong

					//rght=rght-(wp.rzO.offsetWidth-parseInt(wp.css.get(wp.rzO,"width")))

var B=wp.css.box(wp.rzO)
var BB=B[1]+B[3]+B[9]+B[11]
rght=rght-BB



					
					if(rght>0)if(wp.rsze)wp.rsze.style.width=rght+"px";
				}
				if(O.onresize)O.onresize.call(this,wp.rsze);
				if(STOP)return;
	//		},1)
	//		return false;
	
			wp.cancelEvent(e)
			return false;
		},
		end:function(e)
		{
			var d=document;
			wp.removeEvent(d,"mousemove",wp.resize.drag);
			wp.removeEvent(d,"mouseup",wp.resize.end);
			wp.rsze=null;
			wp.resizing=0;
		}		
	}
})	
