/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: scrollbar.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Custom scrollbars
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("dragdrop,math,css");

wp.extend({
	scrollable:function(o)
	{
		//alert(wp.msie))
		if(wp.msie<8)return this
		o=wp.bob(o);
		wp.each(this.v,function(a,i){
			var I=a[i],S;
			if(I.webplug=="scrollbar")return;
			wp.css.add(o,"scrollbar");
			if(!o.theme)o.theme=wp.getTheme(I)
			if(!o.theme)o.theme="Venom";
			
			S=wp.wrapNode(I,"div",true);
			S.sb={}
			wp(S).addCSSName("wp"+o.theme+"SB")
			wp(I).addCSSName("sbC")
			S.webplug="scrollbar"
			wp.scrollbar.reset(S);

			if(o.oncomplete)o.oncomplete(I)
		})
		return this
	},	
	scrollbar:{
		exec:function(v,o)
		{
			wp(v).scrollable(o);
		},
		reset:function(I){
			var container=I.childNodes[0],bi,pc,LH=16,D=LH
			clearTimeout(I.sb.LDD);
			
			if(!I.sb.done){
				bi=wp.css.get(container,"overflow");
				if(bi=="visible"){
					if(!I.sb.ldd)I.sb.ldd=10;
					I.sb.ldd++;
					if(I.sb.ldd<99)I.sb.LDD=setTimeout(function(){wp.scrollbar.reset(I)},I.sb.ldd);
					return;
				}
				I.sb.done=1
			}
			
			if(I.offsetWidth!=I.oldW||I.offsetHeight!=I.oldH||I.innerHTML!=I.oldC||container.scrollTop!=I.oldS)
			{
				//document.title=Date()
				var W=wp.css.get(I,"width"),H=wp.css.get(I,"height"),B=wp.css.box(I),vsb,hsb
				
				if(container.scrollHeight>container.offsetHeight){
					if(!I.sb.V){
						vsb=wp.addNode(I,"div",0,{className:"vSB"})
							I.sb.top=wp.addNode(vsb,"div",0,{className:"sbTop"})
							I.sb.vh=wp.addNode(vsb,"div",0,{className:"vHandle"})
								wp.addNode(I.sb.vh,"div",0,{className:"hTop"})
								I.vhM=wp.addNode(I.sb.vh,"div",0,{className:"hMiddle"})
									wp.addNode(I.vhM,"div",0,{className:"handle"})
								wp.addNode(I.sb.vh,"div",0,{className:"hBottom"})
							I.sb.bot=wp.addNode(vsb,"div",0,{className:"sbBottom"})
							
						I.sb.V=vsb
						wp(I.sb.vh).dragable({
							binding:wp(I.sb.vh).object.parentNode
							,bindOffsetX:-I.sb.bot.offsetHeight
							,ondrag:function(T){
								T.o.min=I.sb.top.offsetHeight
								wp.scrollbar.vertMove(T);
							}	
						})
						wp.addEvent(vsb,"mousedown",function(e){
							var E=wp.getE(e),V=null
							if(E.className=="sbTop")V=-D;
							if(E.className=="sbBottom")V=D;
							if(E.className=="vSB"){
								var mp=wp.getObjMouseCoords(e)
								var bD=vsb.offsetHeight-LH
								if(I.sb.H)bD-=I.sb.H.offsetHeight
								if(mp.y<I.sb.vh.offsetTop)V=-bD; else V=bD;
							}
							I.sbt=250
							wp.scrollbar.vertAction(I.sb.vh,V)
						})
						wp.addEvent(vsb,"mouseup",function(e){
							clearTimeout(I.ss)
						})
						wp.addEvent(vsb,"mouseout",function(e){
							clearTimeout(I.ss)
						})						
						wp.addEvent(I,"mousewheel",function(e){
							wp.scrollbar.mouseWheel(e.wheelDelta,vsb,LH,I);
							wp.cancelEvent(e);
						})
						wp.addEvent(I,"DOMMouseScroll",function(e){
							wp.scrollbar.mouseWheel(-e.detail,vsb,LH,I);
							wp.cancelEvent(e);
						})
						wp.addEvent(I,"selectstart",function(e){
							wp.cancelEvent(e)
						})

						
						I.style.paddingRight=wp.px(B[1]+I.sb.top.offsetWidth)
						if(W!="auto")I.style.width=wp.px(parseInt(W)-I.sb.top.offsetWidth)
					}
					pc=wp.percentageOf((container.scrollHeight-container.offsetHeight),container.scrollHeight);
					I.sb.vh.childNodes[1].style.height=wp.getPercentage(100-pc,(I.sb.V.offsetHeight-I.sb.top.offsetHeight-I.sb.bot.offsetHeight-20))+"px";
				}else{
					if(I.sb.V){
						I.style.paddingRight=wp.px(B[1]-I.sb.top.offsetWidth)
						if(W!="auto")I.style.width=wp.px(parseInt(W)+I.sb.top.offsetWidth)
						wp.removeNode(I.sb.V)
						I.sb.V=null
					}				
				}
	
				if(container.scrollWidth>container.offsetWidth){
					if(!I.sb.H){
						hsb=wp.addNode(I,"div",0,{className:"hSB"})
							I.sb.left=wp.addNode(hsb,"div",0,{className:"sbLeft"})
							I.sb.hh=wp.addNode(hsb,"div",0,{className:"hHandle"})
								wp.addNode(I.sb.hh,"div",0,{className:"hLeft"})
								I.hhC=wp.addNode(I.sb.hh,"div",0,{className:"hCenter"})
									wp.addNode(I.hhC,"div",0,{className:"handle"})
								wp.addNode(I.sb.hh,"div",0,{className:"hRight"})
							I.sb.right=wp.addNode(hsb,"div",0,{className:"sbRight"})
							
						I.sb.H=hsb
						wp(I.sb.hh).dragable({
							binding:wp(I.sb.hh).object.parentNode
							,bindOffsetY:-I.sb.right.offsetWidth
							,ondrag:function(T){
								T.o.min=I.sb.left.offsetWidth
								wp.scrollbar.horizMove(T);
							}	
						})
						wp.addEvent(hsb,"mousedown",function(e){
							var E=wp.getE(e),V=null
							if(E.className=="sbLeft")V=-D;
							if(E.className=="sbRight")V=D;
							if(E.className=="hSB"){
								var mp=wp.getObjMouseCoords(e)
								var bD=hsb.offsetWidth-LH
								if(I.sb.V)bD-=I.sb.V.offsetWidth
								if(mp.x<I.sb.hh.offsetLeft)V=-bD; else V=bD;
							}
							I.sbt=250
							wp.scrollbar.horizAction(I.sb.hh,V)
						})
						wp.addEvent(hsb,"mouseup",function(e){
							clearTimeout(I.ss)
						})
						wp.addEvent(hsb,"mouseout",function(e){
							clearTimeout(I.ss)
						})						
						I.style.paddingBottom=wp.px(B[2]+I.sb.left.offsetHeight)
						if(H!="auto")I.style.height=wp.px(parseInt(H)-I.sb.left.offsetHeight)
					}
					pc=wp.percentageOf((container.scrollWidth-container.offsetWidth),container.scrollWidth);
					I.sb.hh.childNodes[1].style.width=wp.getPercentage(100-pc,(I.sb.H.offsetWidth-I.sb.left.offsetWidth-I.sb.left.offsetWidth-20))+"px";
				}
				else{
					if(I.sb.H){
						I.style.paddingBottom="10px"
						if(H!="auto")I.style.height=wp.px(parseInt(H)+I.sb.left.offsetHeight)
						wp.removeNode(I.sb.H)
						I.sb.H=null
					}				
				}
	
				if(I.sb.V){
					if(I.sb.H){
						I.sb.right.style.right="14px"
						I.sb.H.childNodes[1].o.bindOffsetY=-(I.sb.right.offsetWidth+I.sb.right.offsetHeight)
					}else{
						I.sb.bot.style.bottom=0;
						I.sb.V.childNodes[1].o.bindOffsetX=-(I.sb.bot.offsetHeight)
					}
					wp.scrollbar.vertMove(I.sb.vh,0);
				}
				if(I.sb.H){
					if(I.sb.V){
						I.sb.bot.style.bottom="14px"
						I.sb.V.childNodes[1].o.bindOffsetX=-(I.sb.bot.offsetHeight+I.sb.bot.offsetWidth)
					}
					else{
						I.sb.right.style.right=0;
						I.sb.H.childNodes[1].o.bindOffsetY=-(I.sb.right.offsetWidth)
					}
					wp.scrollbar.horizMove(I.sb.hh,0);
				}
			}
			I.oldW=I.offsetWidth
			I.oldH=I.offsetHeight
			I.oldC=I.innerHTML
			I.oldS=container.scrollTop
			I.sbC=container
			clearTimeout(I.sb.to)
			I.sb.to=setTimeout(function(){wp.scrollbar.reset(I)},1);
		},
		vertMove:function(T,m){
			var I=wp.parentPlug(T,"scrollbar")
			if(!I||!I.sb.V)return
			T=I.sb.V.childNodes[1]
			var container=I.childNodes[0]
				,gap=I.sb.bot.offsetTop-I.sb.top.offsetHeight-T.offsetHeight
				,px=(container.scrollHeight-container.offsetHeight)/gap
				,mt=px*(T.offsetTop-I.sb.top.offsetHeight)
			if(m===undefined){
				container.scrollTop=mt;
			}
			else{container.scrollTop=container.scrollTop+m;
				T.style.top=wp.px(Math.ceil((container.scrollTop/px)+16))
			}
		},
		vertAction:function(vh,V){
			wp.scrollbar.vertMove(vh,V);
			var I=wp.parentPlug(vh,"scrollbar")
			if(!I)return
			I.ss=setTimeout(function(){
				wp.scrollbar.vertAction(vh,V);
			},I.sbt)
			I.sbt=30
		},
		horizMove:function(T,m){
			var I=wp.parentPlug(T,"scrollbar")
			if(!I||!I.sb.H)return
			T=I.sb.H.childNodes[1]
			var container=I.childNodes[0]
				,gap=I.sb.right.offsetLeft-I.sb.left.offsetWidth-T.offsetWidth
				,px=(container.scrollWidth-container.offsetWidth)/gap
				,mt=px*(T.offsetLeft-I.sb.left.offsetWidth)
			if(m===undefined){
				container.scrollLeft=mt;
			}
			else{
				container.scrollLeft=container.scrollLeft+m;
				T.style.left=wp.px(Math.ceil((container.scrollLeft/px)+16))
			}
		},
		horizAction:function(hh,V){
			wp.scrollbar.horizMove(hh,V);
			var I=wp.parentPlug(hh,"scrollbar")
			if(!I)return
			I.ss=setTimeout(function(){
				wp.scrollbar.horizAction(hh,V);
			},I.sbt)
			I.sbt=30
		},
		mouseWheel:function(d,sb,LH,I){
			var V=I.sb.V.offsetHeight-(LH*2)
			if(I.sb.H)V-=I.sb.H.offsetHeight
			if(d>0)wp.scrollbar.vertMove(sb,-V); else wp.scrollbar.vertMove(sb,V)
		}
	}
	}
)



