/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: string.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs String manipulation module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.extend(
{
	string:{},
	wordwrap:function(c,w)
	{
		// same as PHP wordwrap function
		//return String.fromCharCode(c)
	},
	chr:function(c)
	{
		return String.fromCharCode(c)
	},
	ord:function(c)
	{
		return c.charCodeAt(0);
	},
	ucfirst:function(v)
	{
		var f=v.charAt(0);
		f=f.toUpperCase();
		return f+v.substring(1);
	},
	ucwords:function(v)
	{
		var x,a,Q;
		x=v.split(" ");
		Q="";
		for(a=0;a<x.length;a++)Q+=wp.ucfirst(x[a])+" "
		return wp.trim(Q);
	},
	wordCount:function(v)
	{
		return v.replace(/ {2,}/g," ").split(" ").length;
	},	
	charCount:function(v)
	{
		return v.replace(/ {2,}/g,"").length;
	},
	
	htmlEncode:function(v)
	{

		
		return v.replace(/&/g,"&amp;").replace(/ /g,"&nbsp;").replace(/</g,"&lt;").replace(/>/g,"&gt;"); // need to change this function



var entity_table = {
38:"amp",
60:"lt",
62:"gt",
160:"nbsp",
161:"iexcl",
162:"cent",
163:"pound",
164:"curren",
165:"yen",
166:"brvbar",
167:"sect",
168:"uml",
169:"copy",
170:"ordf",
171:"laquo",
172:"not",
173:"shy",
174:"reg",
175:"macr",
176:"deg",
177:"plusmn",
178:"sup2",
179:"sup3",
180:"acute",
181:"micro",
182:"para",
183:"middot",
184:"cedil",
185:"sup1",
186:"ordm",
187:"raquo",
188:"frac14",
189:"frac12",
190:"frac34",
191:"iquest",
192:"Agrave",
193:"Aacute",
194:"Acirc",
195:"Atilde",
196:"Auml",
197:"Aring",
198:"AElig",
199:"Ccedil",
200:"Egrave",
201:"Eacute",
202:"Ecirc",
203:"Euml",
204:"Igrave",
205:"Iacute",
206:"Icirc",
207:"Iuml",
208:"ETH",
209:"Ntilde",
210:"Ograve",
211:"Oacute",
212:"Ocirc",
213:"Otilde",
214:"Ouml",
215:"times",
216:"Oslash",
217:"Ugrave",
218:"Uacute",
219:"Ucirc",
220:"Uuml",
221:"Yacute",
222:"THORN",
223:"szlig",
224:"agrave",
225:"aacute",
226:"acirc",
227:"atilde",
228:"auml",
229:"aring",
230:"aelig",
231:"ccedil",
232:"egrave",
233:"eacute",
234:"ecirc",
235:"euml",
236:"igrave",
237:"iacute",
238:"icirc",
239:"iuml",
240:"eth",
241:"ntilde",
242:"ograve",
243:"oacute",
244:"ocirc",
245:"otilde",
246:"ouml",
247:"divide",
248:"oslash",
249:"ugrave",
250:"uacute",
251:"ucirc",
252:"uuml",
253:"yacute",
254:"thorn",
255:"yuml",
264:"#264",
265:"#265",
338:"OElig",
339:"oelig",
352:"Scaron",
353:"scaron",
372:"#372",
373:"#373",
374:"#374",
375:"#375",
376:"Yuml",
402:"fnof",
710:"circ",
732:"tilde",
913:"Alpha",
914:"Beta",
915:"Gamma",
916:"Delta",
917:"Epsilon",
918:"Zeta",
919:"Eta",
920:"Theta",
921:"Iota",
922:"Kappa",
923:"Lambda",
924:"Mu",
925:"Nu",
926:"Xi",
927:"Omicron",
928:"Pi",
929:"Rho",
931:"Sigma",
932:"Tau",
933:"Upsilon",
934:"Phi",
935:"Chi",
936:"Psi",
937:"Omega",
945:"alpha",
946:"beta",
947:"gamma",
948:"delta",
949:"epsilon",
950:"zeta",
951:"eta",
952:"theta",
953:"iota",
954:"kappa",
955:"lambda",
956:"mu",
957:"nu",
958:"xi",
959:"omicron",
960:"pi",
961:"rho",
962:"sigmaf",
963:"sigma",
964:"tau",
965:"upsilon",
966:"phi",
967:"chi",
968:"psi",
969:"omega",
977:"thetasym",
978:"upsih",
982:"piv",
8194:"ensp",
8195:"emsp",
8201:"thinsp",
8204:"zwnj",
8205:"zwj",
8206:"lrm",
8207:"rlm",
8211:"ndash",
8212:"mdash",
8216:"lsquo",
8217:"rsquo",
8218:"sbquo",
8220:"ldquo",
8221:"rdquo",
8222:"bdquo",
8224:"dagger",
8225:"Dagger",
8226:"bull",
8230:"hellip",
8240:"permil",
8242:"prime",
8243:"Prime",
8249:"lsaquo",
8250:"rsaquo",
8254:"oline",
8260:"frasl",
8364:"euro",
8472:"weierp",
8465:"image",
8476:"real",
8482:"trade",
8501:"alefsym",
8592:"larr",
8593:"uarr",
8594:"rarr",
8595:"darr",
8596:"harr",
8629:"crarr",
8656:"lArr",
8657:"uArr",
8658:"rArr",
8659:"dArr",
8660:"hArr",
8704:"forall",
8706:"part",
8707:"exist",
8709:"empty",
8711:"nabla",
8712:"isin",
8713:"notin",
8715:"ni",
8719:"prod",
8721:"sum",
8722:"minus",
8727:"lowast",
8729:"#8729",
8730:"radic",
8733:"prop",
8734:"infin",
8736:"ang",
8743:"and",
8744:"or",
8745:"cap",
8746:"cup",
8747:"int",
8756:"there4",
8764:"sim",
8773:"cong",
8776:"asymp",
8800:"ne",
8801:"equiv",
8804:"le",
8805:"ge",
8834:"sub",
8835:"sup",
8836:"nsub",
8838:"sube",
8839:"supe",
8853:"oplus",
8855:"otimes",
8869:"perp",
8901:"sdot",
8968:"lceil",
8969:"rceil",
8970:"lfloor",
8971:"rfloor",
9001:"lang",
9002:"rang",
9642:"#9642",
9643:"#9643",
9674:"loz",
9702:"#9702",
9824:"spades",
9827:"clubs",
9829:"hearts",
9830:"diams;"
}



		//var arr1 = new Array('&nbsp;','&iexcl;','&cent;','&pound;','&curren;','&yen;','&brvbar;','&sect;','&uml;','&copy;','&ordf;','&laquo;','&not;','&shy;','&reg;','&macr;','&deg;','&plusmn;','&sup2;','&sup3;','&acute;','&micro;','&para;','&middot;','&cedil;','&sup1;','&ordm;','&raquo;','&frac14;','&frac12;','&frac34;','&iquest;','&agrave;','&aacute;','&acirc;','&atilde;','&Auml;','&aring;','&aelig;','&ccedil;','&egrave;','&eacute;','&ecirc;','&euml;','&igrave;','&iacute;','&icirc;','&iuml;','&eth;','&ntilde;','&ograve;','&oacute;','&ocirc;','&otilde;','&Ouml;','&times;','&oslash;','&ugrave;','&uacute;','&ucirc;','&Uuml;','&yacute;','&thorn;','&szlig;','&agrave;','&aacute;','&acirc;','&atilde;','&auml;','&aring;','&aelig;','&ccedil;','&egrave;','&eacute;','&ecirc;','&euml;','&igrave;','&iacute;','&icirc;','&iuml;','&eth;','&ntilde;','&ograve;','&oacute;','&ocirc;','&otilde;','&ouml;','&divide;','&Oslash;','&ugrave;','&uacute;','&ucirc;','&uuml;','&yacute;','&thorn;','&yuml;','&quot;','&amp;','&lt;','&gt;','&oelig;','&oelig;','&scaron;','&scaron;','&yuml;','&circ;','&tilde;','&ensp;','&emsp;','&thinsp;','&zwnj;','&zwj;','&lrm;','&rlm;','&ndash;','&mdash;','&lsquo;','&rsquo;','&sbquo;','&ldquo;','&rdquo;','&bdquo;','&dagger;','&dagger;','&permil;','&lsaquo;','&rsaquo;','&euro;','&fnof;','&alpha;','&beta;','&gamma;','&delta;','&epsilon;','&zeta;','&eta;','&theta;','&iota;','&kappa;','&lambda;','&mu;','&nu;','&xi;','&omicron;','&pi;','&rho;','&sigma;','&tau;','&upsilon;','&phi;','&chi;','&psi;','&omega;','&alpha;','&beta;','&gamma;','&delta;','&epsilon;','&zeta;','&eta;','&theta;','&iota;','&kappa;','&lambda;','&mu;','&nu;','&xi;','&omicron;','&pi;','&rho;','&sigmaf;','&sigma;','&tau;','&upsilon;','&phi;','&chi;','&psi;','&omega;','&thetasym;','&upsih;','&piv;','&bull;','&hellip;','&prime;','&prime;','&oline;','&frasl;','&weierp;','&image;','&real;','&trade;','&alefsym;','&larr;','&uarr;','&rarr;','&darr;','&harr;','&crarr;','&larr;','&uarr;','&rarr;','&darr;','&harr;','&forall;','&part;','&exist;','&empty;','&nabla;','&isin;','&notin;','&ni;','&prod;','&sum;','&minus;','&lowast;','&radic;','&prop;','&infin;','&ang;','&and;','&or;','&cap;','&cup;','&int;','&there4;','&sim;','&cong;','&asymp;','&ne;','&equiv;','&le;','&ge;','&sub;','&sup;','&nsub;','&sube;','&supe;','&oplus;','&otimes;','&perp;','&sdot;','&lceil;','&rceil;','&lfloor;','&rfloor;','&lang;','&rang;','&loz;','&spades;','&clubs;','&hearts;','&diams;');
		//var arr2 = new Array('&#160;','&#161;','&#162;','&#163;','&#164;','&#165;','&#166;','&#167;','&#168;','&#169;','&#170;','&#171;','&#172;','&#173;','&#174;','&#175;','&#176;','&#177;','&#178;','&#179;','&#180;','&#181;','&#182;','&#183;','&#184;','&#185;','&#186;','&#187;','&#188;','&#189;','&#190;','&#191;','&#192;','&#193;','&#194;','&#195;','&#196;','&#197;','&#198;','&#199;','&#200;','&#201;','&#202;','&#203;','&#204;','&#205;','&#206;','&#207;','&#208;','&#209;','&#210;','&#211;','&#212;','&#213;','&#214;','&#215;','&#216;','&#217;','&#218;','&#219;','&#220;','&#221;','&#222;','&#223;','&#224;','&#225;','&#226;','&#227;','&#228;','&#229;','&#230;','&#231;','&#232;','&#233;','&#234;','&#235;','&#236;','&#237;','&#238;','&#239;','&#240;','&#241;','&#242;','&#243;','&#244;','&#245;','&#246;','&#247;','&#248;','&#249;','&#250;','&#251;','&#252;','&#253;','&#254;','&#255;','&#34;','&#38;','&#60;','&#62;','&#338;','&#339;','&#352;','&#353;','&#376;','&#710;','&#732;','&#8194;','&#8195;','&#8201;','&#8204;','&#8205;','&#8206;','&#8207;','&#8211;','&#8212;','&#8216;','&#8217;','&#8218;','&#8220;','&#8221;','&#8222;','&#8224;','&#8225;','&#8240;','&#8249;','&#8250;','&#8364;','&#402;','&#913;','&#914;','&#915;','&#916;','&#917;','&#918;','&#919;','&#920;','&#921;','&#922;','&#923;','&#924;','&#925;','&#926;','&#927;','&#928;','&#929;','&#931;','&#932;','&#933;','&#934;','&#935;','&#936;','&#937;','&#945;','&#946;','&#947;','&#948;','&#949;','&#950;','&#951;','&#952;','&#953;','&#954;','&#955;','&#956;','&#957;','&#958;','&#959;','&#960;','&#961;','&#962;','&#963;','&#964;','&#965;','&#966;','&#967;','&#968;','&#969;','&#977;','&#978;','&#982;','&#8226;','&#8230;','&#8242;','&#8243;','&#8254;','&#8260;','&#8472;','&#8465;','&#8476;','&#8482;','&#8501;','&#8592;','&#8593;','&#8594;','&#8595;','&#8596;','&#8629;','&#8656;','&#8657;','&#8658;','&#8659;','&#8660;','&#8704;','&#8706;','&#8707;','&#8709;','&#8711;','&#8712;','&#8713;','&#8715;','&#8719;','&#8721;','&#8722;','&#8727;','&#8730;','&#8733;','&#8734;','&#8736;','&#8743;','&#8744;','&#8745;','&#8746;','&#8747;','&#8756;','&#8764;','&#8773;','&#8776;','&#8800;','&#8801;','&#8804;','&#8805;','&#8834;','&#8835;','&#8836;','&#8838;','&#8839;','&#8853;','&#8855;','&#8869;','&#8901;','&#8968;','&#8969;','&#8970;','&#8971;','&#9001;','&#9002;','&#9674;','&#9824;','&#9827;','&#9829;','&#9830;');

		
	},
	htmlUnencode:function(v)
	{
		return v.replace(/&amp;/g,"&").replace(/&nbsp;/g," ").replace(/&lt;/g,"<").replace(/&gt;/g,">"); // need to change this function
	},
	stripTags:function(v) {
		return v.replace(/<\/?[^>]+>/gi, '');
	},
	isPunctuation:function(v){
	},
	_LSn:function(v,t){
		var V=v+"",x,C;
		V=V.toarray()
		if(!v)return false
		for(x=0;x<V.length;x++){
			C=wp.ord(V[x]);
			if(t==1&&(C<65||C>90))return false;
			if(t==2&&(C<97||C>122))return false;
			if(t==3&&(C<97||C>122)&&(C<65||C>90))return false;
			if(t==4&&(C<40||C>57))return false;
			if(t==5&&(C<48||C>57))return false;
		}
		return true;
	},
	isUpper:function(v){
		return wp._LSn(v,1);
	},
	isLower:function(v){
		return wp._LSn(v,2);
	},
	isLetter:function(v){
		return wp._LSn(v,3);
	},
	isNumeric:function(v){
		return wp._LSn(v,4);
	},	
	isNumber:function(v){
		return wp._LSn(v,5);
	},	
	isAlpha:function(v){
		return (wp.isNumber(v)||wp.isLetter(v))?true:false;
	},
	isFloat:function(v){
		return (wp.isNumeric(v)&&v%1)?true:false;
	
	},
	isEmail:function()
	{
	},
	parseStyle:function(v,s)
	{
		var x,p=s.split(";"),pos,P,V;
		for(x=0;x<p.length;x++){
			A=p[x].split(":");
			P=A[0];
			V=A[1];
			if(V)eval("v.style."+wp.camelCase(P)+"='"+V+"'");
		}
	},
	
	strPad:function(S,L,R,T){ //S:string, L:Length, R:replacement, T:type (l for left, r for right, b for both)
		if(!T)T="r";
		for(var a=0;a<L;a++){
			//document.title=S+ " - " + S.toString().length + " - "  + L + " - "+  (S.length>=L)
			if(S.toString().length>=L)return S;
			if(T=="r"||T=="b")S+=R;
			if(T=="l"||T=="b")S=R+S;
		}
		return S;	
	},
	replace:function(n,r,h,p)
	{
		return h.replace(new RegExp(n,p),r);
	},
	str_replace:function(n,r,h) // needle,replacement,haystack
	{
		return this.replace(n,r,h,"g");
	},
	strrev:function(s){
		var N="",x
		for(x=s.length-1;x>=0;x--)N+=s[x]
		return N;
	},
	stri_replace:function(n,r,h)// needle,replacement,haystack
	{
		return this.replace(n,r,h,"gi");
	},
	ltrim:function(v)
	{
		return v.replace(/^\s+/g,"")
	},
	rtrim:function(v)
	{
		return v.replace(/\s+$/g,"")
	},
	trim:function(v)
	{
		return this.ltrim(this.rtrim(v))
	},
	lastChr:function(s)
	{
		return s.substr(s.length-1)
	},
	replaceInQuotes:function(n,r,h){
		var a=h.split(""),q,dq,ar=[],x;
		for(x=0;x<a.length;x++){
			if(a[x]=="\""&&!q)if(dq)dq=0; else dq=1;
			if(a[x]=="'"&&!dq)if(q)q=0; else q=1;
			if((dq||q)&&a[x]==n)ar.push(x)
		}
		for(x=0;x<ar.length;x++){
			h=h.substring(0,ar[x])+wp.chr(8)+h.substring(ar[x]+1,h.length)
		}
		h=wp.str_replace(wp.chr(8),r,h)
		return h
	},
	replaceBetween:function(n,r,h,b1,b2){
		var B1=new RegExp(b1,"gi"),B2=new RegExp(b2,"gi"),H,H2,x;
		if(wp.msie)h=" "+h // IE has a bug where it will not process regular expression correctly unless there is something preceeding the match
		H=h.split(B1)
		h=H[0]
		for(x=1;x<H.length;x++){
			H2=H[x].split(B2)
			H2[0]=H2[0].replace(new RegExp(n,"g"),r)
			h=h+b1+H2[0]+b2+H2[1]
		}
		return h;
	},
	numberFormat:function(n,d,p,t){
		var x,c=0,N="";
		if(!d)d=0;
		if(!t)t=",";
		if(!p)p=".";
		n=parseFloat(n).toFixed(d).toString().split(".");
		for(x=n[0].length-1;x>=0;x--){
			//alert(n[0] + " - "+  x + " - "+  n[0][x]) 
			if(c==3){
				c=0;
				N+=t;
			}
			
			N+=n[0][x];
			c++;
		}
		N=wp.strrev(N);
		if(n[1])N+=p+n[1];
		return N;
		
	},
	seconds2Time:function(s){
		var h,dM,m,dS,S,i;
		S=Math.floor(s)
		h=Math.floor(S/3600);
		dM=S%3600;
		m=wp.strPad(Math.floor(dM/60),2,"0","l");
    	dS=dM%60;
    	S=wp.strPad(Math.ceil(dS),2,"0","l");
    	i=Math.floor((s%1)*1000)
	    return{"h":h,"m":m,"s":S,"i":i};
   }
})