/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: ticker.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: Milonic Shared Source License
	    Details: News Ticker
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("effect,css,string");
wp.extend(
	{		
		tickerable:function(o)
		{
			o=wp.bob(o)
			wp.each(this.v,function(a,i){
				var I=a[i];
				//alert(wp.tickerable.caller)
				if(I.webplug=="ticker"){
					wp(I).ticker.start(o)
					return this
				}
				I.wpObject=o;
				I.webplug="ticker";
				I.theme=o.theme;
				wp.css.add(o,"ticker");
				wp(I).addCSSName("wp"+I.theme+"Ticker")
				I.innerHTML="<span class='wpTickerSpan'>"+I.innerHTML+"</span>"
				
				//I.innerHTML="<span class='wpTickerSpan'>"+tO.innerHTML+"</span>"
				
				wp(I).ticker.start(o)
				//I.tickerObject=o
			})
			return this
		},
		ticker:{
			exec:function(v,o)
			{
				wp(v).tickerable(o);
			},
			encaseChars:function(h,start,m){
				var taa="",skip,tX

				if(!m)m=h
				var S=""
				
				if(m.tickerLeft || m.tickerTop){
					var S=" style='"
					if(m.tickerLeft)S+="left:"+wp.px(m.tickerLeft)
					if(m.tickerTop)S+=";top:"+wp.px(m.tickerTop)
					S+="'"
				}
					
				
				if(h.tickerEncased)return 
				//alert(S)
				wp.each(h.childNodes,function(a,i){
					taa=""
					if(a[i]&&a[i].nodeType==3){
					//	alert(a[i].nodeValue + " - " +  taa)
						var ti=a[i].nodeValue.split("");
						for(var x=0;x<ti.length;x++){
							skip=0
							tX=0
							if(ti[x+1]==" "){
								tX=x+1
								while(ti[tX]==" "){
									ti[x]+=" "
									skip++
									tX++
								}
							}
							
							taa+="<div class=wpTickerItem "+S+">"+wp.htmlEncode(ti[x])+"</div>"
							x=x+skip
							a[i].nodeValue=a[i].nodeValue.substr(1,a[i].nodeValue.length)
						}
						var aaa=wp.addNode("span")
						
						aaa.innerHTML=taa
						//alert(taa)
						a[i].parentNode.replaceChild(aaa,a[i]);
					}
					else{
						if(a[i])
						wp.ticker.encaseChars(a[i],1,m)
					}
				})
				
				h.tickerEncased=true;
				
				//return this.aa
			},			
			reset:function(e){
				var o,W,pW,H,pH
				wp.each(wp.element.v,function(a,i){
					o=a[i].childNodes[0]
					W=o.offsetWidth;
					pW=a[i].offsetWidth
					H=o.offsetHeight;
					pH=a[i].offsetHeight
					var B=wp.css.box(a[i])
					
					if(e.effect=="leftToRight")o.style.left=wp.px(-W-B[3])
					if(e.effect=="rightToLeft")o.style.left=wp.px(pW)					
					if(e.effect=="topToBottom")o.style.top=wp.px(-H-B[0]-B[2])
					
				})
			},
			start:function(e){
				var o,W,pW,H,pH
				wp.each(wp.element.v,function(a,i){
					var I=a[i]
					//wp.debug.objects(I)
					//alert(I.tagName +" - " + I.innerHTML)
					
					wp.ticker.encaseChars(I)
					
					
					o=I.childNodes[0]
					W=o.offsetWidth;
					pW=I.offsetWidth
					H=o.offsetHeight;
					pH=I.offsetHeight




var B=wp.css.box(I)


					if(e.stop=="center"){
						pW=(pW/2)-(W/2)-B[3]
						//pH=(pH/2)-(H/2)
					}

					if(e.stop=="left"){
						pW=W=0;
					}

					if(e.stop=="right"){
						//wp.debug.objects(B)
						pW=pW-B[1]-(B[9]*2)-W
					}

					if(e.stop=="top"){
						//wp.debug.objects(B)
						H=0
					}

					if(e.stop=="bottom"){
						//wp.debug.objects(B)
						pH=pH-B[2]-(B[10]*2)-H
					}





					if(e.stop=="middle"){
						//pW=(pW/2)-(W/2)-B[3]
						//pH=(pH/2)-(H/2)-B[0]
						
					}



if(!isNaN(e.stop)){
	//W=e.stop
	//H=e.stop
	pW=e.stop
	pH=e.stop
}



W=W+B[3]
H=H+B[1]


//alert(pH)

//wp.debug.objects()



					if(!I.tickerStatus){
						//I.tickerStatus=e.effect;
						//wp(I).ticker.reset(e);
					} else {
						//if(I.tickerStatus==e.effect)wp(I).ticker.reset(e);
					}
					//alert(e.easing)
					if(!e.easing)
					{
						ff="linearTween";
						ff="elasticOut";
						//ff="backOut";
						//ff="bounceOut";
						//ff="easeIn"
					}else{
						ff=e.easing
					}
					
					//alert(ff)
					
					Ffps=40;
					Fframes=140;
					if(e.fps)Ffps=e.fps
					if(e.frames)Fframes=e.frames
					
					
					var scatterGap=20
					if(e.scatterGap)scatterGap=e.scatterGap*1
					
					//W=100
					
					
					//alert(e.scatterGap)
					
					
					
					if(e.effect=="scatterBottom"){
						var tout=0
						I.tickerTop=pH
						wp.each(".wpTickerItem",function(a,i){
							tout=tout+scatterGap
							setTimeout(function(){
								wp(a[i]).animateStyle({style:"top:"+(pH)+"px;",frames:Fframes,fps:Ffps,easing:ff});
							},tout)
						})
					}
					

					if(e.effect=="scatterRight"){
						var tout=0
						//var aaii
						I.tickerLeft=pW
						
						wp.each(".wpTickerItem",function(a,i){
							tout=tout+scatterGap
							//aaii=a[i]
							setTimeout(function(){wp(a[i]).animateStyle({style:"left:"+pW+"px;",frames:Fframes,fps:Ffps,easing:ff});
							},tout)
						})
						
						//aaii.oncomplete=function(e){
							//alert(wp.parentPlug(e,"ticker").innerHTML)
						//}
					}

					
					
					
					if(e.effect=="leftToRight")wp(o).animateStyle({style:"left:"+pW+"px;",frames:Fframes,fps:Ffps,easing:ff});
					if(e.effect=="rightToLeft")wp(o).animateStyle({style:"left:"+(-W)+"px;",frames:Fframes,fps:Ffps,easing:ff});
					if(e.effect=="topToBottom")wp(o).animateStyle({style:"top:"+(pH)+"px;",frames:Fframes,fps:Ffps,easing:ff});
					if(e.effect=="bottomToTop")wp(o).animateStyle({style:"top:"+(-H)+"px;",frames:Fframes,fps:Ffps,easing:ff});
					
					
					//alert(a[i] + " -  "+  e)
				})
				//wp.debug.objects(wp.element.v)
			},
			stop:function(){
				
			},
			onComplete:function(){
				alert(this)
			},
			changeText:function(t){
				wp.each(wp.element.v,function(a,i){
					a[i].tickerEncased=false
					a[i].webplugs=null
					a[i].innerHTML=t
					wp.ticker.encaseChars(a[i])
					//wp(a[i]).ticker.start(a[i].tickerObject,)
				})
			}
		}
	}
)	
