/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: webplugseditor.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Milonic DHTML Menu to Webplugs Menu Converter Module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("window,ajax,string,keyboard,texteditor,html");

// Just rename everything that is "menueditor" with the name of your module, so do a global find/replace "menueditor" with "nameofyourmodule" - then save as /webplugs/nameofyourmodule.js
// Tip: use all lower case and do not use any puntuation - including underscores

wp.extend(
{
	webplugseditable:function(o)
	{
		
		if(wp.get("__wpWebplugsEditor"))return
		o=wp.bob(o);
		var bMainMenu={
			orientation:"horizontal"
			,shadow:{style:"Test",mainMenu:false}
			,openEffect:function(e){
				wp(e).fade({action:"in"});
			}
			,closeEffect:function(e){
				wp(e).fade({action:"out"});
			}			
			,items: [
					{ text:"File", href:"#", submenu:{
						items: [
							{ text:"New",     href:"#", onclick:function(){wp.debug.objects(this)}, icon:"new.gif" },
							{ text:"Open",    href:"#", onclick:function(){wp.editor.openDialog('open',I)}, icon:"open.gif" },
							{ text:"Close",   href:"#", icon:"transparent.gif"},
							{ text:"Save",    href:"#", icon:"save.gif" },
							{ text:"Save As", href:"#", icon:"transparent.gif" },
							{ text:"Exit",    href:"#", icon:"transparent.gif" }
							]
						}
					},
					{
						text:"Webplugs Objects",submenu:{
							items:new function(){
								var A=[];
								wp.each(wp.getPlugs(),function(a,i){
									var isPlug=1
									//alert(a + " - " + i  + " - " +a[i])
									if(!a[i].webplug || (a[i].webplug=="menu"&&!a[i].mainMenu))isPlug=0
									
									if(isPlug){
										A.push({text:a[i].webplug + " - " + a[i].className,href:"#",
											onmouseover:function(){
												
												a[i].D=wp.addNode("div")
												a[i].D.style.position="absolute"
												a[i].D.style.border="2px solid red"
												
												var P=wp.getLoc(a[i])
												a[i].D.style.top=wp.px(P.top-5);
												a[i].D.style.left=wp.px(P.left-5);
												a[i].D.style.height=wp.px(P.height+5);
												a[i].D.style.width=wp.px(P.width+5);
												
											},
											onmouseout:function(){
												if(a[i].D)wp.removeNode(a[i].D)
											},
											onclick:function(e){
												var E=wp.getE(e),V
						
												if(a[i].webplug=="tree"||a[i].webplug=="collapse")V=wp.getMenuValuesFromHTML(a[i].innerHTML)
												if(a[i].webplug=="menu"){
													V=wp.getMenuValuesFromHTML(a[i].getElementsByTagName("UL")[0].innerHTML)
													
													
													
													
												}
												if(a[i].webplug=="tab")V=wp.getTabData(a[i])
												
												
												
												var itemText=""
												for(var B=0;B<V.length;B++){
													for(var D=0;D<V[B]['depth']-1;D++){
														itemText+="\t"
													}
													
													itemText+=V[B]['text']+"\n"
												}
												
												
												var activeItem
												wp(E).changeWindowContent("<table border=1><tr><td class=edTd><textarea id=itext>"+itemText+"</textarea></td><td id=itext2d><div class=edT2 id=itext2></div></td></tr></table>")
												wp("itext").texteditable({
														theme:"Webplugs"
														,onkeyup:function(e){
															//wp.debug.objects(e)
															//if(e.keyCod)
															wp.editFormUpdate(e,V,a[i]);
															wp.editFormAction(e,V,a[i])
														}
														,onkeypress:function(e){
															wp.editFormAction(e,V,a[i])
														}
														,onkeydown:function(e){
															wp.editFormAction(e,V,a[i])
														}
														,onclick:function(e){
															wp.editFormUpdate(e,V,a[i]);
														}
														
													}
												)
												
												setTimeout(function(){ //IE6 crashes randomly without this timeout
													var T=wp.parentPlug(E,"window")
													wp.webplugseditor.tidy(T)
												},1)													
												

/* This is a fix for Opera
Opera ignores cancelEvent on tab key, this is a workaround to fix that
*/
wp.addEvent(wp.get("itext"),"blur",function(e){
	var E=wp.getE(e)
//	E.focus();
})


											}
										})
									}
								})
								return A;
							}
						}

					},
					{ text:"Edit", href:"#", submenu:{
						items: [
							{ text:"Sub Menu 1 Item1", href:"#" },
							{ text:"Sub Menu 1 Item2", href:"#", submenu: {
									items: [
										{ text:"Sub Menu 2 Item1", href:"#" },
										{ text:"Sub Menu 2 Item2", href:"#" },
										{ text:"Sub Menu 2 Item3", href:"#" }
									]
								} 
							},
							{ text:"Sub Menu 1 Item3", href:"#" }
							]
						}
					},
					{ text:"View", href:"#", submenu:{
						items: [
							{ text:"Sub Menu 1 Item4", href:"#" },
							{ text:"Sub Menu 1 Item5", href:"#" },
							{ text:"Sub Menu 1 Item6", href:"#" }
						]
						}
					},
					{ text:"Insert", href:"#" }
				]
			}

			var toolbarData={
				items: [
					{ icon:"new", overicon:"new_over", onclick:function(){wp.editor.openDialog("new",I)} },
					{ icon:"open", overicon:"open_over", onclick:function(){wp.editor.openDialog('open',I)} },
					{ icon:"save", overicon:"save_over", onclick:function(){wp.editor.setProperty('save',I)} },
					{ icon:"table", overicon:"table_over", onclick:function(){wp.debug.objects(wp.childrenFromSelection(a.contentWindow))} },
				]
			}

			var newWin=wp.window.create(
			{
				title:"Webplugs Editor"
				,status:"Web Editing Made Easy"
				,height:300
				,width:900
				,id:"__wpWebplugsEditor"
				,menu:bMainMenu
				//,contentCSS:"padding:10px;border:3px solid green;font-size:20px;;"
				,toolbar:toolbarData
				,onload:function(e){
					wp(e).setAlignment("center;middle")
				}
				,onresize:function(e){
					wp.webplugseditor.tidy(e)
				}
				,content:"Menus: "+wp.getPlugs("menu")+"<hr>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>Here is some content <br>"
				,theme:"Venom"
			});
			
			wp.path=null;
		return this
	},
	editFormUpdate:function(e,V,I){
		var E=wp.getE(e),ln=wp.getCaretLineNumber(E)-1,obj=wp.get("itext2"),plug=I.webplug
		
		if(ln!=obj.lineNumber){
			var v=V[ln]['data'],html=""
			//var text=V[ln]['text']
			
			if(plug=="menu"||plug=="tree"||plug=="collapse"){
				html=html+'<form id="wpEditForm">';
				html=html+'Text:<input name="html" value="'+v['html']+'"></input><br>'
				html=html+'class:<input name="class" value="'+wp.getAttrElement(v['attr'],"class")+'"></input><br>'
				html=html+'href:<input name="href" value="'+wp.getAttrElement(v['attr'],"href")+'"></input><br>'
				html=html+'rel:<input name="rel" value="'+wp.getAttrElement(v['attr'],"rel")+'"></input><br>'
				html=html+'target:<input name="target" value="'+wp.getAttrElement(v['attr'],"target")+'"></input><br>'
				html=html+'</form>';
			}
			
			html+=wp.print_r(v)
			
			obj.innerHTML=html
			obj.lineNumber=ln
		}
	},
	editFormAction:function(e,V,I){
		var E=wp.getE(e);
		var A=I.getElementsByTagName("A");
		var num=wp.getCaretLineNumber(E)-1;
		var txt=wp.getCaretLine(E);
		var K=e.keyCode;
		sel=wp.getCaret(E)
		A[num].innerHTML=txt;
		
		
		if(wp.msie)wp.setCaret(E,sel.start,sel.start)
		V[num]['data']['html']=wp.trim(txt);
		wp.get("wpEditForm")['html'].value=wp.trim(txt);		



		if(I.webplug=="menu"){
			var el=A[num]
			while(el&&el.tagName!="UL"){
				el=el.parentNode
			}
			if(el.built){
				var mi=wp.get(A[num].wpId)
				mi=mi.getElementsByTagName("A")[0]
				if(mi){
					mi.innerHTML=txt
				}
			}
		}
		
		
		if(I.webplug=="tree"||I.webplug=="collapse"){
		}
		
	},
	getTabData:function(e){
		var V={}
		V.data=[]
		V.editText=""
		wp.each(wp.seek(".wpTabHeading",e),function(a,i){
			if(a[i].tagName=="SPAN"){
				V.data.push(a[i].innerHTML)
				V.editText+=a[i].innerHTML+"\n"
			}
		})
		return V
	},
	getMenuValuesFromHTML:function(ar,elementDepth,depth,ITEMS){

		if(wp.getType(ar)=="String"){
//			alert(ar)
			ar=wp.htmlToArray(ar)
		}
		if(depth==null){
			depth=0;
			var ITEMS=[]
		}
		for(var a in ar){
			if(typeof(ar[a])!="function"){
				for(var b in ar[a]){
					if(b=="tag"&&(ar[a][b]=="a")){
						var tN="";
						for(var C in ar[a]['children']){
							if(ar[a]['children'][C]['textnode']){
								tN+=ar[a]['children'][C]['textnode']
							}
						}
						if(ar[a]['depth']>elementDepth)depth++;
						ITEMS.push([])
						ITEMS[ITEMS.length-1]['text']=ar[a]['html']+tN
						ITEMS[ITEMS.length-1]['depth']=depth
						ITEMS[ITEMS.length-1]['data']=ar[a]
					}
					if(b=="children"){
						wp.getMenuValuesFromHTML(ar[a][b],ar[a]['depth'],depth,ITEMS);
					}
				}
			}
		}
		return ITEMS
	},
	arrayToIndentMenu:function(ar,depth){
		if(!depth)wp.h2IM="";
		for(var a in ar){
			for(var b in ar[a]){
				if(b!="depth" && b!="children")	
				wp.h2IM+=wp.indent(ar[a]['depth']-1)+b+": "+ar[a][b]+"\n";
				if(b=="children"){
					wp.arrayToIndentMenu(ar[a][b],1);
				}
			}
		}
		return wp.h2IM
	},
	webplugseditor:{
		exec:function(v,o)
		{
			wp(v).webplugseditable(o);
		},
		tidy:function(e){
			if(!e.tagName)return
			if(wp.seek(".wpEditorArea",e)){
				var wnHght=wp.seek(".wpWinContent",e)[0].offsetHeight-45
				var wnWdth=wp.seek(".wpWinContent",e)[0].offsetWidth-65
				wp.seek(".wpEditorArea",e)[0].parentNode.style.height=wp.px(wnHght)
				wp.seek(".wpEditorArea",e)[0].parentNode.style.width=wp.px(wnWdth/2)
				wp.seek(".edT2")[0].style.height=wp.px(wnHght)
				wp.seek(".edT2")[0].style.width=wp.px(wnWdth/2)
			}
		}
	}
}
)
