/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: ajax.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs AJAX Framework
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("preload");

wp.extend(
{
	ajax:{
		exec:function(v,o)
		{
			if(o&&o.url){
				o.v=v
				if(o.action=="download")wp.download(o)
				if(o.action=="upload"){}
			}
		},
		appendURL:function(u,a){
			if(u.indexOf("?")<0){
				u=u+"?"
			}
			else{
				u=u+"&"
			}
			u=u+a
			return u
		},
		//fixurl:function(u){
//			return u
		//},
		confAjax:function(o,t){
			var ajx=new wp.ajaxProto();
			if(!o.v&&t.v)o.v=wp.get(t.v)
			if(o.onbeforeload)o.onbeforeload(o)
			if(o.errorReporting)ajx.errorReporting=o.errorReporting;
			ajx.v=o.v;
			ajx.url=o.url;
			//ajx.preload=o.preload;
			return ajx;
		}
	},
	ajaxProto:function(o){},
	download:function(o)
	{
		//document.body.style.cursor="move"
		//document.body.style.cursor="move"
		var myAjax=wp.ajax.confAjax(o,this)
		if(o.onload)myAjax.onload=o.onload;
		myAjax.load();
		if(o.oncomplete)myAjax.oncomplete=o.oncomplete;
		return this.v;
	},
	upload:function(o)
	{
		var myAjax=wp.ajax.confAjax(o,this)
		myAjax.content=o.content;
		myAjax.upload();
		return this.v;
	}
})

wp.ajaxProto.prototype={
	stateChanged:function(){
		if (this.A.readyState==4){
			this.status=this.A.status;
			if(this.status==200 || this.status==0){
				wp.preload.show(0,this);
				if(this.onload)this.onload(this.A.responseText,this.A.responseXML);
				return;
			}
			alert("Error: "+this.status);
		}
	},
	getAjaxObject:function(u){
		var o;
		if(window.XMLHttpRequest)o=new XMLHttpRequest()

		if(wp.msie&&((!o)||(u&&u.substr(0,5)=="file:"))){ // If local file and Internet Explorer need to use Active
			try{o=new ActiveXObject("Msxml2.XMLHTTP")}
			catch(e){o=new ActiveXObject("Microsoft.XMLHTTP")}			
		}
		
		return o;
	},	
	load:function(){
		var t=this;
		t.status=null;
		//t.url=wp.ajax.fixurl(t.url)
		t.A=t.getAjaxObject(t.url);
		//wp.preload.show(1,t);
		t.A.onreadystatechange=function(){t.stateChanged()};
		t.A.open("GET",t.url,true);
		t.A.setRequestHeader("Pragma","no-cache");
		t.A.setRequestHeader("Cache-control","no-cache");
		t.A.send(null);
	},
	upload:function(){
		var t=this;		
		//t.url=wp.ajax.fixurl(t.url)
		t.A=t.getAjaxObject(t.url);
		//wp.preload.show(1,t);
		var E=t.errorReporting;
		if(!t.url){if(E)alert("AJAX Error: No URL Specified");return}
		t.A.onreadystatechange=function(){t.stateChanged()};
		t.A.open("POST",t.url,true);
		if(t.onload)t.A.action=t.onload;
		if(E)t.A.errorRep=E;
		t.A.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
		t.A.setRequestHeader("Content-length", t.content.length);
		t.A.setRequestHeader("Connection", "close");
		t.A.send(t.content);
	}
}
