/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: button.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: Milonic Shared Source License
	    Details: Convert HTML Object into an image based button
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("css");
wp.extend(
	{		
		buttonable:function(o)
		{
			o=wp.bob(o)
			wp.each(this.v,function(a,i){
				var I=a[i],oCn=I.className;
				//alert(I.innerHTML)
				I.wpObject=o;
				if(I.webplug=="button" || wp.parentPlug(I,"button"))return;
				
				if(oCn.match("wpNoButton"))return; // disables the tab item if its className contains wpNoButton
				
				if(!o.theme)o.theme=wp.getTheme(I);
				if(o.theme)I.className+=" wp"+o.theme+"Button";
				if(o.className)I.className+=" "+o.className;
				I.theme=o.theme;
			
				wp.css.add(o,"button");
			
				I.webplug="button";

				var H=I.innerHTML;
				I.innerHTML="";
				var wa=wp.addNode,d1=wa(I,"span"),d2=wa(d1,"span"),d3=wa(d2,"span"),d4=wa(d3,"span");
				
				d1.className="wpButtonLeft";
				d2.className="wpButtonRight";
				d3.className="wpButtonMid";
				
				var cls,clsA;
				if(o.theme){
					//cls="wp"+o.theme+"ButtonHover"
					//clsA="wp"+o.theme+"ButtonActive"
				}
				if(o.className){
					//cls=o.className+"Hover"
					//clsA=o.className+"Active"
				}
				
				
				cls="wpButtonLeftHover"
				
				if(o.group){
					if(!wp.buttonGroups)wp.buttonGroups={}
					var G=wp.buttonGroups
					if(!G[o.group])G[o.group]=[]
					G[o.group].push(I)
				}
				
				
				//wp.addEvent(I,'focus',function(e){wp(I).addCSSName(cls)});
				//wp.addEvent(I,'blur',function(e){wp(I).delCSSName(cls)});
				wp.addEvent(I,'mouseover',function(e){
					//clearTimeout(I.outT)
					wp(I).addCSSName("wpButtonHover")
				});

				
				// get system to allow for modules to enable and disable events
				// Eliteemail menu will work if we remove the mouseout event
				wp.addEvent(I,'mouseout',function(e){
					//I.outT=setTimeout(function(){
							wp(I).delCSSName("wpButtonHover")
						//},50)
					});
				
				
				
				wp.addEvent(I,'focus',function(e){
					wp(I).addCSSName("wpButtonFocus")
				})

				wp.addEvent(I,'blur',function(e){
					wp(I).delCSSName("wpButtonFocus")
				})


				wp.addEvent(I,'keyup',function(e){
				})

				
				
				wp.addEvent(I,'click',function(e){
					if(I.wpObject.group){
						wp.each(wp.buttonGroups[I.wpObject.group],function(a,i){
							if(a[i].isActive){
								wp(a[i]).delCSSName("wpButtonClick")
							}
						})
					}
					
					if(I.className.indexOf("wpButtonClick")>-1){
						wp(I).delCSSName("wpButtonClick")
						I.isActive=0
					}
					else{
						wp(I).addCSSName("wpButtonClick")
						I.isActive=1
					}
					
					
					wp(I).delCSSName("wpButtonHover")
					wp(I).addCSSName("wpButtonClick")
					
					wp.cancelEvent(e)
				});
				
				
				d4.className="contentB "+oCn;
				d4.innerHTML=H;
				
				wp.setEvents(I,o); // Transfer the events from the menu object
				
				//salert(I.className)
				
				if(I.className.match(/wpButtonActive/))o.active=1
				
				//o.active=1
				if(o.active){
					wp(I).addCSSName("wpButtonFocus")
					//alert(I.tagName)
					I.defaultButton=1
					setTimeout(function(){
						I.focus()
					//	alert(I)
					//alert("will need to see if this needs to go elsewhere without timeout")
					},50)
					
				}
			})
			return this
		},
		button:{
			exec:function(v,o)
			{
				wp(v).buttonable(o);
			},	
			menuButtons:function(M,o)
			{
				var A=M.getElementsByTagName("a"),b;
				o.mainButtons.group="buttGroup"+wp.uId++
				for(b=0;b<A.length;b++){
					wp(A[b]).buttonable(o.mainButtons)
				}
			},
			on:function(I)
			{
				/*
				//var T=o.type?"-"+o.type:"";
				//wp(I).addCSSName("wp"+I.wpObject.theme+"ButtonHover"+I.wpObject.type?"-"+I.wpObject.type:"")
				var T=I.wpObject.type?"-"+I.wpObject.type:"";
				var cls
				if(I.wpObject.theme)cls="wp"+I.wpObject.theme+"ButtonHover"+T
				if(I.wpObject.className)cls=I.wpObject.className+"Hover"
				wp(I).addCSSName(cls)
				*/
			},
			off:function(I)
			{
				/*
				var T=I.wpObject.type?"-"+I.wpObject.type:"";
				var cls
				
				if(I.wpObject.theme)cls="wp"+I.wpObject.theme+"ButtonHover"+T
				if(I.wpObject.className)cls=I.wpObject.className+"Hover"


				wp(I).delCSSName(cls)
				*/
			},
			active:function(I)
			{
				/*
				var T=I.wpObject.type?"-"+I.wpObject.type:"";
				var cls
				if(I.wpObject.theme)cls="wp"+I.wpObject.theme+"ButtonActive"+T
				if(I.wpObject.className)cls=I.wpObject.className+"Active"

				wp(I).addCSSName(cls)
				*/
			}
		}
	}
)	
