/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: colorpicker.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Color Picker
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("dragdrop,css,math,mask,position");

wp.extend({		
	colorable:function(o)
	{
		//if(wp.v)wp.old=wp.v		
		//this.tmp=new wp.colPick(o);
		//return wp;
		o=wp.bob(o)
		wp.each(this.v,function(a,i){
			var I=a[i];

			var t=wp.colorpicker,ihtml,A,S,B
			if(!o.swatchSize)o.swatchSize=160;
			I.t=t
			t.Sz=o.swatchSize;
			wp.css.add(o,"colorpicker");
			I.className+=" wpColorPicker";
			//S=wp.getPath()+"themes/colorpicker/"+o.theme;
			
			S=wp.getPath(o.path)+"themes/"+o.theme+"/colorpicker/";
			//alert(S)
			
			
			t.lum=120;
			
			ihtml=''
			+'<div style="border:0;">'
			+'<img class=wpCpWheel style="width:'+t.Sz+'px;height:'+t.Sz+'px;" src='+S+'/swatch.jpg></img>'
			+'<img class=wpCpSel src='+S+'/select.gif></img>'
			+'<img class=wpCpSli src='+S+'/slide.gif></img>'
			+'<div class=wpCpLumC style=";height:'+t.Sz+'px;margin-left:'+(t.Sz+6)+'px;">'
			+'<div class=wpCpLum>';
			
			var incs=32;
			var val=t.Sz/incs;
			var tfrac=0;
			var a
			for(a=0;a<incs;a++){
				tval=(val+tfrac);
				ihtml+='<div style="font-size:1px;height:'+Math.floor(tval)+'px;"></div>';
				tfrac=wp.getfraction(tval);
			}
	
			ihtml+='</div></div></div>';
			I.innerHTML=ihtml+I.innerHTML;
			
			A=I.getElementsByTagName("*");
			for(a=0;a<A.length;a++){
				B=A[a].className
				if(B=="wpCpWheel")t.cw=A[a];
				if(B=="wpCpSel")t.cp=A[a];
				if(B=="wpCpSli")t.ls=A[a];
				if(B=="wpCpLumC")t.ld=A[a];
			}
			t.form=I.getElementsByTagName("FORM")[0]
			
			var F=t.form
			if(F)
			{
				//var Oj={mask:"999",max:240,min:0}
				wp(F.Hue).maskable({mask:"999",max:240,min:0})
				wp(F.Sat).maskable({mask:"999",max:240,min:0})
				wp(F.Lum).maskable({mask:"999",max:240,min:0})
				wp(F.Red).maskable({mask:"999",max:255,min:0})
				wp(F.Green).maskable({mask:"999",max:255,min:0})
				wp(F.Blue).maskable({mask:"999",max:255,min:0})
				wp(F.Hex).maskable({mask:"HHHHHH"})
			}
	
			wp(t.cp).dragable(
			{
				bindOffsetX:9,
				bindOffsetY:9,
				binding:I.childNodes[0].childNodes[0],
				//yOffset:parseInt(I.parentNode.previousSibling.style.height),
				ondrag:function(T)
				{
					
					t.hue=Math.round((T.offsetLeft+9)*(240/(t.Sz+1)))
					t.sat=(240-Math.round((T.offsetTop+9)*(240/(t.Sz+1))))
					setTimeout(function(){
						
					//alert(t)
						wp.colorpicker.sC(t)
						
						},10)
				}
			})
			
			wp(t.ls).dragable(
			{
				//min:-9,
				//max:(t.Sz-4),
				bindOffsetY:3,
				bindOffsetX:3,
				//yOffset:parseInt(I.parentNode.previousSibling.style.height),
				xfix:true,
				binding:I.childNodes[0].childNodes[0],
				ondrag:function(T)
				{
					t.lum=Math.round((t.Sz-(T.offsetTop+3))*(241/t.Sz))-1
					setTimeout(function(){wp.colorpicker.sC(t)},10)
				}
			})
	
			wp.addEvent(t.cw,'mousedown',function(e){
				var x,y
				if(e.offsetX>-1){
					x=e.offsetX;
					y=e.offsetY;
				}
				else{
					x=e.layerX;
					y=e.layerY;
				}
				t.cp.style.top=(y-9)+"px"			
				t.cp.style.left=(x-9)+"px"
				t.hue=Math.round((t.cp.offsetLeft+9)*(240/(t.Sz)))
				t.sat=(240-Math.round((t.cp.offsetTop+9)*(240/(t.Sz))))
				t.sC(t)
			});
	
			wp.addEvent(t.ld,'mouseup',function(e){
				var x,y
				if(e.layerX>-1){
					x=e.layerX;
					y=e.layerY;
				}
				else{
					x=e.x;
					y=e.y;
				}
				//y=wp.getE(e)
				//alert((y-3)+"px")
				t.ls.style.top=(y-3)+"px"
				//alert(t.cp.offsetTop + " - " + t.ls.offsetTop)
				
				//wp.debug.objects(e)
				
				//alert(e.layerY)
				
				t.lum=Math.round((t.Sz-(t.ls.offsetTop+3))*(240/t.Sz))
				t.sC(t)
			});
			
			wp.addEvent(I,'keyup',function(e){
				//alert(t)
				var E=e.target?e.target:e.srcElement
				if(E.name=="Hue"||E.name=="Sat"||E.name=="Lum")t.setCol(E,t,1)
				if(E.name=="Red"||E.name=="Green"||E.name=="Blue")t.setCol(E,t,2)
				if(E.name=="Hex"){
					//alert(t.setCol)
					t.setCol(E,t)
				}
			});
			//if(wp.old)wp.v=wp.old
		})
		return this
	},
	colorpicker:
	{
		exec:function(v,o)
		{
			wp(v).colorable(o);
		},
		setColor:function(v)
		{
			var cp=wp.get(wp.element.v);
			cp.t.colorpicker.setCol(v,cp.t);
		},
		getColor:function(v)
		{
			var cp=wp.v[0];
			if(v=="hls")
			{
				
			}
			else if(v=="rgb")
			{
				
			}
			else
			{
				R=wp.hlsrgb(cp.t.hue,cp.t.lum,cp.t.sat);
				return wp.rgbhex(R.r,R.g,R.b);
			}
		},
		Fix:function(v)
		{
			if(!v||v=="")v=0
			return parseInt(v);
		},
		setCol:function(e,t,v)
		{
			var F,R,H,r,g,b
			if(typeof(e)=="string")E=e; else E=e.value
			F=t.form		
			
			r=this.Fix(F.Red.value)
			g=this.Fix(F.Green.value)
			b=this.Fix(F.Blue.value)
			
			h=F.Hue.value
			l=F.Lum.value
			s=F.Sat.value
			
			if(v==1)
			{
				if(E>240)return
				R=wp.hlsrgb(h,l,s)
				F.Red.value=R.r
				F.Green.value=R.g
				F.Blue.value=R.b
				H=wp.rgbhex(r,g,b)
				F.Hex.value=H.toUpperCase()			
			}
			else if(v==2)
			{
				if(E>255)return
				H=wp.rgbhls(r,g,b)
				F.Hue.value=H.h
				F.Sat.value=H.s
				F.Lum.value=H.l
				H=wp.rgbhex(r,g,b)
				F.Hex.value=H.toUpperCase()			
			}
			else
			{
				R=wp.hexrgb(E)
				F.Red.value=R.r
				F.Green.value=R.g
				F.Blue.value=R.b
	
				H=wp.rgbhls(R.r,R.g,R.b)
				F.Hue.value=H.h
				F.Sat.value=H.s
				F.Lum.value=H.l
			}
	
			t.hue=F.Hue.value
			t.sat=F.Sat.value
			t.lum=F.Lum.value
			t.ls.style.top=(t.Sz-(F.Lum.value/240)*t.Sz)-3+"px"
			t.cp.style.top=(t.Sz-(F.Sat.value/240)*t.Sz)-9+"px"
			t.cp.style.left=(F.Hue.value/240)*t.Sz-9+"px"
			if(typeof(e)=="string")wp.colorpicker.sC(t); else wp.colorpicker.sC(t,1)
		},
		sC:function(t,Q)
		{
			var 
				rgb,
				N=t.ld.childNodes[0].childNodes,
				x,
				L=240,
				LD=240/32;
			
			for(x=0;x<N.length;x++){
				rgb=wp.hlsrgb(t.hue,L,t.sat)
				N[x].style.background="#"+wp.rgbhex(rgb.r,rgb.g,rgb.b)
				L=L-LD
			}
	
			var F=t.form
			//alert(F)
			rgb=wp.hlsrgb(t.hue,t.lum,t.sat)
			if(F && !Q)
			{
				F.Hue.value=t.hue
				F.Sat.value=t.sat
				F.Lum.value=t.lum
				
				F.Red.value=rgb.r
				F.Green.value=rgb.g
				F.Blue.value=rgb.b
			
				F.Hex.value=wp.rgbhex(rgb.r,rgb.g,rgb.b).toUpperCase()
			}
			if(F)wp(F.parentNode.id+".wpCpSample").strCSS("background:#"+wp.rgbhex(rgb.r,rgb.g,rgb.b))
		}		
	}	
})


