/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: easing.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Easing Animation module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


/*
=============================================================================
Based on Easing equations by Robert Penner http://www.robertpenner.com/easing
For terms of use (http://www.robertpenner.com/easing_terms_of_use.html)
Open source under the BSD License.
Copyright 2001 Robert Penner All rights reserved.
=============================================================================
*/

wp.extend({
	easing:{
		linear:function(t,b,c,d){
			return c*t/d+b;
		},
		easeIn:function(t,b,c,d){
			return c*(t/=d)*t+b;
		},
		easeOut:function(t,b,c,d){
			return -c*(t/=d)*(t-2)+b;
		},
		easeBoth:function(t,b,c,d){
			if((t/=d/2)<1)return c/2*t*t+b;
			return -c/2*((--t)*(t-2)-1)+b;
		},
		easeInCubic:function(t,b,c,d){
			return c*(t/=d)*t*t+b;
		},
		easeOutCubic:function(t,b,c,d){
			return c*((t=t/d-1)*t*t+1)+b;
		},
		easeInOutCubic:function(t,b,c,d){
			if((t/=d/2)<1)return c/2*t*t*t+b;
			return c/2*((t-=2)*t*t+2)+b;
		},
		easeInQuart:function(t,b,c,d){
			return c*(t/=d)*t*t*t+b;
		},
		easeOutQuart:function(t,b,c,d){
			return -c*((t=t/d-1)*t*t*t-1)+b;
		},
		easeInOutQuart:function(t,b,c,d){
			if((t/=d/2)<1) return c/2*t*t*t*t+b;
			return -c/2*((t-=2)*t*t*t-2)+b;
		},
		easeInQuint:function(t,b,c,d){
			return c*(t/=d)*t*t*t*t+b;
		},
		easeOutQuint:function(t,b,c,d){
			return c*((t=t/d-1)*t*t*t*t+1)+b;
		},
		easeInOutQuint:function(t,b,c,d){
			if((t/=d/2)<1) return c/2*t*t*t*t*t+b;
			return c/2*((t-=2)*t*t*t*t+2)+b;
		},
		easeInSine:function(t,b,c,d){
			return -c*Math.cos(t/d*(Math.PI/2))+c+b;
		},
		easeOutSine:function(t,b,c,d){
			return c*Math.sin(t/d*(Math.PI/2))+b;
		},
		easeInOutSine:function(t,b,c,d){
			return -c/2*(Math.cos(Math.PI*t/d)-1)+b;
		},
		easeInExpo:function(t,b,c,d){
			return (t==0)?b:c*Math.pow(2,10*(t/d-1))+b;
		},
		easeOutExpo:function(t,b,c,d){
			return (t==d)?b+c:c*(-Math.pow(2,-10*t/d)+1)+b;
		},
		easeInOutExpo:function(t,b,c,d){
			if(t==0)return b;
			if(t==d)return b+c;
			if((t/=d/2)<1) return c/2*Math.pow(2,10*(t-1))+b;
			return c/2*(-Math.pow(2,-10*--t)+2)+b;
		},
		easeInCirc:function(t,b,c,d){
			return -c*(Math.sqrt(1-(t/=d)*t)-1)+b;
		},
		easeOutCirc:function(t,b,c,d){
			return c*Math.sqrt(1-(t=t/d-1)*t)+b;
		},
		easeInOutCirc:function(t,b,c,d){
			if((t/=d/2)<1)return -c/2*(Math.sqrt(1-t*t)-1)+b;
			return c/2*(Math.sqrt(1-(t-=2)*t)+1)+b;
		},
		easeInElastic:function(t,b,c,d,a,p){
			if(a==undefined)a=1.70158;
			if(t==0)return b;if((t/=d)==1)return b+c;if(!p)p=d*.3;
			if(a<Math.abs(c)){a=c;var s=p/4;}
			else vars=p/(2*Math.PI)*Math.asin(c/a);
			return -(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;
		},
		elasticIn:function(t,b,c,d,a,p){
			if(t==0)return b;
			if((t/=d)==1)return b+c;
			if(!p)p=d*.3;
			if(!a||a<Math.abs(c)){
				a=c;
				var s=p/4;
			}
			else{
				var s=p/(2*Math.PI)*Math.asin(c/a);
			}
			return -(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;
		},
		elasticOut:function(t,b,c,d,a,p){
			//p=2
			//a=2
			if(t==0)return b;
			if((t/=d)==1)return b+c;
			if(!p)p=d*.3;
			if(!a||a<Math.abs(c)){
				a=c;
				var s=p/4;
			}
			else{
				var s=p/(2*Math.PI)*Math.asin(c/a);
			}
			return a*Math.pow(2,-10*t)*Math.sin((t*d-s)*(2*Math.PI)/p)+c+b;
		},
		elasticBoth:function(t,b,c,d,a,p){
			if(t==0)return b;
			if((t/=d/2)==2)return b+c;
			if(!p)p=d*(.3*1.5);
			if(!a||a<Math.abs(c)){
				a=c;
				var s=p/4;
			}
			else{
				var s=p/(2*Math.PI)*Math.asin(c/a);
			}
			if(t<1){
				return -.5*(a*Math.pow(2,10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p))+b;
			}
			return a*Math.pow(2,-10*(t-=1))*Math.sin((t*d-s)*(2*Math.PI)/p)*.5+c+b;
		},
		backIn:function(t,b,c,d,s){
			if(s==undefined)s=1.70158;
			return c*(t/=d)*t*((s+1)*t-s)+b;
		},
		backOut:function(t,b,c,d,s){
			if(s==undefined)s=1.70158;
			return c*((t=t/d-1)*t*((s+1)*t+s)+1)+b;
		},
		backBoth:function(t,b,c,d,s){
			if(s==undefined)s=1.70158;
			if((t/=d/2)<1)return c/2*(t*t*(((s*=(1.525))+1)*t-s))+b;
			return c/2*((t-=2)*t*(((s*=(1.525))+1)*t+s)+2)+b;
		},
		bounceIn:function(t,b,c,d){
			return c-wp.easing.bounceOut(d-t,0,c,d)+b;
		},
		bounceOut:function(t,b,c,d){
			if((t/=d)<(1/2.75))return c*(7.5625*t*t)+b;
			else if(t<(2/2.75))return c*(7.5625*(t-=(1.5/2.75))*t+.75)+b;
			else if(t<(2.5/2.75))return c*(7.5625*(t-=(2.25/2.75))*t+.9375)+b;
			return c*(7.5625*(t-=(2.625/2.75))*t+.984375)+b;
		},
		bounceBoth:function(t,b,c,d){
			if(t<d/2)return wp.easing.bounceIn(t*2,0,c,d)*.5+b;
			return wp.easing.bounceOut(t*2-d,0,c,d)*.5+c*.5+b;
		}
	}
})









