/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: form.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Form manipulation and querying module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.extend(
{
	formValidate:function()
	{
		
		var F=this.v,s,req,message="<p>The following empty fields are required....</p><p style='font-weight:bold;'>",completed=true,ret=true,focusField,fields="",ar=wp.form.toArray(F),theme=null;
		if(wp.getTheme(F))theme=wp.getTheme(F);
		
		wp(wp.get('recaptcha_response_field')).addCSSName('wpFormRequired');
		
		wp.each(wp.seek(".wpFormRequired",F),function(a,i){
			if(!a[i].value){
				a[i].style.background="#ffd4ff";
				
				//alert(a[i].name)
				
				if(!focusField)focusField=a[i];
				completed=false;
				
				if(a[i].name=="recaptcha_response_field"){
					fields+="Recaptcha, ";
				}else{
					var L=wp.previous(a[i].parentNode).innerHTML
					if(L)fields+=L+", "; else fields+=a[i].name+", ";
				}
			}
		})


//recaptcha_response_field


		wp.each(wp.seek(".wpFormMatch",F),function(a,i){
			var C=a[i].className.split("wpFormMatch "),C1,C2
			C=C[1]
			if(C&&a[i].value != F[C].value){
				a[i].style.background="#ffd4ff";
				F[C].style.background="#ffd4ff";

				if(a[i].alt)C1=a[i].alt; else C1=a[i].name;
				if(F[C].alt)C2=F[C].alt; else C2=F[C].name;
					
				wp.msg("<p>Please ensure that the following fields....</p><p><b>'"+C1+"'</b> and <b>'"+C2+"'</b></p><p>both have matching values.</p><p>These have now been highlighted for you.</p>",{theme:theme,
					buttons:{
						OkButton:{
							text:"OK"
							,active:true
							,action:function(){
								wp.window.close(this)
								a[i].focus()
							}
						}
					}
				})	
				ret=false
			}
		})
			
		if(ret){
			fields=fields.substr(0,fields.length-2)
			message+=fields+"</p><p>These have now been highlighted for you.</p>"
			if(!completed){
				wp.msg(message,{theme:theme,
					buttons:{
						OkButton:{
							text:"OK"
							,active:true
							,action:function(){
								wp.window.close(this)
								focusField.focus()
							}
						}
					}
				})	
				ret=false
			}
		}
		
		if(ret && completed){
			var valid=true
			wp.each(wp.seek(".wpFormValidate",F),function(a,i){
				if(!a[i].className.match(/ good/)){
					valid=false
				}
			})
			if(!valid){
				wp.msg("The Form has some problems, please correct before submitting again",{theme:theme});
				ret=false
			}
		}
	return ret
	},
	form:{
		toQueryString:function(v,r) // Creates a query string from a form
		{
			var A=wp.form.toArray(wp.get(v)),qs="";
			for(var x=0;x<A.length;x++){
				qs+=encodeURIComponent(A[x].name)+"="+encodeURIComponent(A[x].value)
				if(x<A.length-1)qs+="&";
			}
			return qs;
		},
		fromQueryString:function(qs) // Populates form fields from a query string
		{
			var FRM=wp.get(wp.element.v),ar=[],qi
			//qs="inp1=INPUT%20ONE&inp2=INPUT%20Two&inp3=INPUT%20Three&inp4=INPUT%20Four&cb1=ON&S1=abc3&R1=2&ta=TEXT%20AREA%20UPDATED&S2=abc2&S2=abc3&S2=abc4";
			wp.each(qs.split("&"),function(a,i){
				qi=a[i].split("=")
				ar.push({name:qi[0],value:decodeURIComponent(qi[1])})
			})
			wp(wp.element.v).form.fromArray(ar)
		},
		fromArray:function(v)
		{
			var FRM=wp.get(wp.element.v),item;
			wp.each(v,function(a,i){
				item=FRM[a[i].name]
				if(item.length){
					for(var A=0;A<item.length;A++){
						if(item[A].value==a[i].value){
							if(item[A].nodeName=="OPTION"){
								if(!a[i].selected)a[i].selected=true
								item[A].selected=a[i].selected
							}
							else{
								if(!a[i].checked)a[i].checked=true
								item[A].checked=a[i].checked
							}
						}
					}
				}
				else{
					if(a[i].value!=null)item.value=a[i].value
					if(item.type=="checkbox"){
						if(a[i].value==null)item.checked=false; else item.checked=true
					}
				}
			})
		},
		toArray:function(v) // Creates an array of values from form fields
		{
			var E=v.getElementsByTagName('*'),aR=[],V,N;
			for(var x=0;x<E.length;x++){
				V=wp.form.getValue(E[x]);
				N=E[x].name;
				if(V!=null){
					if(V.constructor==Array){
						for(var a=0;a<V.length;a++)aR.push({name:N,value:V[a]})
					}
					else{
						aR.push({name:N,value:V})
					}
				}				
			}
			return aR;
		},
		getForms:function(V)
		{
			if(!V)V=document.body;
			var FRM=V.getElementsByTagName("*"),ret=[]
			wp.each(FRM,function(a,i){
				if(a[i].tagName=="FORM"){
					ret.push(wp.form.toArray(a[i])) // returns an array of the forms elements
				}
			})
			return ret
		},
		putValue:function(v)
		{
			//same as getValue but in reverse, required by fromArray
		},
		getValue:function(v)
		{
			if(typeof(v)=="string"){
				var FRM=document.body.getElementsByTagName("*")
				wp.each(FRM,function(a,i){
					if(a[i].name==v){
						v=a[i]
					}
				})
				if(!v.tagName)return false
			}

				
			
		  	var tN = v.tagName.toLowerCase();
		  	var T = v.type;
		  	var val=v.value;
			if(!v.name||v.disabled||T=="reset"||T=="submit"||T=="button"||T=="image"||((T=="checkbox"||T=="radio")&&!v.checked)||(tN=="select"&&v.selectedIndex<0))return null;
			if(tN=="select"){
				var idx=v.selectedIndex,ar=[],O=v.options,sOne=0,lgt=0;
				if(idx<0)return null;
				if(T=="select-one")sOne=1;
				if(sOne)lgt=idx+1;else lgt=O.length;
				for(var x=idx;x<lgt;x++){
			            if(O[x].selected){

			            	if(wp.msie&&!(O[x].attributes['value']&&O[x].attributes['value'].specified)){
			            		V=O[x].text
			            	}
			            	else{
			            		V=O[x].value
			            	}
			            	
							//var V=wp.msie&&!(O[x].attributes['value'].specified)?O[x].text:O[x].value;
						if(sOne)return V
						ar.push(V);
					}
				}
				return ar;
			}

			return val
		}
	}
})
