/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: html.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs HTML manipulation and quering module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("string,caret");
wp.extend({
	html:{},
	wrap:function()
	{
	},
	removeHTML:function(v)
	{
		var t,i,T,x;
		t="";
		T=v.length;
		for(i=0;i<T;i++){if(v.charAt(i)!="<")t+= v.substr(i,1);else{x=v.substr(i).indexOf(">");i+=x;}}
		return(t);
	},
	isSingleTag:function(t){
		sTags=["br","col","hr","img","input","link","meta","!doctype","!--"];
		t=t.replace(/\//,"")
		for(var a=0;a<sTags.length;a++){
			if(t.toLowerCase()==sTags[a])return true;
		}
		return false;
	},
	getTag:function(t){
		var tag,etP,etS;
		if(t.substr(0,3)=="!--")return "!--";
		etP=t.indexOf(">");
		t=t.substr(0,etP);
		etS=t.indexOf(" ");
		tag=t.substr(0,etS).toLowerCase();
		if(!tag)tag=t.substr(0,etP);		
		tag=wp.str_replace("/>","",tag);
		return wp.trim(tag.toLowerCase());
	},
	getAttr:function(t){
		var attr="",etS,etP;
		etP=t.indexOf(">");
		etS=t.indexOf(" ");
		if(etS>-1)attr=t.substr(etS+1,etP-etS-1)
		//attr=wp.str_replace("\/","",attr)
		return wp.trim(attr);
	},
	getAttrElement:function(a,e){
		var v=a.split(e),S,out;
		if(v.length<2)return "";
		v=v[1].split("=")[1];
		S=v.split("");
		if(S[0]=="\""||S[0]=="'"){
			out=v.substr(1,v.length)
			out=out.substr(0,out.indexOf(S[0]))
		}else{
			out=v.split(" ")[0]
		}
		return out
		
	},
	getHTML:function(t){
		if(t.substr(0,3)=="!--"){
			t=t.substr(3,t.length)
			t=wp.str_replace("-->","",t)
			return t
		}
		etP=t.indexOf(">")
		html="";
		if(etP)html=t.substr(etP+1,t.length)
		return wp.trim(html)
	},
	htmlToArray:function(html){
		var ar=[],HH,tnC,cnt=[],h,x,tar,tag,depth=1,prev,hasChildren,oldDepth=-1,textNode,singleTag,endTag;
	//alert(html)
		html=wp.trim(html);
		html=wp.replaceBetween("<","&lt;",html,"<script","</script")
		html=wp.replaceBetween("<","&lt;",html,"<!--","-->")
//alert(html)
		HH=html.split("<")
		for(x=0;x<HH.length;x++){
			tag=wp.getTag(HH[x])
			textNode="";
			
			if(tag){

				hasChildren=0;
				singleTag=wp.isSingleTag(tag)
				endTag=tag.substr(0,1)=="/"
				if(HH.length>x+1 && !endTag && wp.getTag(HH[x+1]).substr(0,1)!="/" && !singleTag){
					hasChildren=1
				}
				
				tar=[];
				tar['tag']=tag;
				tar['attr']=wp.getAttr(HH[x]);
				tar['html']=wp.getHTML(HH[x]);
				
				if(prev)tar['parent']=prev
				
				if(tag=="script"||tag=="!--"){
					tar['attr']=wp.str_replace("&lt;","<",tar['attr'])
					tar['html']=wp.str_replace("&lt;","<",tar['html'])
				}
				
				if((tag=="li"||tag=="dt") && cnt[depth]){
					if(cnt[depth]['tag']=="li"||cnt[depth]['tag']=="dt"){
						depth--	
						prev=cnt[depth]
					}
				}
				tar['depth']=depth;
				
				if(hasChildren){
					tar['children']=[];
					depth++;
					cnt[depth]=tar;
				}
				else
				{
					deduct=0;
					if(endTag){
						deduct=1;
						if(wp.getTag(HH[x-1]).substr(0,1)!="/")deduct=0;
						if("/"+wp.getTag(HH[x-1]) != tag)deduct=1;
					}
					
					if(endTag||singleTag && ! (tag=="script"||tag=="!--")){
						
						tnC=HH[x].split(">")[1]
						if(tnC){
							tnC=wp.trim(tnC)
							if(tnC){
								var ntar=[]
								ntar['textnode']=tnC
								prev['children'].push(ntar);
							}
						}
					}
					
					
					if(singleTag)deduct=0;
					if(deduct){
						depth--;
						tar['depth']=depth;
					}
				}
				
				if(oldDepth>depth){
					prev=cnt[depth];
				}

				if(tag.substr(0,1)!="/"){
					if(prev&&prev['children']){
						prev['children'].push(tar);
						
					}
					else{
						ar.push(tar);
					}
				}
				if(tar['children'])prev=tar;
				oldDepth=depth;
			}
		}
		return ar
	},
	indent:function(d){
		var out="";
		for(a=0;a<d;a++)out+="\t";
		return out;
	},
	print_r:function(ar,depth){
		if(!depth){
			wp.pR="";
			depth=0;
		}
		typ=wp.getType(ar);

		wp.pR+=typ+"\n";
		wp.pR+=wp.indent(depth);
		if(typ=="Array")wp.pR+="(\n";
		depth++;
		for(var i in ar){
			if(wp.getType(ar[i])=="Array"){
				wp.pR+=wp.indent(depth);
				wp.pR+="["+i+"] => ";
				if(i=="parent"){
					wp.pR+="Array()\n";
				}
				else{
					wp.print_r(ar[i],depth);
				}
			}
			else{
				wp.pR+=wp.indent(depth);
				wp.pR+="["+i+"] => "+ar[i]+ "\n";
			}
		}
		depth--;
		wp.pR+=wp.indent(depth);
		if(typ=="Array")wp.pR+=")\n";
		return wp.pR;
	},
	compRng:function(r1,r2,EE){
		var R
		if (r1.compareEndPoints){
			R=r2.compareEndPoints
/*
			return !(
				R('StartToStart',r1)==1&&
				R('EndToEnd',r1)==1&&
				R('StartToEnd',r1)==1&&
				R('EndToStart',r1)==1||
				R('StartToStart',r1)==-1&&
				R('EndToEnd',r1)==-1&&
				R('StartToEnd',r1)==-1&&
				R('EndToStart',r1)==-1)
	*/		

			
			return !(
				R('StartToStart',r1)==1&&
				R('EndToEnd',r1)==1||
				R('StartToStart',r1)==-1&&
				R('EndToEnd',r1)==-1
				)
			
		}else if(r1.compareBoundaryPoints){
			R=r2.compareBoundaryPoints
			return !(
				r2.compareBoundaryPoints(0,r1)==1&&
				r2.compareBoundaryPoints(2,r1)==1&&
				r2.compareBoundaryPoints(1,r1)==1&&
				r2.compareBoundaryPoints(3,r1)==1||
				r2.compareBoundaryPoints(0,r1)==-1&&
				r2.compareBoundaryPoints(2,r1)==-1&&
				r2.compareBoundaryPoints(1,r1)==-1&&
				r2.compareBoundaryPoints(3,r1)==-1)
		}
		return null; 
	},
	createRangeFromElement:function(el,w)
	{
		if(!w)w=window;
		var rng=null;
		if(w.document.body.createTextRange){
			rng=w.document.body.createTextRange();
			rng.moveToElementText(el);
		}
		else if(w.document.createRange){
			rng=w.document.createRange();
			rng.selectNodeContents(el);
		}
		return rng;
	},
	/*
	getSelectionsNodes:function(w)
	{
		var r=wp.getSelection(w)
		
		
		var r2,N=[],E,a;
		if(r.element.nodeType==3){
			var tst=wp.trim(r.element.nodeValue)
			if(r.html==tst){
				N.push(r.element.parentNode);
			}else{
				var t1=r.html.split("<")[0]
				if(t1){
					var O=document.createTextNode(t1);
					N.push(O)
				}
			}
		}
		else{
			E=r.element.getElementsByTagName("*")
			if(E.length==0&&r.element.tagName)N.push(r.element)
			if(r.html){
				var t1=r.html.split("<")[0]
				if(t1){
					var O=document.createTextNode(t1);
					N.push(O)
				}
				for(a=0;a<E.length;a++){
					r2=wp.createRangeFromElement(E[a],w);
	            	if(r2&&wp.compRng(r.range,r2,E[a])){
	            		N.push(E[a]);
	            		if(E[a].nextSibling.nextSibling&&E[a].nextSibling.nodeType==3){
	            			if(wp.compRng(r.range,wp.createRangeFromElement(E[a].nextSibling.nextSibling,w))){
	            				N.push(E[a].nextSibling)
	            			}
	            		}
	            	}
				}
				
				var t1=r.html.split(">")

				t1=t1[t1.length-1]
				if(t1){
					
					var O=document.createTextNode(t1);
					N.push(O)
				}
			}
		}
*/
		
					/*
							wp.get("ta2").value=""
							for(a=0;a<N.length;a++){
								tt=" - '"
								if(N[a].nodeType==3)tt+=N[a].nodeValue+"' - "
								if(N[a].nodeType==1){
									tt+=N[a].tagName+"' - "
								}
								if(N[a].className)tt+=N[a].className
								wp.get("ta2").value+=N[a]+" - "+tt+"\n"
							}
*/
/*
		
		return N;
	},

	*/
	selectNode:function(v,w)
	{	
		if(!w)w=self;
		var r=wp.getSelection(w),s;
		v=wp.get(v,w);
		//alert(r.type)
		if(r.type=="dom"){
			r.range.selectNode(v);
			var s=w.window.getSelection();
			s.removeAllRanges();
			s.addRange(r.range);
		}
		if(r.type=="msie"){
			r=w.document.body.createTextRange();
			r.moveToElementText(v);
			r.select()
		}
	},
	selectNodeContents:function(v,w)
	{
		if(!w)w=self;
		var r=wp.getSelection(w),o;
		if(r.type=="dom"){
			o=w.getSelection()
			o.collapseToStart();
			o.selectAllChildren(v);
		}
		if(r.type=="msie"){
			r=w.document.body.createTextRange();
			r.moveToElementText(v);
			r.select()
		}
	},
	pasteNode:function(n,w)
	{
		if(!w)w=self;
	 	var t=wp.getSelection(w),nC,nN;

		if(t.type==1){
			if(t.text.getRangeAt)range=t.range
			range.deleteContents();
			nC=w.document.createElement("span");
			nC.id="wpPasted__Node_"			

			//if(wp.lastChr(t.html)==" "){
//				nN=document.createTextNode(" ");
				//t.html=t.html.substr(0,t.html.length-1)
			//}			
			nC.innerHTML=t.html;
			range.insertNode(nC)

//			if(nN){
				//wp.insertNode(nN,nC,0)
			//}
		}
		else if(t.type==3){
			//var ext=""
			//if(wp.lastChr(t.html)==" "){
//				t.html=t.html.substr(0,t.html.length-1)
				//ext=" "
			//}
			//t.range.pasteHTML("<span id=wpPasted__Node_>"+t.html+"</span>"+ext);
			
			t.range.pasteHTML("");
			t.range.pasteHTML("<span id=wpPasted__Node_>"+t.html+"</span>");
			nC=wp.get("wpPasted__Node_",w)
		}
		nC.wpAdded=1
		
		return nC
	},
	convertElement:function(E,t)
	{
		//alert(E+" - " + t + " - " + E.parentNode)
		
		var newE = document.createTextNode(E.innerHTML);
		
		E.parentNode.replaceChild(newE,E)
		
		
	},
	replaceNode:function()
	{
		if(wp.msie)
		{
			//replaceNode
		}
		else
		{
			//replaceChild
		}
	},

	parseHTML:function(h)
	{
		start=new Date()
		var ro={},O=[],x=0,el,indent=0,ID="",HH=h.split("<"),cnt=0;
		var single ="!--,area,base,basefont,br,col,frame,hr,img,input,isindex,link,meta,param,embed";
		var sTa=single.toarray(",")
		
		wp.each(HH,function(a,i){
			var el=a[i],content="",etP=el.indexOf(">"),etS=el.indexOf(" "),sTag=el.substr(0,etP),eTag=el.substr(0,etP);
			//////////////////////////SHOULD sTag=el.substr(0,etP) be sTag=el.substr(0,etS) instead??????????????????????????????????????????????????????????????????????????????????????????????????????????
			if(etS<etP)sTag=el.substr(0,etS);
			
			sTag=sTag.toLowerCase();
			eTag=eTag.toLowerCase();
			
			if(cnt>0){
				content=el.substr(etP+1);
				attr=el.substr(sTag.length,el.indexOf(">")-sTag.length);
				
				if(el.substr(0,3)=="!--"){
					sTag="COMMENT";
					content=el.substr(3,el.indexOf("-->")-3);
					attr="";
				}
				
				if(sTag==""){
					sTag=eTag;
					//content="";
					attr="";
				}
				
				output="Tag:"+sTag;
				if(content!="")output+=" - Content:<font color=red>"+content+"</font>";
				if(attr)output+=" - Attr:<font color=blue>"+attr+"</font>";
				
				var ai=O.length
				O[ai]=output;
				//O[ai].content=content
				//O[ai].attributes=attr
				//O[ai].tagNamet=sTag
			}
			cnt++;
		})
		//alert(O)
		end=new Date()
		//alert(end-start)
		return O;
	},
	deleteRange:function(w)
	{
		//var range=wp.getSelection(w).range
		//showObjProps(w.document)
		//if(w.document.execCommand)
		//{
			w.document.execCommand("delete",false,null)
		//}
		//else
		//{
			//range.deleteContents();
		//}
		//showObjProps(range)
	},
	replaceRange:function(h,w)
	{
		var range=wp.getSelection(w).range
		//alert(w.document.execCommand)
		
		alert(h)
		
		if(wp.msie)
		{
			
			range.pasteHTML(h);
			//w.document.execCommand("delete",false,null)
		}
		else
		{


			//if (t.text.getRangeAt)range=t.range
			range.deleteContents();
			//var nC=w.createElement("SPAN");
			//nC.innerHTML=h;
			range.insertNode(h)

			
			
			//range.insertNode()
			//range.deleteContents();
		}
	}
})