/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: htmleditor.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs HTML editor application module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


/* include the required libraries here */
//wp.dependencies("string,html,tab,toolbar,window,contextmenu,menu,menuapi,ajax,location");
/*

stuff to tidy up:

FONT-FAMILY ;  // IE
FONT-FAMILY "  // IE
style=""       // Firefox


FONTS
Arial=arial
Arial Black=arial black
Book Antiqua=book antiqua
Comic Sans MS=comic sans ms
Courier New=courier new
Georgia=georgia
Helvetica=helvetica
Impact=impact
Symbol=symbol
Tahoma=tahoma
Terminal=terminal
Times New Roman=times new roman,times
Trebuchet MS=trebuchet ms
Verdana=verdana

*/

wp.dependencies("css,caret,window,keyboard,html,toolbar,menu");

wp.extend(
{
	htmleditable:function(o)
	{
		o=wp.bob(o)
		if(!o.theme)o.theme="Webplugs"
		
		wp.each(this.v,function(a,i){
			var I=a[i];
			wp.css.add(o,"htmleditor");
			
			var bMainMenu={
				orientation:"horizontal"
				,shadow:{style:"Test",mainMenu:false}
				,openEffect:function(e){
					wp(e).fade({action:"in"});
				}
				,closeEffect:function(e){
					wp(e).fade({action:"out"});
				}			
				,items: [
					{ text:"File", href:"#", submenu:{
						items: [
							{ text:"New",     href:"#", onclick:function(){wp.debug.objects(this)}, icon:"new.gif" },
							{ text:"Open",    href:"#", onclick:function(){wp.htmleditor.openDialog('open',I)}, icon:"open.gif" },
							{ text:"Close",   href:"#", icon:"transparent.gif"},
							{ text:"Save",    href:"#", icon:"save.gif" },
							{ text:"Save As", href:"#", icon:"transparent.gif" },
							{ text:"Exit",    href:"#", icon:"transparent.gif" }
							]
						}
					},
					{
						text:"Webplugs Objects",submenu:{
							items:new function(){
								return ""
							}
						}

					},
					{ text:"Edit", href:"#", submenu:{
						items: [
							{ text:"Sub Menu 1 Item1", href:"#" },
							{ text:"Sub Menu 1 Item2", href:"#", submenu: {
									items: [
										{ text:"Sub Menu 2 Item1", href:"#" },
										{ text:"Sub Menu 2 Item2", href:"#" },
										{ text:"Sub Menu 2 Item3", href:"#" }
									]
								} 
							},
							{ text:"Sub Menu 1 Item3", href:"#" },
							{ icon:"fontWeight", overicon:"fontWeight_over",text:"Bold", href:"#",onmouseup:function(e){wp.htmleditor.setProperty(I,'font-weight','bold',e)} },
							{ text:"Italic", href:"#",onmouseup:function(e){wp.htmleditor.setProperty(I,'font-style','italic',e)} },
							{ text:"Underline", href:"#",onmouseup:function(e){wp.htmleditor.setProperty(I,'text-decoration','underline',e)} }
							
							]
						}
					}
				]
			}

			var toolbarData={
				
				items: [
					{ icon:"new", overicon:"new_over", onclick:function(){wp.htmleditor.openDialog("new",I)} },
					{ icon:"open", overicon:"open_over", onclick:function(){wp.htmleditor.openDialog('open',I)} },
					{ icon:"save", overicon:"save_over", onclick:function(){wp.htmleditor.setProperty('save',I)} },
					{ icon:"table", overicon:"table_over", onclick:function(){wp.debug.objects(wp.childrenFromSelection(a.contentWindow))} },

					{ icon:"fontWeight", overicon:"fontWeight_over", onclick:function(e){wp.htmleditor.setProperty(I,'font-weight','bold',e)} },
					{ icon:"fontStyle", overicon:"fontStyle_over", onclick:function(e){wp.htmleditor.setProperty(I,'font-style','italic',e)} },
					{ icon:"textDecoration", overicon:"textDecoration_over", onclick:function(e){wp.htmleditor.setProperty(I,'text-decoration','underline',e)} },
					{ icon:"strikethrough", overicon:"strikethrough_over", onclick:function(e){wp.htmleditor.setProperty(I,'strikethrough','strikethrough',e)} },
					
					{ icon:"orderedlist", overicon:"orderedlist_over", onclick:function(e){document.execCommand('insertorderedlist',false,null)} },
					{ icon:"unorderedlist", overicon:"unorderedlist_over", onclick:function(e){document.execCommand('insertunorderedlist',false,null)} },
					{ icon:"outdent", overicon:"outdent_over", onclick:function(){document.execCommand('outdent',false,null)} },
					{ icon:"indent", overicon:"indent_over", onclick:function(){document.execCommand('indent',false,null)} },
					{ icon:"justifyleft", overicon:"justifyleft_over", onclick:function(){document.execCommand('justifyleft',false,null)} },
					{ icon:"justifycenter", overicon:"justifyleft_over", onclick:function(){document.execCommand('justifycenter',false,null)} },
					{ icon:"justifyright", overicon:"justifyright_over", onclick:function(){document.execCommand('justifyright',false,null)} },
					{ icon:"justifyfull", overicon:"justifyfull_over", onclick:function(){document.execCommand('justifyfull',false,null)} },
					{ icon:"increasefontsize", overicon:"increasefontsize_over", onclick:function(){document.execCommand('increasefontsize',false,null)} },
					{ icon:"decreasefontsize", overicon:"decreasefontsize_over", onclick:function(){document.execCommand('decreasefontsize',false,null)} },
					{ icon:"undo", overicon:"undo_over", onclick:function(){wp.editor.setProperty('undo',I)} },
					{ icon:"redo", overicon:"redo_over", onclick:function(){wp.editor.setProperty('redo',I)} },
					{ icon:"link", overicon:"link_over", onclick:function(){wp.editor.setProperty('link',I)} },
					{ icon:"table", overicon:"table_over", onclick:function(){wp.editor.setProperty('table',I)} },
					
					{ icon:"code", overicon:"code_over", onclick:function(e){
						alert(cont.innerHTML)

					}
						
						
						 },
					
					
					/*
					{ icon:"fontWeight", overicon:"fontWeight_over", onclick:function(e){
						
						if(wp.msie){
							cont.focus()
						}
						
						
						wp.pasteHTML("<span style='font-weight:bold;font-style:italic'>AAAAA</span>")
						if(!wp.webkit)wp.edCont.focus()
					}},	
					*/

					{ text:"HTML", onclick:function(e){
						alert(cont.innerHTML)

					}}
					
				]
			}

			

			var newWin=wp.window.create(
			{
				title:"Webplugs HTML Editor"
				,status:"Web HTML Editing Made Easy"
				,height:300
				,width:600
				,id:I.id+"__wpEd"
				,menu:bMainMenu
				//,contentCSS:"padding:100px;border:3px solid green;font-size:20px;;"
				,toolbar:toolbarData
				,onload:function(e){
					wp(e).setAlignment("center;middle")
				}
				,onresize:function(e){
					//wp.webplugseditor.tidy(e)
				}
				,content:I.innerHTML
				,theme:o.theme
			});
			
			var tb=wp.getPlugs("toolbar",newWin)[0]
			var edPath=wp.addNode(tb.parentNode,"div",0)
			edPath.innerHTML="Path:"
			edPath.className="wpHtmlEdPath"
			
			
			newWin.className+=" wp"+o.theme+"HTMLEditor"
			
			
			var HD=wp.addNode(tb.parentNode.parentNode,"div",0)
			HD.className="wpHtmlEdHighlighter"
			//HD.style.position="absolute"
			//HD.style.top=0
			//HD.style.left=0
			//HD.style.border="2px solid #3789ef";
			//HD.style.MozBorderRadius="5px"
			//HD.style.WebkitBorderRadius="5px"
			
			
			

			//wp.addNode(edPath,"click",function(e){
//				alert(e)
			//})
				//},1000)
			

//alert(wp.seek("+span",wp.get("__wpWebplugsHtmlEd")).length)

//wp.each(wp.seek("+span",wp.get("__wpWebplugsHtmlEd")),function(a,i){
//	a[i].onmouseover=function(){alert(99)}
	//wp.addEvent(a[i],"mouseover",function(e){
//		alert(e)
//	})
//}
//)


			var cont=wp.seek(".wpWinContent",newWin)[0]
			cont.contentEditable=true
			//document.designMode="On"
			wp.edCont=cont
			wp.addEvent(cont,"click",function(e){
				return
				var E=wp.getE(e)
				wp.edCont=E
			})
/*
			wp.addEvent(cont,"mouseup",function(e){
				return
				var E=wp.getE(e)
				wp.edCont=E
				wp.edSel=wp.getSelection(self)
				wp.htmleditor.setPath(edPath,HD)
				wp.htmleditor.activateButtons(I,E)
				
			})
*/
			wp.addEvent(cont,"mousedown",function(e){
				//var E=wp.getE(e)
				//wp.edCont=E
				//wp.edSel=wp.getSelection(self)
				//wp.htmleditor.setPath(edPath,HD)
				//wp.htmleditor.activateButtons(I,E)
			})


			wp.addEvent(cont,"keyup",function(e){
				
				var E=wp.getE(e)
				wp.edCont=E
				
				wp.edSel=wp.getSelection()
				
				//document.title=wp.edSel.range.commonAncestorContainer.parentNode.tagName
				//wp.debug.objects(wp.edSel)
				wp.htmleditor.setPath(edPath,HD)
				
				//wp.htmleditor.setPath(edPath,HD)
				wp.htmleditor.activateButtons(I,E)
			})

			wp.addEvent(cont,"keydown",function(e){
				return
				var E=wp.getE(e)
				wp.edCont=E
				
				wp.edSel=wp.getSelection()
				//document.title=wp.edSel.range.commonAncestorContainer.parentNode.tagName
				//wp.debug.objects(wp.edSel.range)
				wp.htmleditor.setPath(edPath,HD)
				wp.htmleditor.activateButtons(I,E)
			})

wp.addEvent(cont,'mousemove',function(e){
	//var dte=new Date()
	//var E=wp.getE(e);
	//document.title=E.tagName
	//wp.htmleditor.setPath(edPath,HD)
})


			wp.addEvent(cont,'mouseup',function(e){
				//return
				var D=window,sT,r,pos,E=wp.getE(e);
				wp.edCont=E
				wp.edSel=wp.getSelection()
				wp.htmleditor.setPath(edPath,HD)
				wp.htmleditor.activateButtons(I,E)


				if(window.opera)return // Opera almost works the way we want so nothing is needed for Opera browser
				
				if(wp.msie){
					r=document.selection.createRange();
					if(r.text && r.text.substr(r.text.length-1,1)==" "){
						r.moveStart("character" ,0);
						r.moveEnd("character" ,-1);
						r.select();
						//if(E.innerText==r.text)wp.editor.CSELECTEDITEM=E
						//if(wp.msie)D.r=r; // Ensure that IE6 issue with losing focus is corrected for double click trimming
					}
				}
				else{
					var
					o=D.getSelection(),
					n=o.anchorNode,
					sel=o.toString(),
					sS=o.anchorOffset,
					sE=o.focusOffset,
					fox=o.selectionLanguageChange
					
					if(wp.trim(E.textContent)==wp.trim(sel)){ // range selected is an element so just highlight the element and return
						o.collapse(E,0); // This bit fixes a problem with Firefox not removing all of the range when highlighting an object
						wp.selectNodeContents(E,window);
						//wp.editor.CSELECTEDITEM=E
						
						//alert(E)
						
						return;
					}
					
					//if(sE<1&&fox){ // Object is last child before sibling, causes problems with Firefox
						// Only Firefox has issues with this
						//o.collapseToStart();
						//o.extend(n,sS+sel.length-1);
					//}

					else if(sel[sel.length-1]==" "){ // Only chop last char if it's a space
						if(fox){ // This is for Firefox only
							//if(sS>sE)
							
							if(sel.indexOf(" ")!=(sel.length-1)&&((sS>sE) && sE!=1)){
								//o.collapseToStart();
								//o.extend(n,sE+sel.length-1);
								//alert(sel.indexOf(" ") + " - " + (sel.length-1) +" - " +sS + " - " + sE)
							}
							else{
								o.extend(o.focusNode,sE+-1);
							}
						}
						else{ // Will probably be just Webkit that reaches this point
							o.collapseToStart();
							o.extend(n,sS+sel.length-1);
						}
					}
				}
				wp.edSel=wp.getSelection()
			})


			
			
			
			
		})
	},
	htmleditor:{
		exec:function(v,o)
		{
			wp(v).htmleditable(o);
		},
		setPath:function(path,HD)
		{
			var ar=[],E=wp.getSelection()
			path.innerHTML="Path:"
			O=E.element
			path.selObj=null
			if(E.nodes.length>1)return
			
			//document.title=E.nodes.length
			//alert(O.tagName)
			

			while(O&&O.nodeName!="HTML"){
				if(O.tagName)ar.push(O)
				O=O.parentNode
				if(O&&O.className=="wpWinContent"){
					C=O
					O=null // we found a container window
				}
			}
			
			for(x=ar.length;x>0;x--){
				nn=wp.addNode(path,"a")
				nn.href="#"
				nn.obj=ar[x-1]
				nn.onmouseover=function(e){
					var P=wp.getPosition(this.obj,C);
					var D=wp.getDimension(this.obj);
					var S=wp.getScrolling(C);
					wp(HD).setPosition({top:P.top,left:P.left}).setDimension({height:D.height,width:D.width})
					wp.show(HD)
					return false;
				}

path.selObj=ar[x-1]

				nn.onmouseout=function(e){
					wp.hide(HD)
				}
				nn.innerHTML=ar[x-1].tagName
			}
		},
		setHighlight:function(e){
	
		},
		activateButtons:function(I,E)
		{
			
			var tb=wp.get(I.id+"htmlEdtoolbar");
			
//alert()
			
			wp(wp.seek(".textDecoration",tb)).delCSSName("selectedItem")
			wp(wp.seek(".fontWeight",tb)).delCSSName("selectedItem")
			wp(wp.seek(".fontStyle",tb)).delCSSName("selectedItem")
			
			
			//alert(wp.css.get(E,"font-weight"))

			if(wp.css.get(E,"text-decoration")=="underline")wp(wp.seek(".textDecoration",tb)).addCSSName("selectedItem")
			if(wp.css.get(E,"font-weight")=="bold"||wp.css.get(E,"font-weight")=="700")wp(wp.seek(".fontWeight",tb)).addCSSName("selectedItem")
			if(wp.css.get(E,"font-style")=="italic")wp(wp.seek(".fontStyle",tb)).addCSSName("selectedItem")

		},
	
		setProperty:function(i,s,v,e){

			if(wp.msie<7){ // Sets focus back to selection for < IE6 - all others are fine
				wp.edSel.range.select();
			}
		
			try{document.execCommand("styleWithCSS",0,false)}
			catch(e){
				try{document.execCommand("useCSS",0,true)}
				catch(e){
					try{document.execCommand('styleWithCSS', false, false)}
					catch(e){}
				}
			}



		var OO=wp.seek(".wpHtmlEdPath",i.parentNode)[0].selObj

//setProperty(I,'font-weight','bold',e)} },
//wp.debug.objects(i)

		if(OO){
			if(s=="font-weight"){
			
				if(OO.style['fontWeight']=="bold" || OO.style['fontWeight']==700)
					OO.style['fontWeight']=""
				else
					OO.style['fontWeight']="bold"
				
			}
			if(s=="font-style")OO.style['fontStyle']="italic"
			if(s=="text-decoration")OO.style['textDecoration']="underline"
			//OO.style[]
		}
		else{
			
			document.execCommand(v, false, true);
		}
			
			/*
			wp.debug.objects(wp.edSel)
			newNode=document.createElement("span");
			if(v=="bold")newNode.style.fontWeight="bold";
			if(v=="italic")newNode.style.fontStyle="italic";
			if(v=="underline")newNode.style.textDecoration="underline";
			wp.edSel.range.surroundContents(newNode)
			wp.selectNode(newNode)
			*/
			//wp.edCont.focus()
			
			
			//wp.pasteHTML("--"+wp.edSel.html+"--",self)
			
			
			//alert(wp.edSel.html)
			
			

		}
	}
})