/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: location.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs URL manipulation and querying module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.extend({
	location:
	{
		parse:function(S)
		{
			var A=["uri","proto","route","domain","portnumber","relative","path","directory","file","query","anchor"],
			m=/(?:([^:\/?#]+):)?(?:\/\/((?:@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(S),
			O={},
			x=0;
			while(x<A.length){
				O[A[x]]=m[x]||"";
				x++
			}
			O.N=(O.domain==window.location.host)
			O.trueRelative=O.N?O.relative:O.uri
			O['extension']=O['file'].split(".").pop()
			return O;
		},
		update:function(L)
		{
			var ob=wp.location.parse(L.href);
			wp.each(ob,function(a,i){
				if(i=="anchor")a[i]="#"+a[i]
				L[i]=a[i]
			},true)
		},
		match:function(v,M)
		{
			var L=v.getElementsByTagName("A"),O=[];
			if(!M)M=location.href
			wp.each(L,function(a,i){
				if(a[i]==M){
					O.push(a[i])
				}
			})
			if(O.length==0)O=null;
			return O;
		},
		getExternals:function(v)
		{
			if(!v)v=document
			var L=v.getElementsByTagName("A"),P=this.parse(location.href),R=[],C=P.proto+"://" + P.domain;
			wp.each(L,function(a,i){
				if(a[i]&&C!=a[i].href.substr(0,C.length)){
					if(a[i].href)R.push(a[i]);
				}
			})
			return R;
		},
		isHash:function(v)
		{
			if(v&&v.href){
				var S=v.href
				if(v.href.substr(v.href.length-1,1)=="#")return true;
			}
			return false
		}
	}
})
wp.location.update(window.location)
