/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: menu.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: Milonic Shared Source License
	    Details: For building dynamic menus from HTML Markup or JSON
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

//alert(98)
wp.dependencies("collision,corner,css,effect,imask,location,position,shadow,string");

//wp.zi=100;
//wp.opendelay=80;
//wp.closedelay=360;
//wp.builderHost="http://webplugs.dev"

//mand=""

/*
menu types:
	context
	dropdown
	flyout
	popup
	
Default is always flyout (vertical)


properties:
	data
	type
	opendelay
	closedelay
	effects
	mainButtons
	shadow
	theme
	openonclick
	closeonclick
	keepalive


events	
	oncomplete
	onmenubuild
	onmenuopen
	onmenuclose

*/

wp.extend(
{		
	menuable:function(o)
	{
		//wp.menu.v=this.v
		o=wp.bob(o)
		
		wp.each(this.v,function(a,i){
			var I=a[i];
			if(I.webplug)return;
			if(o.data){
				for(var a in o.data)o[a]=o.data[a];
				wp.menu.initJSONMenus(o.data,o,I);
			}

			I=wp.sObj(I,o,"menu");
			
			if(o.type!="toolbar" && o.closeonclick===undefined)o.closeonclick=1;
			
			if(o.openonhover===undefined)o.openonhover=1
			if(o.openonclick===undefined)o.openonclick=1
			
			if(!o.opendelay)o.opendelay=80;
			if(!o.closedelay)o.closedelay=350;
			if(!o.keepalive)o.keepalive=0;
			//if(!o.horizDelay)o.horizDelay=0;
			if(!o.type)o.type="menu";
			I.type=o.type;
			
			if(o.theme){
				if(o.type=="toolbar"){
					I.webplug="toolbar"
					wp.css.add(o,"toolbar");
					I.className+=" wp"+o.theme+wp.ucfirst(o.type);
				}
				else{		
					wp.css.add(o,"menu");
					I.className+=" wp"+o.theme+"Menu"
				}
			} else if(o.styleSheet){
				wp.css.add(o,"menu");
			}
			if(o.css)wp(I).strCSS(o.css);
			
			if(wp.rT(o.highlightMatchingLinks)){
				wp.each(wp.location.match(I),function(a,i){
					if(a[i]&&a[i]!=""&&!wp.location.isHash(a[i])){
						
						
						//alert(wp.location.isHash(a[i]))
						
						wp(a[i]).addCSSName("pageMatch");
						var L=a[i].parentNode;		
						while(L&&L.webplug!="menu"){
							if(L.childNodes[0].tagName=="A"){ // MAY NEED TO CHANGE  .tagname=A TO .thisMenu
								wp(L.childNodes[0]).addCSSName("pageMatch");
							}
							L=L.parentNode;
						}
					}
				})
			}
			
			wp.menu.makeMenu(I);
	
			var fPNG=function(I)
			{
				setTimeout(function(){
					if(wp.msie<7&&wp.rT(o.pngFix)){
						var micon=wp.seek(".menuIcon",I);
						wp.each(micon,function(a,i){
							wp(a[i]).iePngFix()
						})
					}
				},10)
			}
	
			if(wp.docState=="complete")fPNG(I); else{
				wp.onload(function(){
					fPNG(I)
				})	
			}

			
			wp.show(I);
		})

		return this;
	},
	menu:
	{
		exec:function(v,o)
		{
			wp(v).menuable(o);
		},
		openByURL:function(url,mnu,I)
		{		
			wp.each(wp.seek(".pageMatch",mnu),function(a,i){
				if(a[i].tagName=="A"){
					I.autoOpened.push(a[i]);
					a[i].autoOpened=a[i];
					wp.execEvent(a[i],"mouseover");
					wp.execEvent(a[i],"click");
				}
			})
		},
		extend:function(d){
			for(var i in d)this[i]=d[i]
		},
		getDepth:function(v)
		{
			var count=0;
			while(v){
				if(v.thisMenu){
					v=v.thisMenu
					if(v.parentItem){
						v=v.parentItem.childNodes[0];
						count++;
					}
				}
				v=v.parentNode
			}
			return count
		},
		getItem:function(E)
		{
			E=wp.getE(E);
			if(!E.subMenu){
				var TSub,tE=E.getElementsByTagName("*"),T;
				for(T in tE){
					if(tE[T].subMenu)TSub=tE[T].subMenu
				}
			}
			if(!E.thisMenu){while(E&&E.tagName!="A")E=E.parentNode}
			if(E&&!E.subMenu)E.subMenu=TSub;
			return E;
		},
		display:function(E,I)
		{
			E=wp.menu.getItem(E);
			clearTimeout(I.SM);
			//if(wp.matchCSS(E,"wpAjax")>=0){
			if(E.target=="_wpAJAX"){
				if(!E.subMenu) // if menu is already found we do not bother loading ajax
					wp(E).download({
						url:E.href,
						onload:function(t){
							var II=I.getElementsByTagName("ul")[0];
							var subMenu=wp.addNode(II,"ul");
							subMenu.innerHTML=t;
							wp.menu.makeMenu(I,subMenu,E);
							wp.execEvent(E,"mouseover")
							if(wp.matchCSS(E,"activeItem")>-1)wp.menu.display(E,I);
							return
						}
					})
				E.href="#"
			}
			
			var M=E.thisMenu,v=E.subMenu;
			
			//if(!v && M)M.activeItem=E;
			
			wp.menu.close(M,1)
			if(v){
				//v.openMethod=om
				v.webplug="menu"
				
				//wp(E.parentNode).addCSSName("activeItem");
				v.parentItem=E;
				M.activeItem=E;
				var horiz=/hMenu/.test(M.className),S=v.style,sT=0,sL=0,T
				
				if(horiz){
					wp(E.subMenu).addCSSName("wpHorizontalParent");
					if(M.mainMenu){
						sL=E.offsetLeft;
						sT=E.offsetTop+E.offsetHeight;
						//if(wp.msie==7)sL-=13
					}
					else{
						sT=E.offsetHeight+(E.offsetTop+M.offsetTop)-M.scrollTop;
						sL=E.offsetLeft+M.offsetLeft;
					}
					/*
					var T=parseInt(wp.css.get(E.thisMenu,"padding-left"));
					if(!isNaN(T))sL=sL+(T*2);
					
					var T=parseInt(wp.css.get(E.thisMenu,"padding-top"));
					if(!isNaN(T))sT=sT+(T*2);
					*/

					var T=parseInt(wp.css.get(E.thisMenu,"padding-left"));
					if(!isNaN(T))sL=sL+T;
					
					var T=parseInt(wp.css.get(E.thisMenu,"left"));
					if(!isNaN(T))sL=sL+T;
					
					var T=parseInt(wp.css.get(E.thisMenu,"padding-top"));
					if(!isNaN(T))sT=sT+T;
				}
				else{
					wp(E.subMenu).addCSSName("wpVerticalParent");
					sT=(E.offsetTop+M.offsetTop)-M.scrollTop;
					sL=(E.offsetWidth+E.offsetLeft+M.offsetLeft);
					sT=sT-E.parentNode.parentNode.scrollTop;
				}

				var AAP=wp.seek(".wpCornRel",v);
				if(AAP&&AAP[2].offsetHeight&&AAP[2].scrollHeight>AAP[2].offsetHeight)E.subMenu.hasVScrollBar=1;
				if(M.hasVScrollBar)sL=sL+18;
				var E2=E.parentNode.parentNode.parentNode;
				
				if(!isNaN(M.bw)&&!M.hasCorners){
					sT+=M.bw;
					sL+=M.bw;
				}
				
				
				//wp.debug.objects(E)
				
				
				//var Thoriz=/hMenu/.test(E.thisMenu.className)
				
				//if(horiz)
//					wp(E.subMenu).addCSSName("wpHorizontalParent");
				//else
//					wp(E.subMenu).addCSSName("wpVerticalParent");
					
				
				
				
				sT++ //  Shift the menu down by 1 pixel - adds a nice gap between parent item and sub menu - SHOULD PROBALY USE CSS FOR THIS
				var doColl="";
				if(v.menuData.style.left){
					sL=parseInt(v.menuData.style.left); // This sets a menus left position - add 'left:10px;' to UL's style
					doColl="l";
				}
				if(v.menuData.style.top){
					sT=parseInt(v.menuData.style.top); // This sets a menus top position - add 'top:10px;' to UL's style
					doColl="r";
				}

				//sT+=wp.css.pInt(v.menuData,"margin-top");// This sets a menus top offset - add 'margin-top=-2px;' to UL's style
				//sL+=wp.css.pInt(v.menuData,"margin-left");// This sets a menus left offset - add 'margin-left=-100px;' to UL's style



				S.top=wp.px(sT);
				S.left=wp.px(sL);
				
				//alert(123)
				M.master.style.zIndex=999;
				if(I.wpObject.openEffect){
					
					
					//if(v.fx && v.fx.count==0)alert(v.fx.count)
					
					//document.title+="2"
					I.wpObject.openEffect(v);
					//alert(v.fx.count + " - " + v.fx.status)
					v.fx.oncomplete=function(){
						v.style.display="none"
						if(v.master.openSubs<1)v.master.style.zIndex=1
						v.master.commitAction=0
					}

					v.fx.onbegin=function(){
						v.style.display="block"
					}


					//wp.debug.objects(v.fx)
				}
				else{
					v.style.display="block";
				}
				M.master.inOpenMode=1;
				if(!I.wpObject.disableCollisions)wp(v).checkCollision(doColl);
				
				v.style.visibility="visible";
				v.mD=new Date()
//				wp.imask.create(v);
				if(I.wpObject.onmenuopen)I.wpObject.onmenuopen(v);
			}

			var S=wp.menu.getDepth(E)
			if(E.subMenu)S++
			M.master.openSubs=S
				//document.title="on:  "+S+" - " + E.innerHTML


		},
		itemOn:function(E,I)
		{
			E=wp.menu.getItem(E)
			if(E.thisMenu && E.thisMenu.parentItem)clearTimeout(E.thisMenu.parentItem.outT)

			clearTimeout(I.MP);
			clearTimeout(I.SM);

			//wp.editMode=1 // Use editmode for editing menus with proper editor 
			
			/* 
				This bit is needed when elements are added to the text node of links as in when using buttonable to make top items become buttons
				Somehow the event returns the added element instead of the link itself and the 'thisMenu' and 'subMenu' variables get messed up in the process, need to move change the events element
			*/			
			
			
			if(!E.thisMenu||E.thisMenu.master.commitAction)return;
			var M=E.thisMenu,v=E.subMenu;


			


								/* Added for Eliteemail.com */
								if(M.parentItem&&M.parentItem.wpButton)wp.button.on(M.parentItem)
								if(M.activeItem&&M.activeItem.wpButton){
									if(v!=M.activeItem.subMenu)wp.button.off(M.activeItem)
								}
								/* Added for Eliteemail.com */


			//alert(E.innerHTML)
			
			var pi=v?E.parentNode:E;
			var C=E.parentNode.className.split(" ")[0]
						
			if(wp.msie<7 && C!="menuItem"){ // Fixes .classname.classname bug in IE6
				var re=new RegExp("."+E.thisMenu.master.className+" .activeItem {","g"),re2=new RegExp(C+":hover {","g"),newCls=C+"-activeItem",dS,W
				for(var W=0;W<document.styleSheets.length;W++){
					dS=document.styleSheets[W]
					if(dS.cssText){
						dS.cssText=dS.cssText.replace(re,"");
						dS.cssText=dS.cssText.replace(re2,newCls+" {");
						wp(pi).addCSSName(newCls)
						pi.ie6cnf=newCls
						//alert(pi.className)
					}
				}
			}
			else{
				wp(pi).addCSSName("activeItem");
			}
			
			
			if(pi!=M.lastItem)wp(M.lastItem).delCSSName("activeItem");
			
			if(pi.ie6cnf)wp(M.lastItem).delCSSName(pi.ie6cnf);
			
			M.lastItem=pi
			
			if(M&&M.parentItem){
				wp(M.parentItem.thisMenu.lastItem).delCSSName("activeItem");
				wp(M.parentItem.parentNode).addCSSName("activeItem");
				M.parentItem.thisMenu.lastItem=M.parentItem.parentNode
				
				
				
				
				//M.lastItem=pi
			}
			
			
/*			
			if(v){
				wp(E.parentNode).addCSSName("activeItem");
				if(E.parentNode!=M.lastItem)wp(M.lastItem).delCSSName("activeItem");
				M.lastItem=E.parentNode
				
			}
			else{
				wp(E).addCSSName("activeItem");
				if(E!=M.lastItem)wp(M.lastItem).delCSSName("activeItem");
				M.lastItem=E
			}
			
	*/		
			
			
			
			
			if(wp.msie<9)E.style.filter="" // Fixes a bug in IE8 where Hover and Alpha filter is broken
			
			//if(M&&M.parentItem)wp(M.parentItem.parentNode).addCSSName("activeItem");
			if(!E.autoOpened&&v&&v.style.display=="block"){
				if(v.fx){
					if(v.fx.status==4)return
				}
				else{
					return
				}
			}
			//if(M&&M.activeItem)wp(M.activeItem.parentNode).delCSSName("activeItem")
			//if(v&&v.activeItem)wp(v.activeItem.parentNode).delCSSName("activeItem")

			if(wp.msie<8&&E.offsetHeight<E.parentNode.offsetHeight){ // This bit fixes a bug in IE6 and IE7 where last menu item (that has a sub menu) spills items background image over the items border
				if(E.subMenu)E.parentNode.style.height=E.offsetHeight+"px"
			}			

//			if(I.wpObject.openonclick>wp.menu.getDepth(E)){
				//if(I.inOpenMode){
//					wp.menu.display(E,I)
				//}
			//}
			
			//else{
			
			SHOW=1;
			if(I.wpObject.openonclick)SHOW=0
			if(I.wpObject.openonhover)SHOW=1
			if(M.master.inOpenMode)SHOW=1
			//wp.debug.objects(M)
			//document.title=M.master.inOpenMode
				
			
				var horiz=/hMenu/.test(E.thisMenu.className);
				var OD=I.wpObject.opendelay
				//wp.debug.objects(E)
				//alert(E.thisMenu)
				if(horiz&&I.inOpenMode&&!I.wpObject.disableSmartDelay){
					OD=20
				}
				
				//
			//alert(SHOW)	
				
			if(SHOW){
				if(E.thisMenu.parentItem){
					if(E.thisMenu.fx&&E.thisMenu.fx.status==2){
						
						wp.execEvent(E.thisMenu.parentItem,"mouseover")
					}
				}
				I.SM=setTimeout(function(){

					wp.menu.display(E,I)
				},OD)	
			}				
				
				
			//}
		},
		itemOff:function(i)
		{
		},
		hide:function(v,f)
		{
			if(v){
				var o=v.wpObject
				if(v.master.type=="context")v=v.master;
				if(v.style.display!="none"){
					if(o.onmenuclose)o.onmenuclose(v)
					if(o.closeEffect&&!f){
						
	//					alert(o.closeEffect)
						//document.title+="1"
						o.closeEffect(v.parentItem.subMenu);
						

//alert("")
/*
window.onload = (function (old) {
    return function () {
        if (typeof old == 'function')    old();
        // Run new code here...
    };
})(window.onload);
*/

						
						
						
					}
					else{
						v.style.display="none";
						wp.imask.hide(v);
					}
					if(v.lastItem)wp(v.lastItem).delCSSName("activeItem");
				}
			
			}
		},
		closeAll:function(I,F){
			var M

			if(!I.mainMenu){
				while(!I.mainMenu&&I.parentNode)I=I.parentNode
				F=true
			}
				
			M=I.mainMenu
			if(M.activeItem){
					/* Added for Eliteemail.com */
					if(M.activeItem&&M.activeItem.wpButton){
						wp.button.off(M.activeItem)
					}
					/* Added for Eliteemail.com */
				}
				
				wp(M.lastItem).delCSSName("activeItem");
				
				wp.menu.close(M,F);
				M.activeItem=null
				I.inOpenMode=0;
				
				if(!I.wpObject.closeEffect)M.master.style.zIndex=1;
				if(I.autoOpened){
					for(var a=0;a<I.autoOpened.length;a++){
						wp.menu.itemOn(I.autoOpened[a],I)
					}
				}
			
		},		
		close:function(I,force)
		{
			var aI=I,cnt,cls

			while(aI&&aI.activeItem){
				cnt=wp.menu.getDepth(aI.activeItem)+1
				cls=1
				
				if(aI.wpObject.keepalive>cnt){
					//if(aI.activeItem.subMenu.openMethod=="click")cls=0;
					cls=0;
				}
				if(force)cls=1;

				if(cls){
					if(aI.activeItem.subMenu&&!aI.activeItem.autoOpened){
						//alert(88)
						I.master.openSubs--
						wp.menu.hide(aI.activeItem.subMenu)
					}
				}
				aI=aI.activeItem.subMenu;
				cnt++
			}
		},
		initJSONMenus:function(t,o,I){
			
			var menus,items,Q,II,MENU,ITEM,LINK,ICON,cnt=0;
			for(menus in t){
				if(typeof(t[menus])=="object" && t[menus].length){
					MENU=wp.addNode(I,"ul");
					
					if(o.orientation=="horizontal"&&!o.mainMenu){
						wp(MENU).addCSSName("hMenu")
						o.mainMenu=1
					}
					
					for(items in t[menus]){
						if(typeof(t[menus][items])=="object"){
						
					//		alert(typeof(t[menus][items]) +" - " + t[menus][items].)
							
							ITEM=wp.addNode(MENU,"li");
							LINK=wp.addNode(ITEM,"a");
							var itemProps=(eval(t[menus][items]))
							LINK.itemProps=itemProps; // Ensure that the events are passed correctly
							for(II in itemProps){
								
								
								
								
								var icon=""
								if(itemProps['icon']){
										ICON=wp.addNode(LINK,"span");
										ICON.className="menuIcon "+itemProps['icon']
									itemProps['icon']=null
								}
									
								if(II=="text"){
									var icon=""
	
									LINK.innerHTML=LINK.innerHTML+itemProps[II];
								}
								else{
									//alert(II)
									if(II!="icon" && II!="overicon")LINK[II]=itemProps[II]
								}
							}
							if(t[menus][items] && t[menus][items].submenu){
								wp.menu.initJSONMenus(eval(t[menus][items].submenu),o,ITEM)
							}
						}
					}
				}
				cnt++
			}
		},


		initMenuEvents:function(M,I)
		{
			wp.addEvent(M,'mouseover',function(e){
				clearTimeout(I.MP)
				//clearTimeout(I.MMMM)
				
			})

			wp.addEvent(M,'mouseout',function(e){ 
				clearTimeout(I.MP);
				clearTimeout(I.SM);
				if(I.wpObject.keepalive)return
				var E=wp.getE(e);

				if(!E.subMenu){
					wp(E.parentNode).delCSSName("activeItem");
				}
				//wp(wp.previousItem).delCSSName("activeItem");


				I.MP=setTimeout(function(){
					if(I.mainMenu.activeItem){
						
						wp.menu.closeAll(I)
						//wp(I.mainMenu.activeItem.parentNode).delCSSName("activeItem");
						
/*

							if(I.mainMenu.activeItem&&I.mainMenu.activeItem.wpButton){
								wp.button.off(I.mainMenu.activeItem)
							}


						}
						
						wp(I.mainMenu.lastItem).delCSSName("activeItem");
						
						//wp(wp.previousItem).delCSSName("activeItem");
						wp.menu.close(I.mainMenu);
						
						I.inOpenMode=0;
						
						if(!I.wpObject.closeEffect)M.master.style.zIndex=1;
						
						//if(E.subMenu)wp.debug.objects(E)
						
						
						
						//alert(E.subMenu.fx.status)
						//wp.debug.objects(M.activeItem.subMenu)
						//alert(M.activeItem.subMenu.fx.status)
						
						if(I.autoOpened){
							for(var a=0;a<I.autoOpened.length;a++){
								wp.menu.itemOn(I.autoOpened[a],I)
							}
							*/
						}
						
					},I.wpObject.closedelay)
			})
		},
		initItemEvents:function(I,parentItem,subMenu){
			
			wp.addEvent(parentItem.childNodes[0],"click",function(e){
				var E=wp.getE(e);
				
				//if(E.tagName=="INPUT" && E.type!="submit")wp.cancelEvent(e);
				
									/* Added for Eliteemail.com */
									if(wp.menu.gItem(E).subMenu){
										wp(wp.menu.gItem(E).subMenu).addCSSName("wpMenuActive")
									}
									/* Added for Eliteemail.com */
				
				
				//I.inOpenMode=1;
				
				//alert(wp.menu.gItem(E).thisMenu)
				
				//alert(wp.menu.gItem(E).subMenu.style.display)
				//if(I.wpObject.closeonclick&&wp.menu.gItem(E).subMenu.style.display=="block"){
					
//					wp.menu.hide(wp.menu.gItem(E).subMenu,0)
					//I.inOpenMode=0
				//}else{
				//alert(wp.menu.gItem(E).subMenu.style.display)
				//	alert(E.subMenu.style.display)
				
					//alert(wp.css.get(E.subMenu,"visibility"))
					//alert(wp.css.get(E.subMenu,"display"))
					
					//alert(E.subMenu.innerHTML)
					
				//wp.debug.objects(E)
					//if(wp.css.get(E.subMenu,"display")!="block")
					//alert(wp.css.get(E.subMenu,"visibility"))

					//if(E.subMenu&&I.mainMenu.wpObject.closeonclick){
//						if(wp.css.get(E.subMenu,"visibility")=="visible" && wp.css.get(E.subMenu,"display")=="block"){
//							
						//}
					//}

					if(E.subMenu){
						if(wp.css.get(E.subMenu,"visibility")!="visible" || wp.css.get(E.subMenu,"display")!="block"){
							if(I.mainMenu.wpObject.openonclick)wp.menu.display(E,I)
						}
						else{
							if((!E.subMenu.fx || E.subMenu.fx.status==4) && I.wpObject.closeonclick){
								//alert(+" - " + E)
								//wp.debug.objects(E.thisMenu)
								
								//alert(/hMenu/.test(E.thisMenu.className))
								
								
								//alert(/hMenu/.test(E.thisMenu.className))
								
								
								if((new Date()-E.subMenu.mD)<300 || !(/hMenu/.test(E.thisMenu.className)))return
								wp.menu.hide(E.subMenu,0)
								I.inOpenMode=0
							}
						}
					}
					else{
						if(!E.keepalive){
							if(!E.returnFalse)wp.menu.closeAll(I,1)
							//alert(I.returnFalse)
							
						}
					}
			})
			
			wp.addEvent(parentItem.childNodes[0],'mouseover',function(e){ 
				
				

				
				
				if(subMenu&&!subMenu.built)wp.menu.makeMenu(I,subMenu,e);
				var E=wp.getE(e);
				


					
						wp.each(wp.seek(".menuIcon",E),function(a,i){
							a[i].onmousedown="return false"
						})

						wp.each(wp.seek(".menuIcon",E),function(a,i){
							a[i].onmouseup="return false"
						})



						//wp.each(wp.seek(".menuIcon",E),function(a,i){
							
//							a[i].onclick="return false"
							//a[i].onclick="alert(99)"
						//})




				
				if(E.thisMenu){
					//wp(wp.previousItem).delCSSName("activeItem")
					wp.menu.itemOn(E,I);
					//wp.previousItem=E;
				}
				else{
					wp.menu.itemOn(E.parentNode,I);
					//wp(wp.menu.gItem(E)).addCSSName("activeItem")
				}


			})
			wp.addEvent(parentItem.childNodes[0],'mouseout',function(e){
				var E=wp.getE(e);
				if(E.thisMenu){
					if(!E.subMenu||(E.subMenu&&(wp.css.get(E.subMenu,"display")=="none"||wp.css.get(E.subMenu,"visibility")=="hidden"))){

						wp(E.thisMenu.lastItem).delCSSName("activeItem")
					}
				}
			})
		},
		gItem:function(E)
		{
			while(E){
				if(E.thisMenu)return E
				E=E.parentNode
			}
		},
		DC:function(I,o){
			var H=wp.css.get(I,"height"),G,D,M,R,R2;
			if(o.background)G=o.background;else G=wp.css.get(I,"background-color");
			var D=wp.cloneNode(I);
			D.removeAttribute("id");
			wp.insertNode(D,I,0);
			D.style.width="auto";
			//var B=wp.css.box(I,1),
			var S=I.style;
			
			S.textAlign="";
			S.overflow="visible";
			S.height="auto";
			S.zoom=1;
			
			I.innerHTML=""
			M=wp.addNode(I,"DIV");
			M.className="wpCornRel";
			M.style.overflow="hidden";
			R=wp.addNode(M,"DIV");
			R.className="wpCornRel";
			
			wp.css.box(I,1,R)
			
			//wp.css.xfer(I,R)
			
			
			
			//R.style.paddingTop=B[0];
			//R.style.paddingRight=B[1];
			//R.style.paddingBottom=B[2];
			//R.style.paddingLeft=B[3];
			R2=R.appendChild(D);
			//alert(D.innerHTML)
			R2.className="wpCornRel"
			R2.style.border="";
			R2.roundObj=I;
			if(H)R2.style.height=H;
		},
		confLinks:function(M,o)
		{
			
			wp.each(M.getElementsByTagName("a"),function(a,i){
				if(a[i].tagName=="A"){
					//alert("")
					if(wp.msie==8)a[i].style.position="static" // Fixes a bug in IE8 where child elements are fully visible even though the parent has opacity set
					a[i].thisMenu=M;
					if(!a[i].href)a[i].href="#";
					
					
					wp.addEvent(a[i],"click",function(e){
						//alert(e)
						var S=a[i].href;
						
						//if(!M.mainMenu&&o.closeonclick&&!a[i].subMenu)wp.menu.hide(M,0) //When an item is clicked check to see if closeonclick has been set (on by default) and also check that there are no sub menus
						
//						if(o.closeonclick&&a[i].subMenu){
							//wp.menu.hide(a[i].subMenu,0)
						//}
						
						//wp.debug.objects(M)
						wp.each(wp.seek(".pageMatch",M.master),function(a,i){
							wp(a[i]).delCSSName("pageMatch");
						})
						wp(a[i]).addCSSName("pageMatch");
						
						
						if(S.substr(S.length-1,1)=="#"||a[i].returnFalse){
							//alert(a[i].returnFalse)	
							//if(!M.mainMenu&&o.closeonclick&&!a[i].subMenu)wp.menu.hide(M,0)
							
							wp.cancelEvent(e); // If the link is a hash (must be a dummy link) do not do anything with the click event
						}
						else{
							//alert(M)
							//wp.debug.objects(M)
							if(!M.mainMenu)M.master.commitAction=1
							wp.menu.closeAll(M.master,1)
						}
						//M.master.style.zIndex=1
					})
					
					
					/*
					a[i].parentNode.onclick=function(){
						var S=a[i].href;
						alert(99)
						if(!M.mainMenu&&o.closeonclick&&!a[i].subMenu)wp.menu.hide(M,1) //When an item is clicked check to see if closeonclick has been set (on by default) and also check that there are no sub menus
						if(S.substr(S.length-1,1)=="#"||a[i].returnFalse)return false; // If the link is a hash (must be a dummy link) do not do anything with the click event
						M.master.style.zIndex=1
					}
					*/
				}
			})
		},
		makeMenu:function()
		{
			var A=arguments,b,menu,subMenu,M,D,mClass,isMain,I=A[0],o=I.wpObject,Q6,mi,SA;
			
			var D=document.body
			if(D&&!D.mnuDBC){
				wp.addEvent(D,"click",function(e){
					var AA=wp.getE(e)
					while(AA){
						if(AA.type=="menu")return false;
						AA=AA.parentNode
					}
					
					wp.each(wp.getPlugs("menu"),function(a,i){
						if(a[i].mainMenu)wp.menu.closeAll(a[i],1)
					})
				})
				D.mnuDBC=1
			}
			
			if(A[1]){
				menu=A[1];
				mClass="wpSubMenu";
			}
			else{
				isMain=1;
				menu=I.getElementsByTagName("ul")[0];
				mClass="wpMainMenu";
				if(I.type=="toolbar"||I.type=="horizontal")menu.className="hMenu"
			}
			

			if(!menu){
				alert("Menu Not Found")
				return
			}
			
			//if(o.orientation=="horizontal")menu.className+="hMenu"
			var lST=wp.css.get(menu,"list-style-type");
			
			clearTimeout(menu.LDD)
			
			if(lST!="none"){
				if(!menu.ldd)menu.ldd=10
				menu.ldd++
				//mand=mand+" - "+I.andy + I[1]
				if(I.done)return 
				if(menu.ldd<99)menu.LDD=setTimeout(function(){wp.menu.makeMenu(I)},menu.ldd);
				return
			}
			I.done=1
			var horiz=/hMenu/.test(menu.className);
			
			M=wp.addNode(I,"div"); // Create Menu Container
			M.wpObject=o
			
			M.menuData=menu
				var T=wp.parentPlug(M,"menu")
				//var T=M
				//while(T&&T.webplug!="menu")T=T.parentNode;
				//alert(T)
				
				if(T){
					if(!T.menuCount){
						T.menuCount=1;
						//T.openSubs=0
					}
					else T.menuCount++
				}
				else{
					T=M
				}
			
			M.master=T
			
			if(A[2]){
				var e=A[2];
				var E=wp.getE(e);
				E.subMenu=M;
			}
			wp.menu.initMenuEvents(M,I)

			var S=M.style
			S.float="none";
			S.clear="both";
			
			
			
//			wp.css.box(menu,1,M) // Pass any box css properties to new menu from UL
//alert(wp.css.getInlineStyle(menu))
wp.css.xfer(menu,M)

//alert(M.style.cssText)


//S.padding="20px"

			
			if(wp.css.get(menu,"height")!="auto"){
				M.scrollBar=1
				S.overflow="auto";
				
				S.height=wp.css.get(menu,"height");
//alert(S)
				//wp(M).into("scrollbar",{theme:"Venom"})
			}
			S.width=wp.css.get(menu,"width")
/*
			if(menu.className=="AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAawpMegaMenu"){
				M.className="wpMegaMenu "+mClass
				Q6=menu.getElementsByTagName("LI")[0];
				M.fsM=1;
				M.innerHTML=Q6.innerHTML
				if(o.corners){
					if(!isMain||(isMain&&o.corners.mainMenu))
					wp(M).cornerable(o.corners)
				}

				if(o.shadow){if(!isMain||(isMain&&o.shadow.mainMenu))wp(M).shadowable(o.shadow)}
				
				wp.menu.confLinks(M,o)

				menu.built=true
				if(o.onmenubuild)o.onmenubuild(menu)
				return
			}
*/





			if(isMain){
				I.mainMenu=M;
				if(o.type!="context")M.mainMenu=true
			}
			M.className=menu.className+" "+mClass;
			M.bw=wp.css.pInt(M,"border-top-width")

			for(b in menu.childNodes){
				mi=menu.childNodes[b]
				
				
				
				if(mi.nodeType==1&&mi.tagName && mi.tagName=="LI"){
					
					D=wp.addNode(M,"div"); // Create Menu Item
					if(mi.className)D.className=mi.className
					//D.setAttribute("mmitem","true");
					if(mi.id){
						D.id=mi.id
						mi.removeAttribute("id");
					}
					else{
						D.id="wpMi"+wp.uId++
					}
//alert(mi.tagName)					
					if(mi.childNodes[0].className=="separator"){
						if(horiz)D.className="mainItems"; else D.className="subItems";
					}
					else{
						wp(D).addCSSName("menuItem")
					}
					
					
					Q6=mi.getElementsByTagName("A")[0];
					//alert(Q6.wpEvents)
					//if(Q6){					
//						Q6.pNode=D
						//D.id="id"+wp.uId++
					//}
					
					//D.wpId=wp.uId++
					
					
					if(Q6&&Q6.parentNode&&Q6.parentNode.tagName!="LI")Q6=""
					if(Q6)Q6.wpId=D.id

					//if(!wp.previousItem)wp.previousItem=Q6
					
					
					
					if(Q6 && wp().matchCSS(menu,"wpMegaMenu")<0){
//alert(wp.outerHtml(Q6))
						D.innerHTML=wp.outerHtml(Q6);
						//Q6.pNode=D
						//alert(Q6.pNode.innerHTML)
						
						if(Q6.wpEvents){
							for(var A in Q6.wpEvents){
								wp.addEvent(D.childNodes[0],A.split("_")[0],Q6.wpEvents[A])
							}
							
						}
						



						//if(wp.next(Q6)&&wp.next(Q6).className=="wpTooltip"){
//							var Q7=D.getElementsByTagName("A")[0];
							//Q7.setAttribute("wptooltip",wp.next(Q6).innerHTML);
						//}
						
						
						
						
						if(horiz){
							wp(D).addCSSName("mainItems")
						}
						else{
							wp(D).addCSSName("subItems")
						}
						subMenu=mi.getElementsByTagName("ul")[0];
						
						//if(subMenu||Q6.href.substr(0,5)=="ajax:"){
						if(subMenu||Q6.target=="_wpAJAX"){
							wp(D).addCSSName("parentItem")
							D.parentItem=1
							D.subMenu=subMenu
						}

						wp.menu.initItemEvents(I,D,subMenu);
						
						wp.setEvents(D.childNodes[0],o); // Transfer the events from the menu object
						wp.setEvents(D.childNodes[0],Q6.itemProps); // Ensure that the links itemProperties are added to the new link

						
						if(Q6.id)Q6.removeAttribute("id");
					}
					else{
						//alert(mi.innerHTML)
						wp(D).delCSSName("menuItem")
						//D.className=""
						//alert(D.className)
					//	alert(mi.innerHTML)
						D.innerHTML=mi.innerHTML
					}
					
					
					if(o.separators && wp.next(mi)){
						var DD=wp.addNode(M,"div");
						if(horiz)DD.className="mainItems"; else DD.className="subItems";
						DD=wp.addNode(DD,"span");
						DD.className="separator"
					}
				}
			}


			var m=/wpMenu(.*)Columns(.*)/i.exec(menu.className) //regexp to extract number part and type from wpMenu##Columns
			if(m&&m[1])wp(M).gridable({type:"menu",cols:m[1],orientation:m[2]})

			var m=/wpMenu(.*)Rows(.*)/i.exec(menu.className) //regexp to extract number part and type from wpMenu##Rows
			if(m&&m[1])wp(M).gridable({type:"menu",rows:m[1],orientation:m[2]})


			if(isMain){
				menu.style.display="none";
				if(horiz&&wp.msie<7)S.height=D.offsetHeight+"px"
			}else{
				//if((window.opera||wp.msie==7) && D.offsetWidth){
					//M.style.width=D.offsetWidth+"px"
				//}
			}


			if(wp.msie<7){ // Fixes a problem with IE6 forcing 100% width on separators and fixes main horizontal menu width issue
				if(!horiz){
					Q6=wp.seek(".separator",M)
					if(Q6){
						wp.each(Q6,function(a,i){a[i].style.display="none"})
						var T=M.childNodes[0].offsetWidth+"px"
						wp.each(Q6,function(a,i){
							a[i].style.width=T
							a[i].style.display="block"
						})
					}
				}
			}

			if(o.corners){
				if(!isMain||(isMain&&o.corners.mainMenu))
				wp(M).cornerable(o.corners)
				M.hasCorners=1
			}
			else{
				wp.menu.DC(M,o)
			}

			wp.menu.confLinks(M,o)

			
			//if(!horiz)M.style.width=parseInt(M.offsetWidth)+"px"
			
			var AAP=wp.seek(".wpCornRel",M),R
			if(AAP)R=AAP[2]

/*			
			if(AAP&&R.scrollHeight>R.offsetHeight){

				wp.addEvent(M,'DOMMouseScroll',function(e){ //Firefox Only
					if(e.detail>0&&R.scrollHeight<R.offsetHeight+(R.scrollTop+1))wp.cancelEvent(e);
					if(R.scrollTop==0&&e.detail<0)wp.cancelEvent(e);
				})
				wp.addEvent(M,'mousewheel',function(e){ // Non Firefox
					if(e.wheelDelta<0&&R.scrollHeight<R.offsetHeight+(R.scrollTop+1))wp.cancelEvent(e)
					if(R.scrollTop==0&&e.wheelDelta>0)wp.cancelEvent(e);
				})
				M.style.width=parseInt(M.offsetWidth)+30+"px"
			}
*/
			//if(o.shadow)if(!isMain||(isMain&&o.shadow.mainMenu))wp(M).shadowable(o.shadow);
			
/*
			var S=M.style
			S.float="none";
			S.clear="both";
			if(wp.css.get(menu,"height")!="auto"){
				M.scrollBar=1
				S.overflow="auto";
				S.height=wp.css.get(menu,"height");

			}
			S.width=wp.css.get(menu,"width")
*/

			if(M.scrollBar){
				s=wp.getScrollbarSize()
				S.width=wp.px(M.offsetWidth+s)
			}
			
			var mS=o.shadow;
			if(mS&&(!isMain||(isMain&&o.shadow.mainMenu))){
				if(mS.start)mS=mS.start; else mS=1;
				if(mS-2<=wp.menu.getDepth(E)){
					wp(M).shadowable(o.shadow);
				}
			}
			
			if(isMain&&o.mainButtons)wp.button.menuButtons(M,o);
				
			menu.built=true;
			menu.M=M
			wp.edON=null
			
			if(o.autoopen)wp.menu.autOpn(I,menu,o,M)
			if(o.onmenubuild)o.onmenubuild(M)
			if(o.oncomplete&&isMain)o.oncomplete(M)
		},
		autOpn:function(I,menu,o,M)
		{
			if(!I.ao)I.ao=0;
			if(!I.z)I.autoOpened=[];
			if(I.ao<=o.autoopen){
				/*
				var lST=wp.css.get(menu,"list-style-type");
				if(lST!="none"){
					clearTimeout(I.aoo)
					I.aoo=setTimeout(function(){wp.menu.autOpn(I,menu,o,M)},50);
					return false
				}
				*/
				I.ao++;	
				setTimeout(function(){wp.menu.openByURL(location.href,M,I)},10);
				//mand=mand+" - "+M.className
				//wp.menu.openByURL(location.href,M,I)
			}		
		}
	}
})


