/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: shadow.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: Milonic Shared Source License
	    Details: Adds markup or image based dropshadow to new or existing HTML objects
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.include("css")

wp.extend({		
	shadowable:function(o){
			o=wp.bob(o,1);
			wp.each(this.v,function(a,i){
				var I=a[i];

				if(wp.msie<8){ //  Use proprietary shadow for IE6 and IE7 - IE8 if you intend using opacity
					var V=I.style
					//V.zoom=1;
					if(wp.msie<8&&I.webplug=="window")return
					V.filter=V.filter.replace(/progid\:DXImageTransform\.Microsoft\.Shadow\([^)]*\)/,"")
					V.filter+="progid:DXImageTransform.Microsoft.Shadow(color=#777777,Direction=135,Strength=7)"
				}
				else{
					var DS,DSD
					//alert(o.style)
					if(!I.style.zIndex)I.style.zIndex=1
					
					wp.css.add(o,"shadow");
					if(wp.css.get(I,"position")=="static")I.style.position="relative"
					
					DSD=wp.addNode(I,"div");
					DSD.style.zIndex=-1
					DSD.className="wpShadow"+o.style
					
					DS=wp.addNode(DSD,"div");
					DS.className="wpDS-tr"
					//alert(DSD.className + " - " + DS.className)
					DS=wp.addNode(DSD,"div");
					DS.className="wpDS-r"
					
					if(window.opera)DS.style.height=(I.offsetHeight-16)+"px"
					
					DS=wp.addNode(DSD,"div");
					DS.className="wpDS-br"
					DS=wp.addNode(DSD,"div");
					DS.className="wpDS-b"
					DS=wp.addNode(DSD,"div");
					DS.className="wpDS-bl"
					
					//wp.debug.objects(I)
					I.wpShadow=DSD // Make sure that parent object obtains a reference to the dropshadow for later use
				}
			})
			return this
		},
		shadow:{		
			exec:function(v,o)
			{

				wp(v).shadowable(o);
			},
			size:function(DSD)
			{
				var DSS
				if(wp.msie<7){ // IE6 Bug Fix for dropshadow - could be obsolete and be deleted?
				
				

//alert(wp.css.get(DSD,"z-index"))




				clearTimeout(DSD.shTo)
				if(wp.css.get(DSD,"z-index")>-1){
					DSD.shTo=setTimeout(function(){wp.shadow.size(DSD)},30)
					return false;
				}
				
				
				wp.each(DSD.getElementsByTagName("div"),function(a,i){
					var D=a[i]
					if(D.style){
						if(!DSS)DSS=parseInt(wp.css.get(D,"width"));
						
						wp(D).iePngFix();
						//alert(22)
						//var IM=wp.css.get(D,"background-image")
						//D.style.backgroundImage="url('')";
						//IM=IM.replace(/^url\(\"+|\"\)+$/g,'');
						D.dsOW=DSS*2;
						D.dsOH=DSS*2;
						if(D.className=="wpDS-t"||D.className=="wpDS-b"){
							DSD.style.width=DSD.parentNode.offsetWidth-1;
							var W=parseInt(DSD.parentNode.offsetWidth)-(DSS*2);
							if(W%2==1)W++;
							if(W<0)W=1;
							D.style.width=W-2+"px";
						}
						if(D.className=="wpDS-l"||D.className=="wpDS-m"||D.className=="wpDS-r"){
							DSD.style.height=DSD.parentNode.offsetHeight-1;
							var H=parseInt(DSD.parentNode.offsetHeight)-(DSS*2);
							if(H%2==1)H++;
							if(H<0)H=1;
							D.style.height=H-2+"px";
						}
						
						//D.style.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(src="+IM+",sizingMethod='scale')";
					}
				})
			}
		}
	}
	//shadow:function(o){
//		wp.ini(o,this)
//	}
})	
