/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: tab.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Tabs
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("css,string,position,effect,button");

wp.extend(
{
	tabable:function(o)
	{
		o=wp.bob(o);
		wp.each(this.v,function(a,i){
			var I=a[i];
			if(I.webplug)return
			I=wp.sObj(I,o,"tab");

			if(o.data)wp.tab.initJSONTabs(o.data,o,I);
			
			if(o.theme===null){
			}
			else{
				wp.css.add(o,"tab");
				I.className+=" wp"+o.theme+"Tab";
			}
			
			if(o.className){
				I.className+=" "+o.className;
			}
			
			if(o.width)I.style.width=o.width+"px"

			var count=1;
			var thisTab=I.childNodes[0]
			var nd=wp.addNode(I,"DIV",true)
			nd.className="wpTabHeader";
			
			
			
			if(!thisTab)wp.msg("Tab container not found",o)
			if(thisTab.nodeType==3)thisTab=thisTab.nextSibling
			
			var firstTab=thisTab
			var grp="tabGroup"+wp.uId++
			
			while(thisTab){
				var s=thisTab.getElementsByTagName("SPAN")[0];
				var T=thisTab
					
				if(o.height)T.style.height=parseInt(o.height)+"px";
					
				if(!s){ // This bit adds a tab header if one has not been specified in the HTML
					s={}
					s.innerHTML="Tab "+count
				}
				
				var na=wp.addNode(nd,"A")
				
				na.className=s.className
				na.innerHTML=s.innerHTML
				if(s.id)na.id=s.id
				
				na.href="#"
				na.onclick=function(){return false}
				na.tab=thisTab
				
				//alert(o.theme)
				wp(na).buttonable({theme:"null",className:"wp"+o.theme+"TabButton",
					onclick:function(){
						//wp.debug.objects(this.tab)
						//return
						var E=this.tab.header
						
						//wp.debug.objects(this)
						while(E&&!E.tab)E=E.parentNode
						wp.tab.activate(E.tab)
						if(o.onchange)o.onchange(E)
					}
					,group:grp
				})
				
				wp.removeNode(s);
				
				
				thisTab.className="wpTabContent"
				thisTab.header=na
				
				

				if(o.scrollbarTheme)wp(thisTab).into("scrollbar",{theme:o.scrollbarTheme})
				if(thisTab.parentNode.webplug=="scrollbar")thisTab=wp.next(thisTab.parentNode);	else thisTab=wp.next(thisTab)

				//alert(firstTab.innerHTML)
				
				
				
				//alert(count)
				
				
				count++
				if(count>20){
					alert("tab excess")
					return
				}
			
			}
			I.tabCount=count-1
			//wp.debug.objects(firstTab.header)

			if(o.autoOpen){
				var aOpen=o.autoOpen,io
				if(aOpen>I.tabCount)aOpen=I.tabCount
				if(!wp.msie)aOpen=aOpen*2
				
				io=I.childNodes[aOpen]
				//alert(io.childNodes[0].childNodes[0])
				//if(io.childNodes[0].childNodes[0].webplug=="scrollbar"){
//					io=io.childNodes[0].childNodes[0]
					//wp.debug.objects(io)
				//}
				
				
				//alert(o.scrollbarTheme +" - " + io.webplug)
				
				//if(io.sbI){
					//alert(99)
					//io=io.sbI
				//}
				
				//alert(io.sbI)
				//wp.debug.objects(io)
				
				//io=
				
				wp.execEvent(io.header,"click")
			}
			else{
				//wp.debug.objects(firstTab)
				//alert(firstTab+" - " + firstTab.getAttribute("header")+" - " + firstTab.header)
				wp.execEvent(firstTab.header,"click")
			}
			
			
			//firstTab.header.click()
			//alert(I)
			wp.show(I)
			})			
		},

		getTabHeadByNumber:function(t,n){ //  could be obsolete - browsers other than IE just multiply value by 2 to get correct child node

				var cn=t.childNodes,cc=0
				for(var x=0;x<cn.length;x++){
					if(cn[x].header)cc++
					if(cc==n)return cn[x]
				}
			
		},

		
		tabSelect:function(v){
			if(!wp.msie)v=v*2
			wp.each(this.v,function(a,i){
				wp.execEvent(a[i].childNodes[v].header,"click")
			})
		},
		tab:
		{
			exec:function(v,o)
			{
				wp(v).tabable(o);
			},
			initJSONTabs:function(t,o,I)
			{
				var TAB,TAB,HEADER,a;
				for(a=0;a<t.thisTab.length;a++){
					TAB=wp.addNode(I,"div");
					TAB.innerHTML="<span class='wpTabHeading'>"+t.thisTab[a].heading+"</span>"+t.thisTab[a].content
				}
			},
			activate:function(t)
			{
				setTimeout(function(){
					if(t.parentNode.webplug=="scrollbar")t=t.parentNode
					
					if(t!=t.parentNode.oldTab){
						//alert(t+" - " +t.parentNode.innerHTML)
						if(t.parentNode.oldTab){
							t.parentNode.oldTab.style.display="none"
							wp(t.parentNode.oldTab).fadeOut();
						}
						//alert(t+" -  "+ t.innerHTML)
						t.style.display="block"
						wp(t).fadeIn();
						t.parentNode.oldTab=t
					}
				},100)
			},
			fixtabs:function(I)
			{
				//return
/*
				var HS=0
				var A=wp.clientDims()
				var mt=parseInt(wp.css.get(I.master.parentNode,"margin-top"))		
				var pt=parseInt(wp.css.get(I.tab,"padding-top"))
				var ih=I.offsetHeight
				var tt=I.tab.offsetTop
				if(!mt)mt=0
*/
				//alert("")

			},
			changeContent:function(v,c){
				if(v.tab.vBar&&v.tab.vBar.tagName=="DIV"){
					v.tab.sbI.innerHTML=c
				}
				else{
					v.tab.innerHTML=c
				}
				//alert(c)
				wp.appendScript(c)
			}
		}
	}
)	
