/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: texteditor.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: GNU, General Public License
	    Details: Webplugs Text Editor
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


wp.dependencies("css,string,keyboard,resize");

wp.extend(
{
	texteditable:function(o)
	{
		o=wp.bob(o);
		wp.each(this.v,function(a,i){
			var I=a[i];
			if(I.webplug)return;
			I=wp.sObj(I,o,"texteditor");
			if(!o.theme)o.theme="Webplugs";
			wp.css.add(o,"texteditor");
			I.className="wp"+o.theme+"TextEditor";
			
			wp.setEvents(I,o)
			
			
			
			//if(o.onclick){
//				wp.addEvent(I,"click",o.onclick)
//				
			//}
			
			
			if(I.tagName=="TEXTAREA"||I.tagName=="INPUT"){
				
				var cn=wp.cloneNode(I);
				
				cn.className="wpEditorArea";
				cn.setAttribute("wrap","off")
				cn.setAttribute("spellcheck","false")
				
				var t=wp.addNode(I.parentNode,"div");
				t.className="wp"+o.theme+"TextEditor";
				t.style.height=wp.px(wp.css.get(I,"height"))
				t.style.width=wp.px(wp.css.get(I,"width"))
				
				
				var ln=wp.addNode(t,"div");
				ln.className="wpLineNumbers";
				
				wp.createNode(cn,t);
				wp.removeNode(I);
				wp.texteditor.setLineNumbers(cn);
			
			
				
				//wp.addEvent(cn,"keyup",function(e){
//					var E=wp.getE(e);
					//wp.texteditor.setLineNumbers(E)
					//ln.scrollTop=cn.scrollTop;
					//cn.oH=0
				//})

			
				wp.addEvent(cn,"keydown",function(e)
				{
					
					var E=wp.getE(e);
					if(e.keyCode==13){ //Return
						var T=wp.textSelection(E),tl=T.lineText,out="\n";
						var pft=wp.texteditor.getPrefixTabs(tl);
//wp.debug.objects(T)
//wp.debug.objects(sel)
//document.title=pft

						if(pft){
							for(var a=0;a<pft;a++)out+="\t";
							wp.insertAtCaret(out,e);
							wp.cancelEvent(e);
						}
					}
			
					if(e.keyCode==32){ // Space
						//var sel=wp.getCaret(E)
					}
			
			
					if(e.keyCode==36){ // Home
						if(e.ctrlKey)return
						var sel=wp.getCaret(E); // this function is slow in IE so only call this if necesary
						var T=wp.textSelection(E),tl=T.array[T.line-1];
						var pft=wp.texteditor.getPrefixTabs(tl);
						if((T.char-1)>pft){
							wp.setCaret(E,sel.start-(T.char-1-pft));
							wp.cancelEvent(e);
						}
						if(T.char==1){
							wp.setCaret(E,sel.start+pft);
							wp.cancelEvent(e);
						}
					}

					if(e.keyCode==9){ // Tab
						wp.insertAtCaret("\t",e);
						wp.cancelEvent(e);
					}
					
					setTimeout(function(){
						wp.texteditor.setLineNumbers(E)
						ln.scrollTop=cn.scrollTop;
					},1)
				})


				wp.addEvent(cn,'scroll',function(e){
					ln.scrollTop=cn.scrollTop;
				})

				
				setInterval(function(){
					//document.title=cn.parentNode
					if(!cn.parentNode)return;
					if(cn.oH!=cn.parentNode.offsetHeight||cn.oW!=cn.parentNode.offsetWidth){
						corr=0;
						if(wp.msie<=6)corr=2;
						
						var B=wp.css.box(cn.parentNode),
						    wc=(corr+B[9]+B[11]+B[1]+B[3]),
						    hc=(corr+B[8]+B[10]+B[0]+B[2]),
						    nW=(cn.parentNode.offsetWidth-ln.offsetWidth-corr-wc),
						    nH=(cn.parentNode.offsetHeight-hc)
						    ;
						    
						cn.style.width=wp.px(nW);
						cn.style.height=wp.px(nH);
						
						cn.oH=cn.parentNode.offsetHeight;
						cn.oW=cn.parentNode.offsetWidth;
					}
					if(window.opera)ln.scrollTop=cn.scrollTop;
				},50)
				
				
			}
		})
		return this
	},
	
	texteditor:{
		exec:function(v,o)
		{
			wp(v).texteditable(o);
		},
		getPrefixTabs:function(E){
			var C=wp.getCaretLine(E).split(""),cp=0;
			for(a=0;a<C.length;a++)if(C[a]=="\t")cp++;
			return cp;
			/*
			
			var E=wp.str_replace("\r","",e.value),sel=wp.getCaret(e);
			E=E.substring(0,sel.start)
			var cp=E.lastIndexOf("\n"),cp2=0
			E=E.substring(cp+1,E.length)
			var C=E.split("")
			for(a=0;a<C.length;a++)
			{
				if(C[a]=="\t")cp2++; else a=C.length
				//alert(C[a])
			}
			
			alert(cp + " - " + cp2 + " - " + C.length)
			//if()
			
			
			
			//alert(E)
			
			
			//alert(wp.getCaretLine(e))
			
			
			return sel.start
			*/
		},
		setLineNumbers:function(t){
			if(!t.lineNumbers)t.lineNumbers=0;
			var nl=wp.lineNumbers(t);
			var ol=t.lineNumbers;
			if(nl!=ol){
				var lne=wp.seek(".wpLineNumbers",t.parentNode)[0];
				lne.innerHTML="";
				//nl=10300
				lht=""
				for(var a=1;a<=nl;a++){
					lht=lht+a+"<br>";
				}
				
				lne.innerHTML=lht+"<br><br>";
				//alert(lne.innerHTML)
				
			}
		}
	}
}
)

