/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: tree.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: Milonic Shared Source License
	    Details: Webplugs Treeview Module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


//wp.include("css")
wp.dependencies("css,location,effect");

wp.extend(
{
	treeable:function(o)
	{
		var I,a
		o=wp.bob(o)
		wp.each(this.v,function(a,i){
			I=a[i];
			if(I.webplug)return;
			if(o.data){
				for(var A in o.data)o[A]=o.data[A];
				wp.tree.initJSONMenus(o.data,o,I);
			}
			I=wp.sObj(I,o,"tree");
			wp.css.add(o,"tree");
			I.className+=" wp"+o.theme+"Tree";
			I.theme="wp"+o.theme+"";
			if(o.folders==undefined)o.folders=1;
			if(o.icons==undefined)o.icons=1;
			if(o.lines==undefined)o.lines=1;
			I.master=I;
			wp.setEvents(I,o);
			wp.tree.makeMenu(I);
			wp.show(I);
			//wp.tree.showPageMatch(I);
		})
		return this
	},
	treeExpander:function()
	{
		wp(this.v).__saTree("wpTreeClose")
	},
	treeCollapser:function()
	{
		wp(this.v).__saTree("wpTreeOpen")
	},	
	__saTree:function(v,D)
	{
		wp.each(this.v,function(a,i){
			if(!D)D=wp.tree.getBranches(a[i]);
			var micon=wp.seek("."+v,a[i])
			wp.each(micon,function(a,i){
				wp.execEvent(a[i],"mouseup")
			})
		})
	},	

	__icH:function(l,t)
	{
		wp.each(this.v,function(a,i){
			var M=a[i].getElementsByTagName("ul")[0]
			if(l>=0)l=l;
			else{
				l=wp.matchCSS(M,t)
				if(l>=0)l=0;
			}
			
			if(l)wp(M).addCSSName(t); else wp(M).delCSSName(t);
		})
	},
	treeLines:function(l)
	{
		wp(this.v).__icH(l,"wpTreeLines")
	},
	treeFolders:function(l)
	{
		wp(this.v).__icH(l,"wpTreeFolders")
	},
	treeIcons:function(l)
	{
		wp(this.v).__icH(l,"wpTreeIcons")
	},	
	openTreeByURL:function(u){
		if(u===undefined)u=location.href

		wp.each(wp.location.match(this.v,u),function(a,i){
			var L=a[i].parentNode;
			while(L&&L.webplug!="tree"){
				if(L.tagName=="LI")L.className="pageMatch"
				L=L.parentNode;
			}
		})

		wp.each(wp.seek(".pageMatch",this.v),function(a,i){
			wp.each(wp.seek(".wpTreeClose",a[i]),function(a,i){
				wp.execEvent(a[i],"mouseup");
			})
		})
	},
	tree:
	{
		exec:function(v,o)
		{
			wp(v).treeable(o);
		},

		initJSONMenus:function(t,o,I){			
			var menus,items,II,MENU,ITEM,LINK,ICON;
			for(menus in t){
				if(typeof(t[menus])=="object" && t[menus].length){
					MENU=wp.addNode(I,"ul");
					for(items in t[menus]){
						ITEM=wp.addNode(MENU,"li");
						LINK=wp.addNode(ITEM,"a");
						var itemProps=(eval(t[menus][items]))
						//wp.debug.objects(itemProps)
						LINK.itemProps=itemProps; // Ensure that the events are passed correctly
						for(II in itemProps){
							if(II=="icon"){
								ICON=wp.addNode(ITEM,"span",1);
								ICON.className="wpTreeIcon "+itemProps[II]
								itemProps[II]=null
							} 
							else if(II=="text"){
								LINK.innerHTML=LINK.innerHTML+itemProps[II];
							}
							else if(II=="ajax"){
								LINK.href=itemProps[II]
								LINK.target="_wpAJAX"
							}
							else{
								LINK[II]=itemProps[II]
							}
							
							
							
						}
						if(t[menus][items] && t[menus][items].submenu){
							wp.tree.initJSONMenus(eval(t[menus][items].submenu),o,ITEM)
						}
					}
				}
			}
		},
		getBranches:function(v)
		{
			var e=v.getElementsByTagName("ul"),m=0,aa,tm=0;
			wp.each(e,function(a,i){
				tm=0;
				aa=a[i]
				while(aa){
					aa=aa.parentNode;
					if(aa&&aa.tagName=="UL")tm++;
				}
				if(tm>m)m=tm
			})
			return m;
		},
		getDepth:function(v)
		{
			var D=-1;
			while(v){
				if(v.nodeName=="UL")D++;
				v=v.parentNode;
			}
			return D;
		},
		getContainer:function(v)
		{
			while(v.nodeName!="LI")v=v.parentNode;
			return v;
		},
		getParentItemByMenu:function(m)
		{
			var i=m;
			while(i){
				i=i.parentNode
				if(i&&i.tagName=="LI")return i
			}
			return i
		},
		getParentMenuByMenu:function(m)
		{
			var i=m;
			while(i){
				i=i.parentNode
				if(i&&i.tagName=="UL")return i
			}
			return i
		},
		getMaster:function(m){
			var i=m;
			while(!i.webplug && i.webplug!="tree"){
				i=i.parentNode
			}
			return i
		},
		configureNode:function(v)
		{
			var bch=wp.tree.getBranches(v),depth=wp.tree.getDepth(v),V,S,cN="wpTreeBranch wpTreeLine",N,a,aN,I,M=wp.tree.getMaster(v),E,menu,aaN,o=M.wpObject;
			var A=v.getElementsByTagName("A")[0]
			if(A){
				if(!bch){
					if(A.target=="_wpAJAX"){
						bch=1;
						var U=wp.addNode(v,"UL");
						
						//A.href=wp.ajax.appendURL(A.href,"wpAJAX=1");
						
						
						v.wpAJAX=A.href
						
						if(!o.includeAjaxLink)A.href="#";
						
						if(o.target){
							
							A.target=o.target;
						}
						else{
							
							A.removeAttribute("target")
						}
					}
				}

				S=v.getElementsByTagName("A")[0]
				if(S){
					if(o.target)S.target=o.target
					S=S.href
					if(S&&S.substr(S.length-1,1)=="#"){
						wp.addEvent(A,"click",function(e){
							wp.cancelEvent(e);
						})
					}
				}
			}
			
			
			if(wp.seek(".wpTreeSpan",v)){
				wp.removeNode(wp.seek(".wpTreeSpan",v)[0])
				wp.each(wp.seek(".wpTreeIcon",v),function(a,i){
					a[i].parentNode.icName=a[i].className
					//alert(a[i].tagName)
					wp.removeNode(a[i])
				})
			}	
				
			N=wp.addNode(v,"span",1)
			N.className="wpTreeSpan";

			if(depth==0){ // Must be a main menu
				if(!wp.previous(v))cN="wpTreeStart wpTreeLine"
			}
			if(!wp.next(v))cN="wpTreeEnd wpTreeLine"
			if(!o.lines)cN=""
			S=wp.addNode(N,"span")
			S.className=cN

			V=v.parentNode.parentNode
			for(a=0;a<depth;a++){
				aN=wp.addNode(N,"span",1)
				if(wp.next(V))aN.className="wpTreeTrunk wpTreeLine";
				V=V.parentNode.parentNode
			}

			if(bch>0){
			
				I=wp.addNode("span")
				wp.insertNode(I,N);
				var mOpen=(wp.css.get(I.parentNode.getElementsByTagName("UL")[0],"display")=="block")
				
				if(mOpen)
					I.className="wpTreeIcon wpTreeOpen"
				else
					I.className="wpTreeIcon wpTreeClose"
				
				wp.addEvent(I,'mouseup',function(e){
					E=wp.getE(e).parentNode
					if(!E.built)wp.tree.makeMenu(E,M)
					if(E.wpAJAX)return
					E.built=1
					menu=E.getElementsByTagName("UL")[0]
					menu.master=M
					if(menu){
						I.className="wpTreeIcon wpTreeOpen"
						if(o.folders)wp(wp.next(I)).swapCSSName("wpTreeFolder","wpTreeFolderOpen")
						if(wp.css.get(menu,"display")=="none"){

/*
					v.fx.oncomplete=function(){
						v.style.display="none"
						if(v.master.openSubs<1)v.master.style.zIndex=1
					}

					v.fx.onbegin=function(){
						v.style.display="block"
					}
*/


							
							menu.style.display="block"
							if(M&&M.wpObject.openEffect){
								M.wpObject.openEffect(menu)
							}
						}else{
							I.className="wpTreeIcon wpTreeClose"
							if(o.folders)wp(wp.next(I)).swapCSSName("wpTreeFolderOpen","wpTreeFolder")
							if(M&&M.wpObject.closeEffect){
								M.wpObject.closeEffect(menu)
								menu.fx.oncomplete=function(){
									menu.style.display="none"
								}
							}
							else{
								menu.style.display="none"
							}
						}
					}
				})
				if(o.folders){
					aaN=wp.addNode("span")
					wp.insertNode(aaN,I);
					if(mOpen)
						aaN.className="wpTreeIcon wpTreeFolderOpen";
					else
						aaN.className="wpTreeIcon wpTreeFolder";
				}
			}
			else{
				if(o.icons){
					
					if(!wp.seek(".wpTreeIcon",N.parentNode)){
						aaN=wp.addNode("span")
						wp.insertNode(aaN,N);
						
						if(N.parentNode.icName)aaN.className=N.parentNode.icName; else
						aaN.className="wpTreeIcon wpTreeDoc";
					}
					else{
						//wp.seek(".wpTreeIcon",N.parentNode)[0].cname=aaN.className
					}
				}
			}
		},
		autOpn:function(M,m){
			//wp.debug.objects(M)
			
			
			
		},
		

		openByURL:function(url,mnu,I)
		{		
			mnu=wp.get(mnu)
			
			//wp.debug.objects(window.location)
			
			
			
			wp.each(wp.seek("+A",mnu),function(a,i){
				if(url==a[i].href){
					//alert(url+ " - " +a[i].href + " - " + a[i].innerHTML)
				}
			})
			
			
			
			
			
			
			//wp.each(wp.seek(".pageMatch",mnu),function(a,i){
				//if(a[i].tagName=="A"){
					//I.autoOpened.push(a[i]);
					//a[i].autoOpened=a[i];
					//wp.execEvent(a[i],"mouseover");
				//	wp.execEvent(a[i],"click");
				//}
			//})
		},
		
		makeMenu:function(M,subMaster)
		{
			var A=arguments,cN,lST,menu,I
			menu=M.getElementsByTagName("ul")[0]
			if(!menu)alert("Tree Menu no found")
			//wp(menu).addCSSName("wpTreeLines")
			
			if(M.wpAJAX){
				a=wp.seek(".wpTreeFolder", M)
				//alert(a)
				
				wp(a).swapCSSName("wpTreeFolder","wpTreeFolderLoad")
					wp(M).download({
						url:M.wpAJAX,
						onload:function(t){
							wp(a).swapCSSName("wpTreeFolderLoad","wpTreeFolderOpen")
							var II=M.getElementsByTagName("ul")[0];
							II.innerHTML=t;
							M.wpAJAX=null
							a=wp.seek(".wpTreeIcon", M)[0]
							wp.execEvent(a,"mouseup")
							
							//M.getElementsByTagName("A")[0].href="#";
							
							//alert(M.innerHTML)
							return
						}
					})
				return
			}
			
			lST=wp.css.get(menu,"list-style-type");
			//alert(lST)
			if(lST!="none"){
				//alert(menu.ldd)
				if(!menu.ldd)menu.ldd=10;
				menu.ldd++;
				if(menu.ldd<50)setTimeout(function(){wp.tree.makeMenu(M)},menu.ldd);
				return false;
			}
			
			wp.each(menu.childNodes,function(a,i){
				if(a[i].nodeType==1){
					
					//alert(a[i].innerHTML)
					
					wp.tree.configureNode(a[i]);
				}
			})

			if(subMaster)I=subMaster.wpObject; else I=M.wpObject;
			if(I.onmenubuild)I.onmenubuild(M)
			if(!subMaster){
				if(I.lines)wp(menu).addCSSName("wpTreeLines")
				if(I.icons)wp(menu).addCSSName("wpTreeIcons")
				if(I.folders)wp(menu).addCSSName("wpTreeFolders")
				//if(I.autoOpen)wp.tree.autOpn(M,I)
				//if(I.autoOpen)wp(M).openTreeByURL("/menu/treemenu.php?id=123")
				if(I.autoOpen)wp(M).openTreeByURL()
				if(I.oncomplete)I.oncomplete(I)
			}
		}
	}
})
