/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: user.js
	    Version: 0.4.8100
	      Built: January 21 2011
	    License: Milonic Shared Source License
	    Details: Webplugs framework module for website login system
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

wp.dependencies("form,css");

wp.extend(
	{		
		userable:function(o)
		{
			o=wp.bob(o);
			if(!o.path)o.path="/webplugs/";
			wp.css.add(o,"user");
			wp.each(this.v,function(a,i){
				var D=wp.get("__wpLoginWindow")
				if(D){ 
					//alert("Login Window Already Found")
					return // Login window already found, do not recreate.
				}
				
				D=wp.addNode("div");
				D.id="__wpLoginWindow"
				D.theme=o.theme
				//I.className+=" wp"+o.theme+"Login"
				//alert(o.theme)
				wp(D).addCSSName("wp"+o.theme+"User");


var userAction=""
if(o.action)userAction="?formAction="+o.action
//alert(D.theme)
				//D.style.display="none"
				var DD=wp.addNode(D,"div");
				DD.id="winTbar"+wp.uId++
				DD.innerHTML="<img src="+wp.getPath()+"themes/"+o.theme+"/login/login-bg.gif>"
				
				var T=this;
				//alert(o.title)
				wp(D).into("window",{
					theme:o.theme
					,type:"modal"
					,open:true
					,topbar:DD.id
					,width:"440px"
					//,scrollbarTheme:"Venom"
					,scrollbarTheme:"null"
					,height:"226px"
					,title:o.title
					,align:"center;middle"
					,onload:function(v){
						//wp(v).setAlignment("center;middle")
						if(o.top||o.left)wp(v).setPosition(o)
						//if(o.left)wp(v).setPosition(o)
					}
					,onchange:function(e){
						
						if(window.Recaptcha&&e.innerHTML.match(/recaptcha_response_field/)){
							var F=wp.seek("+FORM",e)[0]
							if(F.getAttribute("refreshCaptcha")){
								Recaptcha.reload()
								F.removeAttribute("refreshCaptcha");
							}
						}
					}					
				});

				//alert(wp.getPath()+"server/"+wp.server+"/user."+wp.server)


				logKey=""
				if(o.loginKey){
					if(userAction)userAction+="&loginKey="+o.loginKey;else userAction="?loginKey="+o.loginKey
				}

				wp("__wpLoginWindow").into("ajax",{
					action:"download",
					url:wp.getPath(o.path)+"server/"+wp.server+"/user."+wp.server+userAction,
					onload:function(v){
						if(o.onlogin){
							this.v.onlogin=o.onlogin
						}
						if(o.onfail){
							this.v.onfail=o.onfail
						}
						wp(this.v).changeWindowContent(v,"LoginForm",o.title)
					}
				})
			})
			return this
		},
		user:{
			exec:function(v,o)
			{
				wp(v).userable(o);
			},
			login:function(o){
				wp('tempLoginWindow').into('user',o)
			},
			logout:function(o){
				if(!o)o={}
				if(!o.path)o.path="/webplugs/";
				var D=wp.get("__wpLoginWindow")
				//alert(D)
				wp(D).into("ajax",{
					action:"download",
					url:wp.getPath(o.path)+"server/"+wp.server+"/user."+wp.server+"?formAction=logout",
					onload:function(v){
						wpLoggedInUser=null
						if(o.onlogout)o.onlogout()
					}
				})
				
			},
			required:function(T){
				wp(wp.next(T)).swapCSSName("good","bad")
				T.nextSibling.innerHTML="Required"
			},
			checkUsername:function(u,T,o){
				//T.validated=0
				if(!u){
					wp.user.required(T)
					return
				}

				if(T.oldValue && T.oldValue==T.value)return
				T.oldValue=T.value
				if(!o)o={}
				if(!o.path)o.path="/webplugs/";
				wp().into("ajax",{
					action:"download",
					url:wp.getPath(o.path)+"server/"+wp.server+"/user."+wp.server+"?formAction=checkUsername&username="+u,
					onload:function(t){

						if(t=="bad"){
							wp(T.nextSibling).swapCSSName("good","bad")
							T.nextSibling.innerHTML="Already in use"
							
							//alert(wp.next(T).className)
							//alert(T.tagName+" - " + wp.next(T).tagName)
							//wp.debug.objects(wp.next(T))
							
							/*
							wp.msg("Username is already in use",{
								theme:wp.getTheme(T),
								title:"Check Email",
								buttons:{
									okButton:{
										text:"OK",
										action:function(){
											T.focus();
											wp.window.close(this);
										}
									}
								}
							})
							;
							*/
						}
						else{
							wp(wp.next(T)).swapCSSName("bad","good")
							T.nextSibling.innerHTML="&nbsp;"
							//T.validated=1
						}
					}
				})				
			},
			checkEmail:function(u,T,o){
				//T.validated=0
				if(!u){
					wp.user.required(T)
					return
				}
				if(!o)o={}
				if(!o.path)o.path="/webplugs/";
				wp().into("ajax",{
					action:"download",
					url:wp.getPath(o.path)+"server/"+wp.server+"/user."+wp.server+"?formAction=checkEmail&email="+u,
					onload:function(t){
						if(t=="good"){
							wp(wp.next(T)).swapCSSName("bad","good");
							T.nextSibling.innerHTML="&nbsp;"
							//T.validated=1
							return
						}
						else wp(wp.next(T)).swapCSSName("good","bad");
						var m
						if(t=="bad"){
							//m="Email address in not in an acceptable format";
							m="Wrong Format";
						}
						if(t=="baddomain"){
							//m="Email address domain name has not been found";
							m="Unknown Domain";
						}

						if(t=="nomx"){
							//m="Email address domain name has not been found";
							m="No MX Records";
						}
						if(t=="inuse"){
							//m="Email address is already in use";
							m="Already in use"
						}
						T.nextSibling.innerHTML=m
						
						/*
						wp.msg(m,{
							theme:wp.getTheme(T),
							title:"Check Email",
							buttons:{
								okButton:{
									text:"OK",
									action:function(){
										T.focus();
										wp.window.close(this);
									}
								}
							}
						});
						*/
						
					}
				})				
			},
			checkPasswords:function(p1,p2,T){
				//T.validated=0
				if(!T.value){
					
					wp.user.required(T);
					return;
				}
				
				var F=T;
				while(F&&F.tagName.toUpperCase()!="FORM")F=F.parentNode;
				
				var PW=F['password'],PWC=F['passwordConfirm'];
				
				if(PWC.value){
					if(PW.value!=PWC.value){
						wp(wp.next(PW)).addCSSName("good");
						var nm="No Match";
						wp(wp.next(PW)).swapCSSName("good","bad").object.innerHTML=nm;
						wp(wp.next(PWC)).swapCSSName("good","bad").object.innerHTML=nm;
					}
					else{
						wp(wp.next(PW)).swapCSSName("bad","good").object.innerHTML="&nbsp;";
						wp(wp.next(PWC)).swapCSSName("bad","good").object.innerHTML="&nbsp;";
						//PW.validated=1
						//PWC.validated=1
					}
				}
				
				
				
				/*
				if(!o)o={}
				if(!o.path)o.path="/webplugs/";
				wp().into("ajax",{
					action:"download",
					url:wp.getPath(o.path)+"server/"+wp.server+"/user."+wp.server+"?formAction=checkUsername&username="+u,
					onload:function(t){
						if(t=="bad"){
							wp(wp.next(T)).swapCSSName("good","bad")
							wp.msg("Username is already in use");
						}
						else{
							wp(wp.next(T)).swapCSSName("bad","good")
						}
					}
				})
				*/
			}

		}
	}
)	
