/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: webplugs.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: GNU, General Public License
	    Details: Webplugs JavaScript Framework Core File
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/

(function() {
	if(window.wp)return // webpugs is already loaded - must not load again otherwise we lose the includes
	//var wp=window.wp=window.$=function(v){
	var wp=window.wp=function(v){
		return new wp.fN.init(v);
	}

	wp.fN=wp.prototype={
		init:function(v){
			this.v=wp.element.v=v
			if(typeof(v)==="object")this.object=v; else{
				var vv=wp.seek(v),O
				if(vv){
					if(vv.length==1)O=vv[0];
					else if(vv.length>1)O=vv;
					else alert(9976568699);
					if(O&&O.webplug=="scrollbar"&&O.sbC)O=O.sbC;
					this.object=O;
				}
			}
			return this
		}
	}
	
	wp.extend=wp.fN.extend=function(d,s){
		if(!s)s=this;
		for(var i in d){
			s[i]=d[i]
			wp.fN[i]=d[i]
		}
	}
	
	wp.extend({
	version:"1.0",
	defaultTheme:null,
	server:"php",
	zindex:100,
	ziObj:[],
	inc:[],
	dep:[],
	fire:{},
	uId:0,
	/*@cc_on
		msie:navigator.appVersion.match(/MSIE (\d\.\d)/)[1], // We only need to do browser checks for IE, webplugs is designed to work across all browsers without the need for sniffing but IE does very different things depending on its version
	@*/
	webkit:window.WebKitPoint,
	// if(window.WebKitPoint) - user agent is Safari or Chrome
	element:{},
	webplugsEditor:function(){
		//wp.path="http://webplugs.net/webplugs/"
		wp(this).into('webplugseditor',{theme:'Webplugs'},wp.path);
	},
	mod:function(v)
	{
		wp.include(v,wp.getPath()+"modules/");
		wp[v]=1;
	},
	msg:function(v,o)
	{
		var m=wp.addNode("div");
		wp.hide(m);
		m.innerHTML=v;
		wp(m).into("dialog",o);
	},
	bob:function(o,S)
	{
		if(!o)o={};
		if(typeof(o.theme)=="undefined")o.theme=wp.defaultTheme;
		if(S&&!o.style)o.style="Default";
		return o;
	},
	sObj:function(I,o,t){
		
		//alert(I.innerHTML + " - " + t)
		
		if(!I.tagName)I=wp.addNode("div",1)
		if(I.wpObject)o=I.wpObject;
		I.wpObject=o;
		//I.orig=I.innerHTML;
		
		I.webplug=t;
		return I
	},
	getE:function(e)
	{
		if(e.tagName)return e
		return e.target?e.target:e.srcElement;
	},
	rT:function(v,d){
		/*
		v:value, d:defaultto return  if undefined
		This function takes a value and returns true if it is undefined.
		It means we can have a default of true for a value even though nothing has been declared.
		*/
		if(!d)d=true;
		if(typeof(v)=="undefined")v=d;
		return v;
	},
	iePngFix:function(T)
	{
		if(!T)T="scale";
		if(wp.msie<7){
			wp.each(wp.seek(this.v),function(a,i){
				var IM=wp.css.get(a[i],"background-image");  // Get the background image rule from CSS
				if(IM.search(/.png/ig)>-1){                  // Only apply if image is a .png
					a[i].style.backgroundImage="url('')";    // Need to remove the backgroundImage rule, replacing with AlphaImageLoader rule instead
					IM=IM.replace(/^url\(\"+|\"\)+$/g,'');   // Extract filename from CSS rule
					a[i].style.filter+="progid:DXImageTransform.Microsoft.AlphaImageLoader(src="+IM+",sizingMethod="+T+")";
				}
			})
		}
		return this
	},
	getTheme:function(v){
		if(v.wpObject)if(v.wpObject.theme=="null")return
		while(v&&!v.theme){
			if(v.wpObject&&v.wpObject.theme)return v.wpObject.theme;
			v=v.parentNode;
		}
		if(v&&v.theme)return v.theme;
		//alert(v+" - "  +ov.className)
	},
	changeTheme:function(v,newTheme)
	{
		var V=wp.get(v),R=[],O,oldTheme;
		var A=wp.getPlugs(null,V)	
		
		for(O in A)R[O]=A[O];
		A=R;
		A.push(V);


		if(V.wpObject&&V.wpObject.theme)oldTheme=V.wpObject.theme
		if(!oldTheme)oldTheme=V.theme
		if(oldTheme){
			wp.each(A,function(a,i){
				if(a[i]&&a[i].wpObject){
					
					if(a[i].webplug){
						if(a[i].webplug=="menu"&&a[i].master)a[i]=a[i].master
						
						var reg=new RegExp("wp"+oldTheme,"g")
						a[i].className=a[i].className.replace(reg,"wp"+newTheme);
						
						
						if(wp.webplug=="toolbar")alert(a[i].className)
						a[i].wpObject.theme=newTheme;
						wp.css.add(a[i].wpObject,a[i].webplug);
					}
				}
			})
		}
	},		
	seek:function(v,L)
	{
		if(!this.fN)v=this.v;
		var output=[],i,c,e,s,I,a,A,R=[],O,o,S,OBJ,J=0,K;
		
		if(typeof(v)=="string"){
			
			s=v.split(".");
			i=s[0];
			c=s[1];
			s=i.split("+");
			i=s[0];
			e=s[1]?s[1]:"*";
			I=wp.get(i);
			
			//alert(1+" - "+i+" - "+c+" - "+v+" - "+e+" - " + L)

			
			if(c){// ClassName specified with ".clsName" as first argument
				//alert(2+" - "+c)
				if(!I)I=document;
				if(L)I=L;
				OBJ=I.getElementsByTagName(e);
				if(OBJ.length==0){
					OBJ=[]
					OBJ[0]=I
				}
				K=OBJ.length
				
				while(J<K){
					//alert(c+" - " +e+" - " +K+" - " + J)
					var found=0;
					if(OBJ[J].className){
						wp.each(OBJ[J].className.split(" "),function(a,i){
							if(a[i]==c)found=1;
						})
					}
					if(O&&e!=OBJ[J].id)found=0;
					if(found)output.push(OBJ[J]);
					J++
				}
			}
			else{
				if(i&&e=="*"&&!L){
					return I?[I]:false;
				}
				else{
					if(!L)L=document
					if(typeof(L)=="string"){
						s=L.split(".");
						if(s[1]===undefined){
							L=wp.get(s[0]);
							output=L.getElementsByTagName(e);
						}else{
							wp.each(wp.seek(L),function(a,i){
								wp.each(wp.seek(v,a[i]),function(a,i){
									output.push(a[i]);
								})
							})
						}
					}
					else{
						output=L.getElementsByTagName(e);
					}
				}
			}
			if(output.length==0)output=null
			return output;
		}
		else{
		
			return v
		}
	},
	each:function(o,f,a) // a parameter forces each to scan through all elements in an object
	{
		if(typeof(o)=="string")o=wp.seek(o)
		if(!o)return;
		var VL=o.length,A
		if(o.tagName=="FORM")VL=0 // Form returns length as number of elements and screws this bit up
		if(a||VL){
			if(VL===undefined){
				for(A in o)f.call(this,o,A);
			}
			else{
				for(A=0;A<VL;A++)f.call(this,o,A);
			}
		}
		else{
			f.call(this,[o],0)
		}
	},
	loadFunc:[],
	onload:function(f)
	{
		wp.loadFunc.push(function(){return f.apply(f)})
	},
	setready:function()
	{
		for(var x=0;x<wp.loadFunc.length;x++)wp.loadFunc[x].apply();
		wp.docState="complete";
		try{document.execCommand("BackgroundImageCache",false,true)}catch(err){}
	},
	ready:function()
	{
		var d=document;
		if(d.addEventListener){
			d.addEventListener('DOMContentLoaded',wp.setready,false);
		}
		else if(wp.msie){
			try{d.documentElement.doScroll("left")}catch(error){
				setTimeout("wp.ready()",10);
				return;
			}
			wp.setready()
		}
		else wp.addEvent(window,"load",wp.setready())
	},	
	getPath:function(F)
	{
		if(F)return F;
		if(wp.path)return wp.path;
		var S,a,s,V;
		S=document.getElementsByTagName("script");
		for(a=0;a<S.length;a++){
			V=S[a].src;
			s=V.split("\/");
			if(s[s.length-1]=="webplugs.js"){
				wp.path=V.substr(0,V.length-11);
				return wp.path;
			}
		}
	},
	addScript:function(f){
		var S=document.createElement('script');
		S.type='text/javascript';
		if(f)S.src=f
		document.getElementsByTagName("head")[0].appendChild(S);
		return S;	
	},
	include:function(f,F)
	{
		var S;
		if(!wp.inc[f]){
			if(!wp.docState){
				document.write('<scr'+'ipt type="text/javascript" src="'+wp.getPath(F)+f+'.js"></scr'+'ipt>');
			}
			else{
				//alert(wp.getPath(F)+f+".js")
				wp.addScript(wp.getPath(F)+f+".js",F)
			}
			wp.dep.push(f);
			wp.inc[f]=1;
		}
		return this;
	},
	incOnLoad:function(f,p,V)
	{

		for(var d in wp.dep){
			if(!wp[wp.dep[d]]&&typeof(wp.dep[d])=="string"){
				setTimeout(function(){wp(V).incOnLoad(f,p,V)},10);
				return
			}
		}

		if(wp[f]&&wp[f].exec){
			
			//alert(f+" - "+  V + "  - " + p)
			
			wp[f].exec(V,p)
		}
		return this
	},	
	into:function(v,p,F)
	{
		var V=this.v
		if(!this.object){
			V=wp.addNode("div")
			V.id=this.v
		}

		wp(V).include(v,F).incOnLoad(v,p,V)
		return this;
	},
	create:function(v,o)
	{
		if(!o)o={}
		var D=wp.addNode("div",1)
		D.innerHTML="Webplugs Object"
		wp(D).into(v,o)
		return D
	},
	ondone:function(v)
	{
		//alert(v)
		wp.each(wp.dep,function(a,i){
			if(!wp[a[i]])return
		})
		var V=this.v
		if(V&&V.tagName){
			//document.title+="-"+V.tagName
			if(!V.webplug){
				setTimeout(function(){wp(V).ondone(v);},1)
				return
			}
		}
		v();
	},
	dependencies:function(v)
	{
		var D=v.split(",");
		wp.each(D,function(a,i){
			wp.include(a[i],wp.incLoc)
		})
	},
	get:function(v,w)
	{
		if(!w)w=window;
		if(!this.fN)v=this.v;
		if(!v)return null;
		if(typeof(v)=="string")v=w.document.getElementById(v);
		return v
	},
	getPlugs:function(v,d){
		if(!d)d=document;
		var a=wp.getAll(d),o=[];
		//alert(a.length)
		wp.each(a,function(a,i){
			if(v){
				if(a[i].webplug==v)o.push(a[i])
			}else{
				if(a[i].webplug)o.push(a[i])
			}
			
			//if(!v && )
			
		})
		return o
	},
	getType:function(v){
		//if(!v&&!v.constructor)return null
		return v.constructor.toString().match(/^.*? (\w*)/m)[1];
	},
	parentPlug:function(o,t){
		while(o){
			
			
			if(o.webplug){
				if(t){
					if(t==o.webplug)return o
				}
				else{
					return o
				}
			}
			o=o.parentNode
		}
		return 
	},
	getAll:function(v)
	{
		if(wp.msie<6) return v.all; else return v.getElementsByTagName("*")
	},
	addNode:function(d,e,p,A){
		// d object adding to
		// e element to add
		// p flag for including object as first object
		if(typeof(d)=="string"){//If d is a string then we assume that you want the string added as an element to document.body
			p=e
			e=d;
			d=document.body;
		}
	
		var O=document.createElement(e);
		if(p){
			if(d.firstChild)d.insertBefore(O,d.firstChild);
		}
		else{
			d.appendChild(O);
		}
		
		if(A)
			for(var a in A)
				O[a]=A[a]

		return O
	},	
	cloneNode:function(i,deep) // wp.cloneNode(OBJ:object,BOOL:before/after(default is after),BOOL:do NOT include children)
	{
		
		if(!i.nodeType)return i
		
		if(i.nodeType==8)return i
		if(i.nodeType==3){
			if(wp.msie<9){ // IE being IE means it needs a workaround - it seems to remove nodeValue from a cloned text node if you remove innerHTML after cloning the node
				var I={}; 
				I.nodeType=3;
				I.nodeValue=i.nodeValue;
				return I;
			}
			return i
		}
		
		if(!deep)deep=true;
		
		
		var N=i.cloneNode(deep),
		li=i.getElementsByTagName('*'),
		li2=N.getElementsByTagName('*');

	
		if(!wp.msie || wp.msie>8){
			
			for(var a in i.wpEvents){
				//alert(a+ " - " + i + " - " + i.tagName)
				wp.addEvent(N,a.split("_")[0],i.wpEvents[a])
			}

			wp.each(li,
				function(V,ii){
					if(ii){
						if(V[ii].nodeType==1 && V[ii].wpEvents){
							//andy="";
							for(var a in V[ii].wpEvents){
								wp.addEvent(li2[ii],a.split("_")[0],V[ii].wpEvents[a])
								//andy=andy+li2[ii].tagName+" - "+a.split("_")[0]+" - "+V[ii].wpEvents[a]+"\n"
							}
							//alert(andy)
						}
					}
				}
			)
		}
		return N
	},
	insertNode:function(N,i,p) //N:node to be inserted, i: Adjacent Node where node is to be placed, p:before or after adjacent node
	{
		if(!N.nodeType)return N
		if(N.nodeType==3){
			var AA=document.createTextNode(N.nodeValue);
			i.parentNode.insertBefore(AA,i);
		} 
		else {
			//alert(N+" - "+i+" - "+p+" - "+i.innerHTML)
			
			i.parentNode.insertBefore(N,p?i:i.nextSibling);
			//alert(N+" - "+i+" - "+p+" - "+i.tagName +" - " + N.innerHTML)
		}
		
		
	},
	createNode:function(N,i) // N: node to be created, i: Object where node is to be created - Creates a Node inside a parent Node
	{
		var t=wp.addNode(i,"span");
		wp.insertNode(N,t);
		wp.removeNode(t);
	},
	moveNode:function(n1,n2){
		var N=n2.nextSibling;
		//n1.parentNode.replaceChild(n2,n1);
		n2.parentNode.insertBefore(n1,N);
	},
	swapNode:function(n1,n2)
	{
		var N=n2.nextSibling;
		n1.parentNode.replaceChild(n2,n1);
		n2.parentNode.insertBefore(n1,N);
	},
	wrapNode:function(e,w,sa){
		if(!w)w="div";
		var wrapper=wp.addNode(w),A,a,E=e.attributes
		//alert("1 "+e.innerHTML+" - " +e.header)
		if(e.parentNode)e.parentNode.replaceChild(wrapper,e);
		wrapper.appendChild(e);
		if(sa){//swap attributes and events
			if(E.length){
				var A=[]
				wp.each(E,function(a,i){
					
					if(a[i].value && a[i].specified){
						//if(a[i].nodeName=="header")alert(a[i].value +"  - " +  a[i].specified)
						//alert(a[i].nodeName+" - " +a[i].value)
						//alert(a[i].nodeName+" - " +a[i].value + " - " + a[i].expando +" - " + typeof(a[i].value)+" - " + (a[i].value===null) +" - " +a[i].specified)
						wrapper.setAttribute(a[i].nodeName,a[i].value);
					}
					if(!a[i].expando)A.push(a[i].nodeName);
				})
				
				for(a=0;a<A.length;a++){
					e.removeAttribute(A[a]);
				}
			}
			
			//wp.debug.objects(E)
			//wp.debug.objects(e)
			//wp.debug.objects(wrapper)
			//alert(wrapper.innerHTML)
			//alert(e.innerHTML)
		}
		return wrapper;
	},	
	/*
	alldescendants:function(v)
	{
		return v.getElementsByTagName("*");
	},
	rScr:function(v)
	{
		
		var V=wp.alldescendants(v)
		for(var a in V)
		{
			//if(V[a].wpScript)alert(a)
		}
		
		
		
		v=v.wpScript
		if(v)v.parentNode.removeChild(v);
	},
	*/
	removeNode:function(f)
	{
		var F=wp.seek(this.v)
		if(f)F=wp.get(f) // This allows for both wp(OBJ).removeNode() as well as wp.removeNode(OBJ)

		wp.each(F,function(V){
			
			if(V.length>-1){ // This will only remove the first Node in a collecion - Do we need to remove multiple nodes?
				//document.title=V.length
				if(!V[0].parentNode||V.length==0)return wp;
				wp.removeAllEvents(V[0]);
				//alert(V[0].tagName+" - " + V[0].innerHTML+" - " + V.length)
				V[0].parentNode.removeChild(V[0]);
			}
			else{
				V.parentNode.removeChild(V);
			}
		})
		return this
	},		
	copyNode:function(n){
		n=wp.get(n)
		var N=wp.cloneNode(n);
		wp.insertNode(N,n);
		//alert(n);
		return N
	},

	getParentNode:function(v,t,c)
	{
		if(!c)c=1;
		var found=0;
		var count=1;
		while(!found&&v.tagName){
			v=v.parentNode;
			if(v.tagName==t){
				if(count==c)found=1;
				count++;
			}
		}
		if(!v.tagName)v=undefined;
		return v;
	},
	processHTML:function(o,h){
		if(!o)return
		var re=/<script\b[\s\S]*?>([\s\S]*?)<\/script>/i,S="",s;
		while(s=re.exec(h)){
			S=S+s
			h=h.replace(re,"");
		}
		o.innerHTML=h
		wp.appendScript(S)
	},
	appendScript:function(v)
	{
		//alert(v)
		var reg,re=/<script\b[\s\S]*?>([\s\S]*?)<\/script>/i,match,scr="",s,str,doJS,S,a,tmp;
		while(str=re.exec(v)){
			//alert(str)
			S=str+""
			var re=/<script\s*(\b[\s\S]*?)>([\s\S]*?)<\/script>/i;
			var matches=S.match(re);
			reg=/(\w+)\s*=\s*("[^<>"]*"|'[^<>']*'|\w+)/g;
			var tattr=matches[1].match(reg),attr={};
			attr['text']=matches[2];
			for(a=0;a<tattr.length;a++){
				reg=/(\w+)\s*=\s*[\"|'](.*)[\"|']/;
				tmp=tattr[a].match(reg);
				if(!tmp){
					reg=/(\w+)\s*=\s*(.*)/;
					tmp=tattr[a].match(reg);
				}
				attr[tmp[1]]=tmp[2];
			}

			doJS=1
			var js=document.getElementsByTagName("script") // Check to see if the script already exists
			for(s in js){
				if(js[s]&&js[s].text&&js[s].text==attr['text']){
					wp.removeNode(js[s])
					
				}
				if(js[s]&&js[s].src){
					reg=new RegExp(attr['src']+"$")
					var m=js[s].src.match(reg);
					if(m&&m==attr['src']){
						doJS=0
						break
					}
				}	
				
			}
			
			if(doJS){
				var S2=wp.addScript()
				for(a in attr)S2[a]=attr[a]
			}
			v=v.replace(re,"");

		}
	},
	//},
	//event:
	//{
	addEvent:function(o,t,f)
	{
		if(typeof(o)=="string")o=wp.get(o)
		if(!o)return
		if(!o.wpEvents)o.wpEvents={};
		var N=t+"_wpEvent"+wp.uId++;
		if(wp.msie<9){
			o[N]=f;
			o.wpEvents[N]=function(e){
				o[N](e);
			}
		}
		else 
		o.wpEvents[N]=f;
		if(o.attachEvent)o.attachEvent("on"+t,o.wpEvents[N]);else o.addEventListener(t,o.wpEvents[N],false)
		return this
	},

	execEvent:function(o,eType)
	{
		for(var a in o.wpEvents){
			if(a.split("_")[0]==eType)o.wpEvents[a].call(o,o)
		}
		return this
	},		
	removeEvent:function(o,t,f)
	{
		var O,C,E=o.wpEvents;
		for(C in E){
			var S=E[C];
			if(wp.msie<9)S=o[C];
			if(S&&f&&(S.toString()==f.toString()))O=C;
		}
		if(O){
			f=E[O];
			delete E[O];
			if(wp.msie<9)delete S;
			if(o.detachEvent)o.detachEvent("on"+t,f);else o.removeEventListener(t,f,false)
		}
		return this
	},
	removeAllEvents:function(o){
		if(o.wpEvents){
			for(var a in o.wpEvents)
				wp.removeEvent(o,a.split("_")[0],o.wpEvents[a])
		}
		return this;
	},
	cancelEvent:function(e)
	{
		if(!e)return false;
		e.returnValue=false;
		e.cancelBubble=true;
		if(e.preventDefault){
			e.preventDefault();
			e.stopPropagation();
		}
	//alert(99)
		// Opera will not cancel bubbling on keypress from a keydown event, need to force keypress to stop here	
		if(window.opera&&e.type=="keydown"){
			
			var E=wp.getE(e),F=function(e){wp.cancelEvent(e)}
			wp.addEvent(E,"keypress",F)
			wp.addEvent(E,"keyup",function(e){wp.removeEvent(E,"keypress",F)})
		}
		
		return false
	},
	makeMovable:function(v)
	{
		v.style.position="absolute";
		return this
	},
	show:function(v)
	{
		//v.style.display="block";
		v.style.visibility="visible";
		return this
	},	
	hide:function(v)
	{
		//v.style.display="none";
		v.style.visibility="hidden";
		return this
	},
	outerHtml:function(v)
	{
		if(v.outerHTML)return v.outerHTML;
		else
		{
			var E={"IMG":1,"BR":1,"INPUT":1,"META":1,"LINK":1,"PARAM":1,"HR":1},
			A=v.attributes,S="<"+v.tagName,x;
			for(x=0;x<A.length;x++)S+=" "+A[x].name+"=\""+A[x].value+"\"";
			if(E[v.tagName])return S+" />";
			return S+">"+v.innerHTML+"</"+v.tagName+">";			
		}
	},
	IsWS:function(n)
	{
		return !(/[^\t\n\r ]/.test(n.data));
	},
	WsIgnore:function(n)
	{
		return(n.nodeType==8)||((n.nodeType==3)&&wp.IsWS(n));
	},
	previous:function(o)
	{
		while((o=o.previousSibling))if(!wp.WsIgnore(o))return o;
	},
	next:function(o)
	{
		while((o=o.nextSibling))if(!wp.WsIgnore(o))return o;
	},
	firstElement:function(v,Z)
	{
		Z=0;
		if(v.childNodes[0].nodeType==3)Z=1;
		return v.childNodes[Z];
	},
	descendants:function(v,o){
		if(!o)o=[];
		wp.each(v.childNodes,function(a,i){
			if(a[i].nodeType)o.push(a[i]);
			//if(a[i].nodeType==1)o.push(a[i].tagName);
			//if(a[i].nodeType==3)o.push("'"+a[i].nodeValue+"'");
			if(a[i].childNodes)wp.descendants(a[i],o);
		})
		return o
	},
/*
last_child:function ( par )
{
	var res=par.lastChild;
	while (res) {
	if (!wp.WsIgnore(res)) return res;
	res = res.previousSibling;
	}
	return null;
},
first_child:function ( par )
{
	var res=par.firstChild;
	while (res) {
	if (!wp.WsIgnore(res)) return res;
	res = res.nextSibling;
	}
	return null;
},
*/
	tofront:function(v)
	{
		v.style.zIndex=wp.zindex++;
		//wp.hasFocus=v;
		//alert(v.innerHTML)
		//document.title=v.style.zIndex

		/*
		
		wp.zindex=100
		var found=0
		for(var a=0;a<wp.ziObj.length;a++){
			wp.ziObj[a]
			wp.ziObj[a].style.zIndex=wp.zindex++;
			//document.title=document.title+wp.get(wp.ziObj[a]).offsetHeight+"-"+wp.ziObj[a].style.zIndex+", "
			//alert(wp.ziObj.length+" - " +wp.ziObj[a].style.zIndex + " - " + wp.ziObj[a].innerHTML)
			if(wp.ziObj[a]==v)found=1
		}
		
		
		
		//if(wp.ziObj[v]){
			
			//for(var a in wp.ziObj){
				//alert(9886 + " - " + wp.zindex)
				//if(wp.ziObj[a]){
//					wp.ziObj[a].style.zIndex=wp.zindex++;
					//alert(wp.ziObj[a].style.zIndex)
				//}
				//wp.debug.objects(a)
		//	}
			//v.style.zIndex=wp.zindex++;
		//	setTimeout(function(){
		//wp.debug.objects(wp.ziObj)},
		//2000)
			
		//}else {
			//wp.ziObj[v]=v;
//			w
			//alert(v.tagName)
		if(!found){
			v.style.zIndex=wp.zindex++;
			wp.ziObj.push(v)
		}
		*/
		return this;
		
	},
	getMouseCoords:function(e)
	{
		return{x:e.clientX,y:e.clientY}
	},	
	getObjMouseCoords:function(e)
	{
		//if(window.event)e=event;
		return{x:e.layerX?e.layerX:e.offsetX,y:e.layerY?e.layerY:e.offsetY}
	},
	//S:function(v) // same as: var tempVar="";if(val)tempVar=val;
	//{
//		return v?v:"";
//	},
	wpAction:function(v,a)
	{
		a="on"+a
		if(v.wpObject[a])v.wpObject[a]()
	},
	setEvents:function(D,II)
	{
		for(var C in II)if(C.substr(0,2)=="on"&&II[C]){
			wp.addEvent(D,C.substr(2),II[C])
		}
	},
	px:function(v)
	{
		var out=parseInt(v);
		if(!isNaN(out))return out+"px";
		return v;
	},
		DELETE_fixZI:function(v)
		{
			var e,p;
			if(wp.msie<9){
				try{
					if(v.filters)
					{
						e=wp.addNode(v,"iframe",true);
						e.style.filter="Alpha(Opacity=0)"
						e.style.position="absolute"
						//e.style.display="block"
						e.style.top="-1px";
						
						e.style.left="-1px";
						e.className="wpMenuMask"
						v.iframe=e
						p=this.getDimension(v)
						wp(e).setDimension({height:p.height,width:p.width})
						e.style.visibility="visible"
						e.style.zIndex=-1			
					}
				}
				catch(e){}
			}
		},
		DELETE_get_Obj:function(o,t)
		{
			if(o&&o.object)wp.v=o.object;
			for(var C in o)if(C!="object")t[C]=o[C];
			return wp.v
		},
		edit:function()
		{
			var W=wp.get("wpEd")
			if(W){
				wp(W).openWindow()
			}
			else{
				var W=wp.addNode("DIV");
				W.id="wpEd";
				wp(W).into("htmleditor",{windowable:true});
				
				wp.addEvent(document.body,'mousemove',function(e){
					E=wp.getE(e)
					N=wp.get("wpEdH");
					if(N)wp.removeNode(N);
					N=wp.addNode(E,"DIV");
					N.id="wpEdH";
					N.style.position="absolute";
					N.style.border="2px solid #3789ef";
					N.style.MozBorderRadius="5px"
					N.style.WebkitBorderRadius="5px"
					
					var T=N
					var P=wp.getPosition(E);
					var D=wp.getDimension(E);
					var S=wp.getScrolling(document);
					
					if(E.id!="wpEdH")
					{
						wp(T).setPosition({top:P.top-4,left:P.left-4}).setDimension({height:D.height+4,width:D.width+4})
					}
					
					T.style.zIndex=0
					
					//T.style.display="block"
					
					
					
				var a=wp.get(W.id+"contentEdit")
				a.contentWindow.document.body.innerHTML=E.innerHTML
				
				//wp.debug.objects(a.contentWindow.document.body)
					

					if(E.tagName=="A")
					{
						wp.addEvent(E,'click',function(e){
							wp.cancelEvent(e);
							return false
						})
					}
				})

				wp.addEvent(document.body,'mousedown',function(e){
					//wp.cancelEvent(e);
					//return false
					
				})

				wp.addEvent(document.body,'click',function(e){
					
					
					//wp.cancelEvent(e);
					//return false
					
				})
			}
		},	
	DELETE_all:function(o,f)
	{
		var v=wp.get_Obj(o,this);
		if(v.length){
			for(O in v)f.call(this,v[O],O)
		}
		else{
			f.call(this,v)
		}
	},		
	progUpdate:function()
	{
			var A=wp.get("_WP_pBar")
			
			if(!A)
			{
				
				//document.write("<div id=_WP_pBar style='border:1px solid black'><br></div>")
				
				
				

				A=wp.addNode(document.getElementsByTagName('HEAD').item(0),"DIV")
				A.id="_WP_pBar"
				A.style.border="1px solid black"
				A.style.position="absolute"
				A.style.top="100px"
				A.style.left="100px"

			}
			
			A.innerHTML=A.innerHTML+"loading: "
			A.innerHTML=A.innerHTML+".......done<br>"
				
	}		
	})
	wp.fN.init.prototype = wp.fN;
})()


wp.extend({
	debug:{
		objects:function(v)
		{
			if(!wp.docState){
				setTimeout(function(){wp(this.v).debug.objects(v)},20)
				return this
			}
			//var a=wp.get("wpObj_P");
			//if(!a)
			//{
			
				var a=document.createElement("div");
				document.body.appendChild(a);
				a.id="wpObj_P";
				a.className="wpDebug"
				//a.style.height="400px"
				a.style.top="60px"

				//a.innerHTML="aaa"
				
				wp(a).into("window",{height:400,onload:function(){
					wp.css.add("","debug");
					wp.debug.createLinks(a,v);
				}})
				
				
				
				
				
				
				
				//.ondone(function(){
//					wp.css.add("","debug");
					//wp.debug.createLinks(a,v);
				//})
				
			//}
			//else{
				
				//wp(a).changeWindowContent(h)
				//a.style.display="block"
				//wp.debug.createLinks(a,v);
			//}
			return this
		},
		createLinks:function(a,v,S)
		{
			var A,P
			a.innerHTML=""

			var V={}
			if(S)V['back']=S;
			
			
			V['wp']=wp(this)
			
			for(var i in v){
				try{V[i]=v[i]}catch(err){}
				
			}
			v=V
			
			for(var _cO in V){
				try{
						
					P=wp.addNode(a,"p");
					P.innerHTML=_cO+" - "
					
					A=wp.addNode(P,"a");
					A.innerHTML=V[_cO]
					A.obj=_cO
					
					if(v[_cO]&& typeof(v[_cO])==="object"){
						A.href="#"
						A.onclick=function(){
							wp.debug.createLinks(a,v[this.obj], a.S);
							return false;
						}
					}	
				}catch(err){}
				
			}
			a.S=v
		}
	}
})

	wp.extend({
		toarray:function(v){
			if(!v)v="";
			return this.split(v)
		}

	},String.prototype)

/* Remove this as we no longer support IE5.5 or below 
	if(wp.msie<5.5){
		wp.extend({
			push:function(v){this[this.length]=v}
		},Array.prototype)
		
		wp.extend({
			getElementsByTagName:function(str){return(str=='*')?document.all:document.all.tags(str)}
		},document)
	}

*/
wp.mouseY=wp.mouseX=0
wp.addEvent(document,"mousemove",function(e){
	var mp=wp.getMouseCoords(e)
	wp.mouseX=mp.x
	wp.mouseY=mp.y
})
wp.ready()
