/*
	
	  Webplugs JavaScript Framework - http://www.webplugs.net/
	  
	     Module: window.js
	    Version: 0.4.8100
	      Built: January 20 2011
	    License: Milonic Shared Source License
	    Details: Webplugs Window module
	  
	  Copyright (c) 2011, Milonic Solutions Limited. All Rights Reserved
	  Please see http://www.webplugs.net/licensing for licensing details, not all Webplugs Modules are Open Source
	  
*/


/*
todo:Ensure that back and forward buttons reset the previous scrollTop and scrollLeft values

*/


wp.dependencies("resize,css,dragdrop,dialog,position,imask");

wp.extend(
	{		
		windowable:function(o)
		{
			o=wp.bob(o)
			if(!wp.modals)wp.modals=[]
			wp.each(this.v,function(a,i){
				var I=a[i],S="",H="";
				if(I.tagName=="A")I=wp.addNode("div")
				I=wp.sObj(I,o,"window");
				I.webplug=null
			
				if(!I.id){
					if(o.id)I.id=o.id; else 
					I.id="wpWind__"+wp.uId++
				}
			
				//I.style.height="auto" // Breaks resize(bottom) handle position without setting height back to auto
				I.style.position="absolute"
				
				if(typeof(o.resizable)=="undefined"){
					if(o.type!="modal")o.resizable=true
				}

				// Add properties to specify min, max and close buttons - 
				// Add a property to disable certain stuff if this type of window is a dialog (modal) box

				
				if(!o.theme)o.theme="Webplugs"
				wp.css.add(o,"window");
				o.H=I.innerHTML;
				if(!o.title)o.title="";
	
				var minMaxButtons=""
				if(o.type!="modal"){
					minMaxButtons='<a href=# class=wpWinMin onmouseup="wp.window.min(this)" onclick="return false">&nbsp;</a>'
					+'<a href=# class=wpWinMax onmouseup="wp.window.max(this)" onclick="return false"&nbsp;</a>'
				}

				var tmp
				var WC=wp.wrapNode(I,"div",true);
				if(o.height)I.style.height=wp.px(o.height)
				if(o.css)wp(WC).strCSS(o.css)
				if(o.contentCSS)wp(WC).strCSS(o.contentCSS)
				var W=wp.wrapNode(WC,"div",true);
				W.webplug="window"
				
				var tmp=wp.addNode(W,"div",true);
				tmp.className="wpWinHead"
				tmp.innerHTML=	'<span class=wpWinHeadleft></span>'
								+'<span class=wpWinBG>'		
									+'<span class=wpWinIcon></span>'
									+'<span class=wpWinTitle>'+o.title+'</span>'
								+'</span>'
								+minMaxButtons
								+'<a href=# class=wpWinExit onmouseup="wp.window.close(this);" onclick="return false">&nbsp;</a>'
								+'<span class=wpWinHeadright></span>'
				WC.className="wpWinBody"
				
				I.className="wpWinContent"


				if(o.topbar){
					tmp=wp.addNode(WC,"div",true);
					tmp.className="wpWinTopbar"
					var TB=wp.get(o.topbar);
					wp.moveNode(TB,tmp)
					wp.removeNode(tmp)
				}
				
				tmp=wp.addNode(WC,"div");
				tmp.className="wpWinBottom";
				
				if(o.bottombar){
					tmp=wp.addNode(tmp,"div");
					var BB=wp.get(o.bottombar);
					wp.moveNode(BB,tmp)
					wp.removeNode(tmp)
					tmp.className="wpWinStatusbar"
				}

				wp(W).addCSSName("wp"+o.theme+"Window");
				W.content=I
				//W.title=o.title

				wp.addEvent(document,"keyup",function(e){
					//var mp=wp.getMouseCoords(e)
					//wp.mouseX=mp.x
					//wp.mouseY=mp.y
					//if(e.keyCode==27)wp.window.close(I)
				
					//wp.debug.objects(e)
					//alert(e)
					//wp.key=e
					
				})
				
				
				W.wpObject=o

				if(o.width)W.style.width=wp.px(o.width);
				
				if(wp.msie<7&&W.offsetWidth%2==0)W.style.width=W.offsetWidth+1; //fixes a weired bug in IE6 setting wrong width...... must be an odd number
				
				if(o.open)wp(W).openWindow()
	
				if(o.resizable)wp(W).resizable({onresize:o.onresize,minWidth:150,bottom:"wpWinContent"});
				wp(W.childNodes[0]).dragable({container:W});
			

				wp.addEvent(W,'mouseup',function(e){
					wp.tofront(W);
				})
	

				if(o.onload)o.onload.call(this,W);// Fire this event, if specified, when the window has loaded
				if(W.onload)W.onload.call(this,W);// Fire this event, if specified, when the window has loaded
				wp.imask.create(W);
				
				wp.tofront(W);
				if(o.align)wp(W).setAlignment(o.align)

				if(o.scrollbarTheme){
					//alert(o.scrollbarTheme)
					//T.content.webplug=null;
					//wp(I.content).into("scrollbar",{theme:o.scrollbarTheme});
					//alert(I.webplug)
				}
//W.style.visibility="visible"

				
			})
			return this
		},
		openWindow:function(o,d)
		{
			wp.each(this.v,function(a,i){
				if(a[i].wpObject&&a[i].wpObject.type=="modal"){
					if(d=="none"){
						wp.enablePage(a[i]);}
					else{
						wp.disablePage(a[i])
						wp.modals.push(a[i])
					}
				}
				a[i].style.display=d||"block";
				wp.tofront(a[i]);
			})
			return this;
		},
		//changeWindowPage:function(t,wName)
		//{
//			wp.each(this.v,function(a,i){
				//var T=wp.parentPlug(a[i],"window")
				//T.content.innerHTML=T.store[wName];
				//T.store.currentPage=wName
			//})
			//return this			
//		},
		windowHome:function(t)
		{
			wp.each(this.v,function(a,i){
				var T=wp.parentPlug(a[i],"window")
				T.store[0].style.display="block"
				T.store[T.currentPage].style.display="none"
			})
		},
		windowBack:function(t,wName)
		{
			wp.each(this.v,function(a,i){
				var T=wp.parentPlug(a[i],"window"),o=T.wpObject
				if(T.currentPage>0){
					T.store[T.currentPage].style.display="none"
					T.currentPage--;
					wp(T).changeWindowTitle(T.store[T.currentPage].winTitle)
					T.store[T.currentPage].style.display="block"
					if(o.onchange)o.onchange(T.store[T.currentPage])
				}
				if(o.align)wp(T).setAlignment(o.align)
			})
			return this
		},
		windowForward:function(t,wName)
		{
			wp.each(this.v,function(a,i){
				var T=wp.parentPlug(a[i],"window"),o=T.wpObject
				
				if((T.currentPage>=0) && (T.currentPage+1<T.store.length)){	
					T.store[T.currentPage].style.display="none"
					T.currentPage++;
					wp(T).changeWindowTitle(T.store[T.currentPage].winTitle)
					T.store[T.currentPage].style.display="block"
					if(o.onchange)o.onchange(T.store[T.currentPage])
				}
				if(o.align)wp(T).setAlignment(o.align)
			})
			return this
		},
		changeWindowContent:function(t,wName,winTitle) // may need to change this to changeContent
		{
			if(!winTitle)winTitle="Webplugs Window";
			wp.each(this.v,function(a,i){
				var T=wp.parentPlug(a[i],"window"),o=T.wpObject
				//if(wName){ // Store pages in memory, saves reloading them and means we can have back and forward buttons for pages
					
					if(!T.store){
						T.store=[]
						T.store.push(wp.seek(".wpWinContent",T)[0])
						T.store[0].winTitle=a[i].winTitle
						T.store[0].name="start"
						T.currentPage=0
					}
					
					T.store[T.currentPage].style.display="none"

					var TL=T.store.length
					for(var V=T.currentPage;V<TL-1;V++){
						wp.removeNode(T.store[T.store.length-1])
						T.store.pop()
					}
					
					if(T.currentPage==0 || wName!=T.store[T.currentPage-1].name){
						T.store.push(wp.addNode(wp.seek(".wpWinBody",T)[0],"div"))
						T.currentPage=T.store.length-1
						T.store[T.currentPage].className="wpWinContent"
						T.store[T.currentPage].winTitle=winTitle
						T.store[T.currentPage].name=wName
						
						//alert(a[i].value)
						//document.winTitle=T.store.length
						
						
//wp.debug.objects(T)
					if(T.content.webplug=="scrollbar"){
//						wp.seek(".wpVenomSBC",T.content)[0].innerHTML=T.store[T.currentPage].content;
					}
					else{
	//					T.content.innerHTML=T.store[T.currentPage].content;
					}

						
					wp.processHTML(T.store[T.currentPage],t);
					}
//wp.window.currentPage=T.currentPage
					if(winTitle)wp(T).changeWindowTitle(winTitle)
					if(o.onContentChange)o.onContentChange.call(this,T.content);// Fire this event, if specified, when the window has loaded
					//document.title=(T.store.length-1) +" - " + Date()
					//return
				//}
				
				//alert(o.align)
				if(o.align)wp(T).setAlignment(o.align)
				
				//alert(wp.seek(".sbC",T))
				
				
			})
			return this
		},
		changeWindowTitle:function(v)
		{
			wp.each(this.v,function(a,i){
				var T=wp.parentPlug(a[i],"window")
				wp.seek(".wpWinTitle",T)[0].innerHTML=v
			})
			return this
		},
		window:{
			exec:function(v,o)
			{
				wp(v).windowable(o);
			},

			create:function(o)
			{
				var win=wp.addNode(document.body,"div")
				if(!o)o={}
				if(o.content)win.innerHTML=o.content
				if(!o.theme)o.theme=wp.defaultTheme
				if(!o.theme)o.theme="Webplugs"
				var tBar=wp.addNode(win,"div")

				tBar.id="id"+wp.uId++;
				o.topbar=tBar.id
				
					


				if(o.status){
					var bBar=wp.addNode(win,"div")
					bBar.id="id"+wp.uId++;
					o.bottombar=bBar.id
					bBar.innerHTML=o.status
				}
				
				wp(win).windowable(o);

				tBar=wp.get(tBar.id)
				if(o.menu){
					var menu=wp.addNode(tBar,"div")
					wp(menu).into("menu",{data:o.menu,orientation:"horizontal",theme:o.theme})
				}

				if(o.toolbar){
					var toolbar=wp.addNode(tBar,"div")
					wp(toolbar).into("toolbar",{data:o.toolbar,theme:o.theme})		
				}

				return win
			},
			open:function(o)
			{
				wp.openWindow(o)
				return wp;
			},
			close:function(T)
			{
				T=wp.parentPlug(T,"window")
				wp.wpAction(T,"close")
				if(T.wpObject.type=="modal")wp.enablePage(T)
				T.style.display="none";
				wp(T).removeNode()
				return wp;
			},
			max:function(o)
			{
				var T=o.parentNode.parentNode
				wp.wpAction(T,"maximize")

				if(T.wpSize!="max"){
					T.style.overflow="hidden";
					T.wpOldWidth=T.offsetWidth
					T.wpOldHeight=T.offsetHeight
					T.wpOldTop=T.offsetTop
					T.wpOldLeft=T.offsetLeft
					T.style.top="0px"
					T.style.left="0px"
					T.style.height=wp.px(wp.clientDims().height);
					
					//T.parentNode.style.height="700px"
					
					//T.style.width=wp.px(wp.clientDims().width);
					T.style.width="100%";
					T.wpSize="max";
				}
				else{
					T.style.overflow="visible";
					T.style.width=wp.px(T.wpOldWidth);
					T.style.height=wp.px(T.wpOldHeight);
					T.style.top=wp.px(T.wpOldTop);
					T.style.left=wp.px(T.wpOldLeft);
					T.wpSize="norm"
				}
				
			},
			min:function(o)
			{
				var T=o.parentNode.parentNode;
				wp.wpAction(T,"minimize");
				
				if(T.wpSize!="min"){
					T.style.overflow="hidden";
					T.wpOldWidth=T.offsetWidth
					T.wpOldHeight=T.offsetHeight
					T.style.height=wp.px(wp.seek(".wpWinHead",T)[0].offsetHeight);
					T.wpSize="min";
				}
				else{
					T.style.overflow="visible";
					//T.style.width=wp.px(T.wpOldWidth);
					T.style.height=wp.px(T.wpOldHeight);
					
					//T.style.height="100px";
					T.style.height="0px";
					
					T.wpSize="norm"
				}
			}
		}
	}
)	

